/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_join"}, parameter="(Array array, String delimiter[, String nullReplacement])", descriptions={"- Return \"\" if any parameter is null;", "- Return a string indicating that the elements in the given 'array' are concatenated using a 'delimiter', and empty array elements are filled with 'nullReplacement'.", "- Note: If nullReplacement is not specified, null elements in the array will be omitted from the resulting string."}, examples={"array_join(array('he',7,'xxd'),'~') = he~7~xxd", "array_join(array('he',3,''),'~','oo') = he~3~oo"})
public class ArrayJoinFunction
implements ValueParser {
    private ValueParser arrayParser;
    private ValueParser delimiterParser;
    private ValueParser nullReplacementParser;

    public ArrayJoinFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (expressions.size() >= 2) {
            this.arrayParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.delimiterParser = OperatorTools.buildParser((Expression)expressions.get(1));
            if (expressions.size() >= 3) {
                this.nullReplacementParser = OperatorTools.buildParser((Expression)expressions.get(2));
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        Object delimiterObj = this.delimiterParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null || delimiterObj == null) {
            return null;
        }
        String delimiter = OperatorTools.parseString(delimiterObj);
        if (delimiter.isEmpty()) {
            return null;
        }
        String nullReplacement = this.parseNullReplacement(sourceData, rowIndex, context);
        if (arrayObj instanceof ArrayList) {
            return this.joinArrayWithDelimiter((ArrayList)arrayObj, delimiter, nullReplacement);
        }
        return null;
    }

    private String joinArrayWithDelimiter(ArrayList<?> array, String delimiter, String nullReplacement) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            String element = (String)array.get(i);
            if (element == null || element.isEmpty()) {
                if (nullReplacement != null && !nullReplacement.isEmpty()) {
                    result.append(nullReplacement);
                }
            } else {
                result.append(element);
            }
            if (i >= array.size() - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    private String parseNullReplacement(SourceData sourceData, int rowIndex, Context context) {
        if (this.nullReplacementParser != null) {
            Object nullReplacementObj = this.nullReplacementParser.parse(sourceData, rowIndex, context);
            return OperatorTools.parseString(nullReplacementObj);
        }
        return null;
    }
}

