/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.compression.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.sdk.transform.process.function.compression.handler.CompressHandler;
import org.apache.inlong.sdk.transform.process.function.compression.handler.DeflaterCompress;
import org.apache.inlong.sdk.transform.process.function.compression.handler.GzipCompress;
import org.apache.inlong.sdk.transform.process.function.compression.handler.ZipCompress;

public class CompressionAlgorithmFactory {
    private static Map<String, CompressHandler> compressMap = new ConcurrentHashMap<String, CompressHandler>();

    public static CompressHandler getCompressHandlerByName(String name) {
        return compressMap.get(name);
    }

    static {
        compressMap.put("deflater", new DeflaterCompress());
        compressMap.put("gzip", new GzipCompress());
        compressMap.put("zip", new ZipCompress());
    }
}

