/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.encryption;

import java.nio.charset.StandardCharsets;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="encryption", names={"md5"}, parameter="(String string)", descriptions={"- Return \"\" if the 'string' is NULL;", "- Return the MD5 hash value of 'string' in the form of a 32-bit hexadecimal digit string."}, examples={"md5(\"\") = \"d41d8cd98f00b204e9800998ecf8427e\"", "md5(\"1\") = \"c4ca4238a0b923820dcc509a6f75849b\""})
public class Md5Function
implements ValueParser {
    private ValueParser msgParser;

    public Md5Function(Function expr) {
        this.msgParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object msgObj = this.msgParser.parse(sourceData, rowIndex, context);
        if (msgObj == null) {
            return null;
        }
        String msg = msgObj.toString();
        return DigestUtils.md5Hex((byte[])msg.getBytes(StandardCharsets.UTF_8));
    }
}

