/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_array_insert"}, parameter="(String json_doc, String path1, String val1[, String path2, String val2, ...] )", descriptions={"- Return \"\" if any argument is NULL;", "- Return the 'json_doc' inserted into the array.", "Note: If multiple groups of parameters are passed in, the parameter subscripts of the latter groups need to be based on the document subscripts after the previous group of parameters are updated."}, examples={"json_array_append([\"a\", {\"b\": [1, 2]}, [3, 4]], $[1], x) = [\"a\",\"x\",{\"b\":[1,2]},[3,4]]"})
public class JsonArrayInsertFunction
implements ValueParser {
    private ValueParser jsonDocParser;
    private List<ValueParser> pathValuePairsParser;

    public JsonArrayInsertFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.jsonDocParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.pathValuePairsParser = new ArrayList<ValueParser>();
        for (int i = 1; i < expressions.size(); ++i) {
            this.pathValuePairsParser.add(OperatorTools.buildParser((Expression)expressions.get(i)));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object jsonDocObj = this.jsonDocParser.parse(sourceData, rowIndex, context);
        if (jsonDocObj == null) {
            return null;
        }
        ArrayList<Object> pathValuePairs = new ArrayList<Object>();
        for (ValueParser valueParser : this.pathValuePairsParser) {
            pathValuePairs.add(valueParser.parse(sourceData, rowIndex, context));
        }
        return this.jsonArrayInsert(jsonDocObj.toString(), pathValuePairs);
    }

    private String jsonArrayInsert(String jsonDoc, ArrayList<Object> pathValuePairs) {
        if (jsonDoc == null || pathValuePairs == null || pathValuePairs.size() % 2 != 0) {
            return null;
        }
        Object jsonObject = JSON.parse((String)jsonDoc);
        for (int i = 0; i < pathValuePairs.size(); i += 2) {
            String path = (String)pathValuePairs.get(i);
            Object value = pathValuePairs.get(i + 1);
            if (!path.endsWith("]")) {
                throw new IllegalArgumentException("Path must end with an array index: " + path);
            }
            String parentPath = path.substring(0, path.lastIndexOf(91));
            Object parentNode = JSONPath.eval((Object)jsonObject, (String)parentPath);
            if (parentNode instanceof JSONArray) {
                this.insertIntoArray((JSONArray)parentNode, path, value);
                continue;
            }
            if (parentNode instanceof JSONObject) {
                String arrayIndexPart = path.substring(path.lastIndexOf(91), path.lastIndexOf(93) + 1);
                this.handleArrayInsertionInObject((JSONObject)parentNode, arrayIndexPart, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid path or target node is not an array or object: " + path);
        }
        return JSON.toJSONString((Object)jsonObject);
    }

    private void insertIntoArray(JSONArray array, String path, Object value) {
        String indexPart = path.substring(path.lastIndexOf(91) + 1, path.lastIndexOf(93));
        int index = Integer.parseInt(indexPart);
        if (index >= array.size()) {
            index = array.size();
        }
        try {
            array.add(index, JSON.parse((String)value.toString()));
        }
        catch (Exception ignored) {
            array.add(index, value);
        }
    }

    private void handleArrayInsertionInObject(JSONObject jsonObject, String arrayPart, Object value) {
        String arrayField = arrayPart.substring(1, arrayPart.length() - 1);
        JSONArray array = jsonObject.getJSONArray(arrayField);
        if (array != null) {
            this.insertIntoArray(array, arrayPart, value);
        }
    }
}

