/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_replace"}, parameter="(String json_doc, String path1, String val1[, String path2, String val2, ...] )", descriptions={"- Return \"\" if any argument is NULL or the 'json_doc' argument is not a valid JSON document or any path argument is not a valid path expression or contains a * or ** wildcard;", "- Return the result of replacing existing values in 'json_doc'."}, examples={"json_replace(\"{ \\\"a\\\": 1, \\\"b\\\": [2, 3]}\", \"$.a\", 10, \"$.c\", \"[true, false]\") = {\"a\": 10, \"b\": [2, 3]}"})
public class JsonReplaceFunction
implements ValueParser {
    private ValueParser jsonDocParser;
    private List<ValueParser> pathValuePairsParser;

    public JsonReplaceFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.jsonDocParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.pathValuePairsParser = new ArrayList<ValueParser>();
        for (int i = 1; i < expressions.size(); ++i) {
            this.pathValuePairsParser.add(OperatorTools.buildParser((Expression)expressions.get(i)));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object jsonDocObj = this.jsonDocParser.parse(sourceData, rowIndex, context);
        if (jsonDocObj == null) {
            return null;
        }
        ArrayList<Object> pathValuePairs = new ArrayList<Object>();
        for (ValueParser valueParser : this.pathValuePairsParser) {
            pathValuePairs.add(valueParser.parse(sourceData, rowIndex, context));
        }
        return this.jsonReplace(jsonDocObj.toString(), pathValuePairs);
    }

    private String jsonReplace(String jsonDoc, ArrayList<Object> pathValuePairs) {
        if (jsonDoc == null || pathValuePairs == null || pathValuePairs.size() % 2 != 0) {
            return null;
        }
        Object json = JSON.parse((String)jsonDoc);
        for (int i = 0; i < pathValuePairs.size(); i += 2) {
            String path = (String)pathValuePairs.get(i);
            Object value = pathValuePairs.get(i + 1);
            if (path.equals("$")) {
                try {
                    json = JSON.parse((String)value.toString());
                }
                catch (Exception ignored) {
                    json = value;
                }
                continue;
            }
            if (path.contains("*") || path.contains("**")) {
                throw new IllegalArgumentException("Invalid path expression: " + path);
            }
            if (!JSONPath.contains((Object)json, (String)path)) continue;
            try {
                JSONPath.set((Object)json, (String)path, (Object)JSON.parse((String)value.toString()));
                continue;
            }
            catch (Exception ignored) {
                JSONPath.set((Object)json, (String)path, (Object)value);
            }
        }
        return json.toString();
    }
}

