/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"regexp_matches"}, parameter="(String source_string, String regexp [,String flags])", descriptions={"- Return \"\" if any of the arguments are NULL or invalid;", "- Return the result of the first match of the specified regular expression 'regexp' from 'source_string'. Note: 'flags' is one of  ('g' -> flag can be used when we want to match all the substrings that occur, 'i' -> flag to ignore case for matching, 'x' -> flag to extend syntax (ignoring whitespace and comments in regular expressions), 'm' and 'n' -> flag allows regular expressions to match across multiple lines)"}, examples={"regexp_matches(\"The quick brown fox\", \"quick\") = [{\"quick\"}]", "regexp_matches(\"foo 123 bar 456\", \"\\\\d+\", \"g\") = [{\"123\"},{\"456\"}]"})
public class RegexpMatchesFunction
implements ValueParser {
    private ValueParser inputParser;
    private ValueParser patternParser;
    private ValueParser flagParser;

    public RegexpMatchesFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null) {
            this.inputParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.patternParser = OperatorTools.buildParser((Expression)expressions.get(1));
            if (expressions.size() == 3) {
                this.flagParser = OperatorTools.buildParser((Expression)expressions.get(2));
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        String inputString = OperatorTools.parseString(this.inputParser.parse(sourceData, rowIndex, context));
        String patternString = OperatorTools.parseString(this.patternParser.parse(sourceData, rowIndex, context));
        String flagString = "";
        if (this.flagParser != null) {
            flagString = OperatorTools.parseString(this.flagParser.parse(sourceData, rowIndex, context));
        }
        return this.regexpMatches(inputString, patternString, flagString);
    }

    private String regexpMatches(String input, String regex, String flags) {
        int flag = 0;
        if (flags != null) {
            if (flags.contains("i")) {
                flag |= 2;
            }
            if (flags.contains("m") || flags.contains("n")) {
                flag |= 8;
            }
            if (flags.contains("s")) {
                flag |= 0x20;
            }
            if (flags.contains("x")) {
                flag |= 4;
            }
        }
        Pattern pattern = Pattern.compile(regex, flag);
        Matcher matcher = pattern.matcher(input);
        boolean isGlobalMatch = flags != null && flags.contains("g");
        ArrayList<String[]> matches = new ArrayList<String[]>();
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            String[] matchGroups = new String[groupCount > 0 ? groupCount : 1];
            for (int i = 0; i <= groupCount; ++i) {
                matchGroups[i == 0 ? 0 : i - 1] = matcher.group(i) != null ? matcher.group(i) : "";
            }
            matches.add(matchGroups);
            if (isGlobalMatch) continue;
            break;
        }
        return this.listToString(matches);
    }

    private String listToString(List<String[]> listOfArrays) {
        return listOfArrays.stream().map(array -> Arrays.stream(array).map(s -> "\"" + s + "\"").collect(Collectors.joining(",", "{", "}"))).collect(Collectors.joining(",", "[", "]"));
    }
}

