/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.math.BigInteger;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformParser(values={BitwiseOr.class})
public class BitwiseOrParser
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(BitwiseOrParser.class);
    private final ValueParser left;
    private final ValueParser right;

    public BitwiseOrParser(BitwiseOr expr) {
        this.left = OperatorTools.buildParser(expr.getLeftExpression());
        this.right = OperatorTools.buildParser(expr.getRightExpression());
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        try {
            Object leftObj = this.left.parse(sourceData, rowIndex, context);
            Object rightObj = this.right.parse(sourceData, rowIndex, context);
            if (leftObj == null || rightObj == null) {
                return null;
            }
            BigInteger leftValue = OperatorTools.parseBigDecimal(leftObj).toBigInteger();
            BigInteger rightValue = OperatorTools.parseBigDecimal(rightObj).toBigInteger();
            return Long.toUnsignedString(leftValue.or(rightValue).longValue());
        }
        catch (Exception e) {
            log.error("Value parsing failed", (Throwable)e);
            return null;
        }
    }
}

