/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import org.apache.inlong.common.util.StringUtil;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformParser(values={LikeExpression.class})
public class LikeParser
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(LikeParser.class);
    private final ValueParser destParser;
    private final ValueParser patternParser;
    private final ValueParser escapeParser;
    private final boolean isNot;
    private static final String REGEX_SPECIAL_CHAR = "[]()|^-+*?{}$\\.";

    public LikeParser(LikeExpression expr) {
        this.destParser = OperatorTools.buildParser(expr.getLeftExpression());
        this.patternParser = OperatorTools.buildParser(expr.getRightExpression());
        this.escapeParser = OperatorTools.buildParser(expr.getEscape());
        this.isNot = expr.isNot();
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object escapeObj;
        Object destObj = this.destParser.parse(sourceData, rowIndex, context);
        Object patternObj = this.patternParser.parse(sourceData, rowIndex, context);
        if (destObj == null || patternObj == null) {
            return null;
        }
        char escapeChr = '\\';
        if (this.escapeParser != null && !StringUtil.isEmpty((Object)(escapeObj = this.escapeParser.parse(sourceData, rowIndex, context)))) {
            escapeChr = escapeObj.toString().charAt(0);
        }
        String destStr = destObj.toString();
        String pattern = patternObj.toString();
        try {
            String regex = this.buildLikeRegex(pattern, escapeChr);
            boolean isMatch = Pattern.matches(regex.toLowerCase(), destStr.toLowerCase());
            if (this.isNot) {
                return !isMatch;
            }
            return isMatch;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String buildLikeRegex(String pattern, char escapeChar) {
        int len = pattern.length();
        StringBuilder regexPattern = new StringBuilder(len + len);
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (REGEX_SPECIAL_CHAR.indexOf(c) >= 0) {
                regexPattern.append('\\');
            }
            if (c == escapeChar) {
                if (i == pattern.length() - 1) {
                    regexPattern.append(c);
                    continue;
                }
                char nextChar = pattern.charAt(i + 1);
                if (nextChar == '_' || nextChar == '%' || nextChar == escapeChar) {
                    regexPattern.append(nextChar);
                    ++i;
                    continue;
                }
                throw new RuntimeException("Illegal pattern string");
            }
            if (c == '_') {
                regexPattern.append('.');
                continue;
            }
            if (c == '%') {
                regexPattern.append("(?s:.*)");
                continue;
            }
            regexPattern.append(c);
        }
        return regexPattern.toString();
    }
}

