/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.sdk.transform.process.pojo.IntervalInfo;

public class DateUtil {
    private static final List<ChronoField> CHRONO_FIELD_LIST = Arrays.asList(ChronoField.YEAR, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MICRO_OF_SECOND);
    private static final Map<String, DateTimeFormatter> DATE_TIME_FORMATTER_MAP = new LinkedHashMap<String, DateTimeFormatter>();
    private static final Map<String, DateTimeFormatter> TIME_FORMATTER_MAP = new LinkedHashMap<String, DateTimeFormatter>();
    public static String YEAR_TO_MICRO = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static String YEAR_TO_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static String YEAR_TO_MONTH = "yyyy-MM-dd";
    public static String HOUR_TO_MICRO = "HH:mm:ss.SSSSSS";
    public static String HOUR_TO_SECOND = "HH:mm:ss";

    public static String dateTypeAdd(String dateStr, IntervalInfo intervalInfo, boolean isPositive) {
        Comparable<ChronoLocalDateTime<?>> dateParserObj = DateUtil.parseLocalDateTime(dateStr);
        if (dateParserObj != null) {
            return DateUtil.addDateTime(dateStr, dateParserObj, intervalInfo, isPositive);
        }
        dateParserObj = DateUtil.parseLocalTime(dateStr);
        if (dateParserObj != null) {
            return DateUtil.addTime(dateStr, (LocalTime)dateParserObj, intervalInfo, isPositive);
        }
        return null;
    }

    public static LocalDateTime dateAdd(LocalDateTime localDateTime, LocalTime localTime) {
        return localDateTime.plusHours(localTime.getHour()).plusMinutes(localTime.getMinute()).plusSeconds(localTime.getSecond()).plusNanos(localTime.getNano());
    }

    public static LocalDateTime parseLocalDateTime(String dateStr) {
        LocalDateTime dateParserObj = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTER_MAP.values()) {
            try {
                dateParserObj = LocalDateTime.parse(dateStr, dateTimeFormatter);
            }
            catch (Exception e) {
                try {
                    dateParserObj = LocalDate.parse(dateStr, dateTimeFormatter).atStartOfDay();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dateParserObj == null) continue;
            return dateParserObj;
        }
        return null;
    }

    public static LocalTime parseLocalTime(String dateStr) {
        LocalTime dateParserObj = null;
        for (DateTimeFormatter dateTimeFormatter : TIME_FORMATTER_MAP.values()) {
            try {
                dateParserObj = LocalTime.parse(dateStr, dateTimeFormatter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dateParserObj == null) continue;
            return dateParserObj;
        }
        return null;
    }

    public static IntervalInfo parseIntervalInfo(DateTimeFormatter dateTimeFormatter, String dateStr, int factor) {
        TemporalAccessor temporalAccessor = dateTimeFormatter.parse(dateStr);
        HashMap<ChronoField, Long> map = new HashMap<ChronoField, Long>();
        for (ChronoField field : CHRONO_FIELD_LIST) {
            try {
                long num = temporalAccessor.getLong(field);
                if (num == 0L) continue;
                map.put(field, temporalAccessor.getLong(field));
            }
            catch (Exception exception) {}
        }
        return new IntervalInfo(factor, map);
    }

    public static DateTimeFormatter getDateTimeFormatter(String formatStr) {
        DateTimeFormatter formatter = DATE_TIME_FORMATTER_MAP.get(formatStr);
        if (formatter != null) {
            return formatter;
        }
        return TIME_FORMATTER_MAP.get(formatStr);
    }

    public static String addDateTime(String dateStr, LocalDateTime dateTime, IntervalInfo intervalInfo, boolean isPositive) {
        int factor = intervalInfo.getFactor();
        HashMap<ChronoField, Long> valueMap = intervalInfo.getChronoMap();
        int sign = isPositive ? 1 : -1;
        boolean hasTime = dateStr.indexOf(32) != -1;
        boolean hasMicroSecond = dateStr.indexOf(46) != -1;
        block9: for (ChronoField field : valueMap.keySet()) {
            long amount = (Long)valueMap.get(field) * (long)factor * (long)sign;
            switch (field) {
                case MICRO_OF_SECOND: {
                    hasTime = true;
                    hasMicroSecond = true;
                    dateTime = dateTime.plusNanos(amount * 1000L);
                    continue block9;
                }
                case SECOND_OF_MINUTE: {
                    hasTime = true;
                    dateTime = dateTime.plusSeconds(amount);
                    continue block9;
                }
                case MINUTE_OF_HOUR: {
                    hasTime = true;
                    dateTime = dateTime.plusMinutes(amount);
                    continue block9;
                }
                case HOUR_OF_DAY: {
                    hasTime = true;
                    dateTime = dateTime.plusHours(amount);
                    continue block9;
                }
                case DAY_OF_MONTH: {
                    dateTime = dateTime.plusDays(amount);
                    continue block9;
                }
                case MONTH_OF_YEAR: {
                    dateTime = dateTime.plusMonths(amount);
                    continue block9;
                }
                case YEAR: {
                    dateTime = dateTime.plusYears(amount);
                    continue block9;
                }
            }
            return null;
        }
        if (hasTime) {
            if (hasMicroSecond) {
                return dateTime.format(DATE_TIME_FORMATTER_MAP.get(YEAR_TO_MICRO));
            }
            return dateTime.format(DATE_TIME_FORMATTER_MAP.get(YEAR_TO_SECOND));
        }
        return dateTime.toLocalDate().toString();
    }

    public static String addTime(String dateStr, LocalTime time, IntervalInfo intervalInfo, boolean isPositive) {
        int factor = intervalInfo.getFactor();
        HashMap<ChronoField, Long> valueMap = intervalInfo.getChronoMap();
        boolean hasMicroSecond = dateStr.indexOf(46) != -1;
        int sign = isPositive ? 1 : -1;
        block6: for (ChronoField field : valueMap.keySet()) {
            long amount = (Long)valueMap.get(field) * (long)factor * (long)sign;
            switch (field) {
                case MICRO_OF_SECOND: {
                    hasMicroSecond = true;
                    time = time.plusNanos(amount * 1000L);
                    continue block6;
                }
                case SECOND_OF_MINUTE: {
                    time = time.plusSeconds(amount);
                    continue block6;
                }
                case MINUTE_OF_HOUR: {
                    time = time.plusMinutes(amount);
                    continue block6;
                }
                case HOUR_OF_DAY: {
                    time = time.plusHours(amount);
                    continue block6;
                }
            }
            return null;
        }
        if (hasMicroSecond) {
            return time.format(TIME_FORMATTER_MAP.get(HOUR_TO_MICRO));
        }
        return time.format(TIME_FORMATTER_MAP.get(HOUR_TO_SECOND));
    }

    static {
        DATE_TIME_FORMATTER_MAP.put(YEAR_TO_MICRO, DateTimeFormatter.ofPattern(YEAR_TO_MICRO));
        DATE_TIME_FORMATTER_MAP.put(YEAR_TO_SECOND, DateTimeFormatter.ofPattern(YEAR_TO_SECOND));
        DATE_TIME_FORMATTER_MAP.put(YEAR_TO_MONTH, DateTimeFormatter.ofPattern(YEAR_TO_MONTH));
        TIME_FORMATTER_MAP.put(HOUR_TO_MICRO, DateTimeFormatter.ofPattern(HOUR_TO_MICRO));
        TIME_FORMATTER_MAP.put(HOUR_TO_SECOND, DateTimeFormatter.ofPattern(HOUR_TO_SECOND));
    }
}

