/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.inlong.sdk.transform.decode.TransformException;

public class FieldToRowDataUtils {
    public static final String DAY_FORMAT = "yyyy-MM-dd";
    public static final String SECOND_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String MILLI_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
    private static final AtomicBoolean isIgnoreError = new AtomicBoolean(true);
    private static final Map<LogicalTypeRoot, FieldToRowDataConverter> converterMap = new ConcurrentHashMap<LogicalTypeRoot, FieldToRowDataConverter>();
    private static final ThreadLocal<Map<String, SimpleDateFormat>> formatLocal;

    public static void setIgnoreError(boolean isIgnoreError) {
        FieldToRowDataUtils.isIgnoreError.set(isIgnoreError);
    }

    public static boolean isIgnoreError() {
        return isIgnoreError.get();
    }

    public static void replaceConverter(LogicalTypeRoot type, FieldToRowDataConverter converter) {
        converterMap.put(type, converter);
    }

    public static FieldToRowDataConverter createConverter(LogicalType logicalType) {
        return FieldToRowDataUtils.wrapIntoNullableConverter(FieldToRowDataUtils.createFieldRowConverter(logicalType));
    }

    private static FieldToRowDataConverter wrapIntoNullableConverter(FieldToRowDataConverter converter) {
        return obj -> {
            if (obj == null) {
                return null;
            }
            return converter.convert(obj);
        };
    }

    private static FieldToRowDataConverter createFieldRowConverter(LogicalType fieldType) {
        LogicalTypeRoot type = fieldType.getTypeRoot();
        FieldToRowDataConverter converter = converterMap.get(type);
        if (converter != null) {
            return converter;
        }
        switch (type) {
            case ARRAY: {
                return obj -> {
                    Object[] array = (Object[])obj;
                    FieldToRowDataConverter elementConverter = FieldToRowDataUtils.createFieldRowConverter(((ArrayType)fieldType).getElementType());
                    Object[] converted = Arrays.stream(array).map(elementConverter::convert).toArray();
                    return new GenericArrayData(converted);
                };
            }
            case MAP: {
                return obj -> {
                    FieldToRowDataConverter keyConverter = FieldToRowDataUtils.createFieldRowConverter(((MapType)fieldType).getKeyType());
                    FieldToRowDataConverter valueConverter = FieldToRowDataUtils.createFieldRowConverter(((MapType)fieldType).getValueType());
                    Map map = (Map)obj;
                    HashMap<Object, Object> internalMap = new HashMap<Object, Object>();
                    for (Object k : map.keySet()) {
                        internalMap.put(keyConverter.convert(k), valueConverter.convert(map.get(k)));
                    }
                    return new GenericMapData(internalMap);
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + fieldType);
    }

    private static Object parseBoolean(Object obj) {
        try {
            return Boolean.parseBoolean(obj.toString());
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseTinyint(Object obj) {
        try {
            return Byte.parseByte(obj.toString());
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseSmallint(Object obj) {
        try {
            return Short.parseShort(obj.toString());
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseInteger(Object obj) {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseLong(Object obj) {
        try {
            return Long.parseLong(obj.toString());
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseFloat(Object obj) {
        try {
            return Float.valueOf(Float.parseFloat(obj.toString()));
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseDouble(Object obj) {
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseBinary(Object obj) {
        try {
            return obj.toString().getBytes();
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseVarchar(Object obj) {
        try {
            return StringData.fromString((String)((String)obj));
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseDate(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Date) {
                return ((Date)obj).toLocalDate().toEpochDay();
            }
            String strObj = obj.toString();
            Date date = FieldToRowDataUtils.parseDateTime(strObj);
            return date.toLocalDate().toEpochDay();
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Date parseDateTime(String str) {
        try {
            int length;
            Map<String, SimpleDateFormat> formatMap = formatLocal.get();
            if (formatMap == null) {
                formatLocal.set(new ConcurrentHashMap());
                formatMap = formatLocal.get();
            }
            if ((length = str.length()) == DAY_FORMAT.length()) {
                SimpleDateFormat format = formatMap.computeIfAbsent(DAY_FORMAT, k -> new SimpleDateFormat(DAY_FORMAT));
                java.util.Date dateTime = format.parse(str);
                return new Date(dateTime.getTime());
            }
            if (length == SECOND_FORMAT.length()) {
                SimpleDateFormat format = formatMap.computeIfAbsent(SECOND_FORMAT, k -> new SimpleDateFormat(SECOND_FORMAT));
                java.util.Date dateTime = format.parse(str);
                return new Date(dateTime.getTime());
            }
            SimpleDateFormat format = formatMap.computeIfAbsent(MILLI_FORMAT, k -> new SimpleDateFormat(MILLI_FORMAT));
            java.util.Date dateTime = format.parse(str);
            return new Date(dateTime.getTime());
        }
        catch (ParseException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private static Object parseTimeWithoutTimeZone(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Time) {
                return ((Time)obj).toLocalTime().toSecondOfDay() * 1000;
            }
            String strObj = obj.toString();
            Date date = FieldToRowDataUtils.parseDateTime(strObj);
            return new Time(date.getTime()).toLocalTime().toSecondOfDay() * 1000;
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseTimestampWithLocalTimeZone(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Timestamp) {
                return TimestampData.fromTimestamp((Timestamp)((Timestamp)obj));
            }
            String strObj = obj.toString();
            Date date = FieldToRowDataUtils.parseDateTime(strObj);
            return TimestampData.fromTimestamp((Timestamp)new Timestamp(date.getTime()));
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    private static Object parseDecimal(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof BigDecimal) {
                return DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)obj), (int)10, (int)0);
            }
            String strObj = obj.toString();
            return DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(strObj), (int)10, (int)0);
        }
        catch (RuntimeException e) {
            if (FieldToRowDataUtils.isIgnoreError()) {
                return null;
            }
            throw e;
        }
    }

    static {
        converterMap.put(LogicalTypeRoot.NULL, obj -> null);
        converterMap.put(LogicalTypeRoot.BOOLEAN, obj -> FieldToRowDataUtils.parseBoolean(obj));
        converterMap.put(LogicalTypeRoot.TINYINT, obj -> FieldToRowDataUtils.parseTinyint(obj));
        converterMap.put(LogicalTypeRoot.SMALLINT, obj -> FieldToRowDataUtils.parseSmallint(obj));
        converterMap.put(LogicalTypeRoot.INTERVAL_YEAR_MONTH, obj -> FieldToRowDataUtils.parseInteger(obj));
        converterMap.put(LogicalTypeRoot.INTEGER, obj -> FieldToRowDataUtils.parseInteger(obj));
        converterMap.put(LogicalTypeRoot.INTERVAL_DAY_TIME, obj -> FieldToRowDataUtils.parseLong(obj));
        converterMap.put(LogicalTypeRoot.BIGINT, obj -> FieldToRowDataUtils.parseLong(obj));
        converterMap.put(LogicalTypeRoot.FLOAT, obj -> FieldToRowDataUtils.parseFloat(obj));
        converterMap.put(LogicalTypeRoot.DOUBLE, obj -> FieldToRowDataUtils.parseDouble(obj));
        converterMap.put(LogicalTypeRoot.BINARY, obj -> FieldToRowDataUtils.parseBinary(obj));
        converterMap.put(LogicalTypeRoot.VARBINARY, obj -> FieldToRowDataUtils.parseBinary(obj));
        converterMap.put(LogicalTypeRoot.CHAR, obj -> FieldToRowDataUtils.parseVarchar(obj));
        converterMap.put(LogicalTypeRoot.VARCHAR, obj -> FieldToRowDataUtils.parseVarchar(obj));
        converterMap.put(LogicalTypeRoot.DATE, obj -> FieldToRowDataUtils.parseDate(obj));
        converterMap.put(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, obj -> FieldToRowDataUtils.parseTimeWithoutTimeZone(obj));
        converterMap.put(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, obj -> FieldToRowDataUtils.parseTimestampWithLocalTimeZone(obj));
        converterMap.put(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, obj -> FieldToRowDataUtils.parseTimestampWithLocalTimeZone(obj));
        converterMap.put(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, obj -> FieldToRowDataUtils.parseTimestampWithLocalTimeZone(obj));
        converterMap.put(LogicalTypeRoot.DECIMAL, obj -> FieldToRowDataUtils.parseDecimal(obj));
        formatLocal = new ThreadLocal();
    }

    public static interface FieldToRowDataConverter
    extends Serializable {
        public Object convert(Object var1);
    }
}

