/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.channel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.AbstractChannelSelector;
import org.apache.inlong.dataproxy.utils.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverChannelSelector
extends AbstractChannelSelector {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverChannelSelector.class);
    private static final String SELECTOR_PROPS = "selector.";
    private static final String MASTER_CHANNEL = "master";
    private static final String TRANSFER_CHANNEL = "transfer";
    private static final String FILE_METRIC_CHANNEL = "fileMetric";
    private static final String SLA_METRIC_CHANNEL = "slaMetric";
    private static final String ORDER_CHANNEL = "order";
    private int masterIndex = 0;
    private int slaveIndex = 0;
    private final List<Channel> masterChannels = new ArrayList<Channel>();
    private final List<Channel> orderChannels = new ArrayList<Channel>();
    private final List<Channel> slaveChannels = new ArrayList<Channel>();
    private final List<Channel> transferChannels = new ArrayList<Channel>();
    private final List<Channel> agentFileMetricChannels = new ArrayList<Channel>();
    private final List<Channel> slaMetricChannels = new ArrayList<Channel>();

    public List<Channel> getRequiredChannels(Event event) {
        ArrayList<Channel> retChannels = new ArrayList<Channel>();
        if (event.getHeaders().containsKey(TRANSFER_CHANNEL)) {
            retChannels.add(this.transferChannels.get(0));
        } else if (event.getHeaders().containsKey("file-check-data")) {
            retChannels.add(this.agentFileMetricChannels.get(0));
        } else if (event.getHeaders().containsKey("sla-metric-data")) {
            retChannels.add(this.slaMetricChannels.get(0));
        } else if (MessageUtils.isSyncSendForOrder(event)) {
            String partitionKey = (String)event.getHeaders().get("partitionKey");
            if (partitionKey == null) {
                partitionKey = "";
            }
            int channelIndex = Math.abs(partitionKey.hashCode()) % this.orderChannels.size();
            retChannels.add(this.orderChannels.get(channelIndex));
        } else {
            retChannels.add(this.masterChannels.get(this.masterIndex));
            this.masterIndex = (this.masterIndex + 1) % this.masterChannels.size();
        }
        return retChannels;
    }

    public List<Channel> getOptionalChannels(Event event) {
        ArrayList<Channel> retChannels = new ArrayList<Channel>();
        if (event.getHeaders().containsKey(TRANSFER_CHANNEL)) {
            retChannels.add(this.transferChannels.get(0));
        } else if (event.getHeaders().containsKey("file-check-data")) {
            retChannels.add(this.agentFileMetricChannels.get(0));
        } else if (event.getHeaders().containsKey("sla-metric-data")) {
            retChannels.add(this.slaMetricChannels.get(1));
        } else {
            retChannels.add(this.slaveChannels.get(this.slaveIndex));
            this.slaveIndex = (this.slaveIndex + 1) % this.slaveChannels.size();
        }
        return retChannels;
    }

    private List<String> splitChannelName(String channelName) {
        List<String> fileMetricList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)channelName)) {
            fileMetricList = Arrays.asList(channelName.split("\\s+"));
        }
        return fileMetricList;
    }

    public void configure(Context context) {
        String masters = context.getString(MASTER_CHANNEL);
        String transfer = context.getString(TRANSFER_CHANNEL);
        String fileMertic = context.getString(FILE_METRIC_CHANNEL);
        String slaMetric = context.getString(SLA_METRIC_CHANNEL);
        String orderMetric = context.getString(ORDER_CHANNEL);
        if (StringUtils.isEmpty((CharSequence)masters)) {
            throw new FlumeException("master channel is null!");
        }
        List<String> masterList = this.splitChannelName(masters);
        List<String> transferList = this.splitChannelName(transfer);
        List<String> fileMetricList = this.splitChannelName(fileMertic);
        List<String> slaMetricList = this.splitChannelName(slaMetric);
        List<String> orderMetricList = this.splitChannelName(orderMetric);
        for (Map.Entry entry : this.getChannelNameMap().entrySet()) {
            String channelName = (String)entry.getKey();
            Channel channel = (Channel)entry.getValue();
            if (masterList.contains(channelName)) {
                this.masterChannels.add(channel);
                continue;
            }
            if (transferList.contains(channelName)) {
                this.transferChannels.add(channel);
                continue;
            }
            if (fileMetricList.contains(channelName)) {
                this.agentFileMetricChannels.add(channel);
                continue;
            }
            if (slaMetricList.contains(channelName)) {
                this.slaMetricChannels.add(channel);
                continue;
            }
            if (orderMetricList.contains(channelName)) {
                this.orderChannels.add(channel);
                continue;
            }
            this.slaveChannels.add(channel);
        }
        LOG.info("Configure channels, masters={}, orders={}, slaves={}, transfers={}, agentFileMetrics={}, slaMetrics={}", new Object[]{this.masterChannels, this.orderChannels, this.slaveChannels, this.transferChannels, this.agentFileMetricChannels, this.slaMetricChannels});
    }
}

