/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.dispatch;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.dataproxy.dispatch.DispatchProfileCallback;
import org.apache.inlong.sdk.commons.protocol.ProxyEvent;

public class DispatchProfile {
    private final String inlongGroupId;
    private final String inlongStreamId;
    private final String uid;
    private List<ProxyEvent> events = new ArrayList<ProxyEvent>();
    private long createTime = System.currentTimeMillis();
    private long count = 0L;
    private long size = 0L;
    private long dispatchTime;
    private DispatchProfileCallback callback;
    private boolean isOrder;
    private int sendIndex;

    public DispatchProfile(String uid, String inlongGroupId, String inlongStreamId, long dispatchTime) {
        this.uid = uid;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.dispatchTime = dispatchTime;
    }

    public boolean addEvent(ProxyEvent event, long maxPackCount, long maxPackSize) {
        long eventLength = event.getBody().length;
        if (this.count >= maxPackCount || this.count > 0L && this.size + eventLength > maxPackSize) {
            return false;
        }
        this.events.add(event);
        ++this.count;
        this.size += eventLength;
        return true;
    }

    public boolean isTimeout(long createThreshold) {
        return createThreshold >= this.createTime;
    }

    public String getUid() {
        return this.uid;
    }

    public List<ProxyEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ProxyEvent> events) {
        this.events = events;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public long getDispatchTime() {
        return this.dispatchTime;
    }

    public void ack() {
        if (this.callback != null) {
            this.callback.ack(this.events.size());
        }
    }

    public void fail() {
        if (this.callback != null) {
            this.callback.fail();
        }
    }

    public boolean isResend() {
        return this.callback == null;
    }

    public DispatchProfileCallback getCallback() {
        return this.callback;
    }

    public void setCallback(DispatchProfileCallback callback) {
        this.callback = callback;
    }

    public int getSendIndex() {
        return this.sendIndex;
    }

    public void setSendIndex(int sendIndex) {
        this.sendIndex = sendIndex;
    }

    public boolean isOrder() {
        return this.isOrder;
    }

    public void setOrder(boolean order) {
        this.isOrder = order;
    }
}

