/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.apache.flume.Context;
import org.apache.flume.conf.Configurable;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.source.BaseSource;
import org.apache.inlong.dataproxy.utils.ConfStringUtils;
import org.apache.inlong.dataproxy.utils.EventLoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTcpSource
extends BaseSource
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SimpleTcpSource.class);
    private ServerBootstrap bootstrap;
    private boolean tcpNoDelay;
    private boolean tcpKeepAlive;
    private int highWaterMark;
    private boolean enableBusyWait;

    public SimpleTcpSource() {
        ConfigManager.getInstance().regIPVisitConfigChgCallback(this);
    }

    @Override
    public void configure(Context context) {
        logger.info("Source {} context is {}", (Object)this.getName(), (Object)context);
        super.configure(context);
        this.tcpNoDelay = context.getBoolean("tcpNoDelay", Boolean.valueOf(true));
        this.tcpKeepAlive = context.getBoolean("keepAlive", Boolean.valueOf(true));
        this.enableBusyWait = context.getBoolean("enableBusyWait", Boolean.valueOf(false));
        this.highWaterMark = ConfStringUtils.getIntValue(context, "highWaterMark", 65536);
        Preconditions.checkArgument((this.highWaterMark >= 0 ? 1 : 0) != 0, (Object)"65536 must be >= 0");
    }

    @Override
    public synchronized void startSource() {
        logger.info("start " + this.getCachedSrcName());
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup(this.maxAcceptThreads, this.enableBusyWait, (ThreadFactory)new DefaultThreadFactory(this.getCachedSrcName() + "-boss-group"));
        this.workerGroup = EventLoopUtil.newEventLoopGroup(this.maxWorkerThreads, this.enableBusyWait, (ThreadFactory)new DefaultThreadFactory(this.getCachedSrcName() + "-worker-group"));
        this.bootstrap = new ServerBootstrap();
        if (this.conLinger >= 0) {
            this.bootstrap.option(ChannelOption.SO_LINGER, (Object)this.conLinger);
        }
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.conBacklog);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.reuseAddress);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepAlive);
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.maxRcvBufferSize);
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.maxSendBufferSize);
        this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)this.highWaterMark);
        this.bootstrap.channel(EventLoopUtil.getServerSocketChannelClass(this.workerGroup));
        EventLoopUtil.enableTriggeredMode(this.bootstrap);
        this.bootstrap.group(this.acceptorGroup, this.workerGroup);
        this.bootstrap.childHandler((ChannelHandler)this.getChannelInitializerFactory());
        try {
            this.channelFuture = this.srcHost == null ? this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.srcPort)).sync() : this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.srcHost, this.srcPort)).sync();
        }
        catch (Throwable e) {
            logger.error("Source {} bind ({}:{}) error, program will exit! e = {}", new Object[]{this.getCachedSrcName(), this.srcHost, this.srcPort, e});
            System.exit(-1);
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    @Override
    public String getProtocolName() {
        return "tcp";
    }
}

