/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.AckMode;
import org.apache.kafka.raft.CandidateState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.FollowerState;
import org.apache.kafka.raft.FuturePurgatory;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.LogTruncationException;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.QuorumState;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.RequestManager;
import org.apache.kafka.raft.UnattachedState;
import org.apache.kafka.raft.VotedState;
import org.apache.kafka.raft.internals.KafkaRaftMetrics;
import org.apache.kafka.raft.internals.LogOffset;
import org.slf4j.Logger;

public class KafkaRaftClient
implements RaftClient {
    private static final int RETRY_BACKOFF_BASE_MS = 100;
    private final AtomicReference<GracefulShutdown> shutdown = new AtomicReference();
    private final Logger logger;
    private final Time time;
    private final int electionBackoffMaxMs;
    private final int fetchMaxWaitMs;
    private final KafkaRaftMetrics kafkaRaftMetrics;
    private final NetworkChannel channel;
    private final ReplicatedLog log;
    private final QuorumState quorum;
    private final Random random;
    private final RequestManager requestManager;
    private final FuturePurgatory<LogOffset> appendPurgatory;
    private final FuturePurgatory<LogOffset> fetchPurgatory;
    private final BlockingQueue<UnwrittenAppend> unwrittenAppends;

    public KafkaRaftClient(RaftConfig raftConfig, NetworkChannel channel, ReplicatedLog log, QuorumState quorum, Time time, FuturePurgatory<LogOffset> fetchPurgatory, FuturePurgatory<LogOffset> appendPurgatory, LogContext logContext) {
        this(channel, log, quorum, time, new Metrics(time), fetchPurgatory, appendPurgatory, raftConfig.quorumVoterConnections(), raftConfig.electionBackoffMaxMs(), raftConfig.retryBackoffMs(), raftConfig.requestTimeoutMs(), 1000, logContext, new Random());
    }

    public KafkaRaftClient(NetworkChannel channel, ReplicatedLog log, QuorumState quorum, Time time, Metrics metrics, FuturePurgatory<LogOffset> fetchPurgatory, FuturePurgatory<LogOffset> appendPurgatory, Map<Integer, InetSocketAddress> voterAddresses, int electionBackoffMaxMs, int retryBackoffMs, int requestTimeoutMs, int fetchMaxWaitMs, LogContext logContext, Random random) {
        this.channel = channel;
        this.log = log;
        this.quorum = quorum;
        this.fetchPurgatory = fetchPurgatory;
        this.appendPurgatory = appendPurgatory;
        this.time = time;
        this.electionBackoffMaxMs = electionBackoffMaxMs;
        this.fetchMaxWaitMs = fetchMaxWaitMs;
        this.logger = logContext.logger(KafkaRaftClient.class);
        this.random = random;
        this.requestManager = new RequestManager(voterAddresses.keySet(), retryBackoffMs, requestTimeoutMs, random);
        this.unwrittenAppends = new LinkedBlockingQueue<UnwrittenAppend>();
        this.kafkaRaftMetrics = new KafkaRaftMetrics(metrics, "raft", quorum);
        this.kafkaRaftMetrics.updateNumUnknownVoterConnections(quorum.remoteVoters().size());
        for (Map.Entry<Integer, InetSocketAddress> voterAddressEntry : voterAddresses.entrySet()) {
            channel.updateEndpoint(voterAddressEntry.getKey(), voterAddressEntry.getValue());
        }
    }

    private void updateFollowerHighWatermark(FollowerState state, OptionalLong highWatermarkOpt, long currentTimeMs) {
        highWatermarkOpt.ifPresent(highWatermark -> {
            long newHighWatermark = Math.min(this.endOffset().offset, highWatermark);
            state.updateHighWatermark(OptionalLong.of(newHighWatermark));
            this.updateHighWatermark(state, currentTimeMs);
        });
    }

    private void updateLeaderEndOffsetAndTimestamp(LeaderState state, long currentTimeMs) {
        LogOffsetMetadata endOffsetMetadata = this.log.endOffset();
        if (state.updateLocalState(currentTimeMs, endOffsetMetadata)) {
            this.updateHighWatermark(state, currentTimeMs);
        }
        LogOffset endOffset = new LogOffset(this.endOffset().offset, Isolation.UNCOMMITTED);
        this.fetchPurgatory.maybeComplete(endOffset, currentTimeMs);
    }

    private void updateReplicaEndOffsetAndTimestamp(LeaderState state, int replicaId, LogOffsetMetadata endOffsetMetadata, long currentTimeMs) {
        if (state.updateReplicaState(replicaId, currentTimeMs, endOffsetMetadata)) {
            this.updateHighWatermark(state, currentTimeMs);
        }
    }

    private void updateHighWatermark(EpochState state, long currentTimeMs) {
        state.highWatermark().ifPresent(highWatermark -> {
            this.logger.debug("High watermark updated to {}", highWatermark);
            this.log.updateHighWatermark((LogOffsetMetadata)highWatermark);
            LogOffset offset = new LogOffset(highWatermark.offset, Isolation.COMMITTED);
            this.appendPurgatory.maybeComplete(offset, currentTimeMs);
            this.fetchPurgatory.maybeComplete(offset, currentTimeMs);
        });
    }

    @Override
    public LeaderAndEpoch currentLeaderAndEpoch() {
        return this.quorum.leaderAndEpoch();
    }

    @Override
    public void initialize() throws IOException {
        this.quorum.initialize(new OffsetAndEpoch(this.log.endOffset().offset, this.log.lastFetchedEpoch()));
        long currentTimeMs = this.time.milliseconds();
        if (this.quorum.isLeader()) {
            this.onBecomeLeader(currentTimeMs);
        } else if (this.quorum.isCandidate()) {
            this.onBecomeCandidate(currentTimeMs);
        } else if (this.quorum.isFollower()) {
            this.onBecomeFollower(currentTimeMs);
        }
        if (this.quorum.isVoter() && this.quorum.remoteVoters().isEmpty() && !this.quorum.isLeader() && !this.quorum.isCandidate()) {
            this.transitionToCandidate(currentTimeMs);
        }
    }

    private OffsetAndEpoch endOffset() {
        return new OffsetAndEpoch(this.log.endOffset().offset, this.log.lastFetchedEpoch());
    }

    private void resetConnections() {
        this.requestManager.resetAll();
    }

    private void onBecomeLeader(long currentTimeMs) {
        LeaderState state = this.quorum.leaderStateOrThrow();
        this.log.initializeLeaderEpoch(this.quorum.epoch());
        this.appendLeaderChangeMessage(state, currentTimeMs);
        this.updateLeaderEndOffsetAndTimestamp(state, currentTimeMs);
        this.resetConnections();
        this.kafkaRaftMetrics.maybeUpdateElectionLatency(currentTimeMs);
    }

    private void appendLeaderChangeMessage(LeaderState state, long currentTimeMs) {
        List voters = state.followers().stream().map(follower -> new LeaderChangeMessage.Voter().setVoterId(follower.intValue())).collect(Collectors.toList());
        LeaderChangeMessage leaderChangeMessage = new LeaderChangeMessage().setLeaderId(state.election().leaderId()).setVoters(voters);
        MemoryRecords records = MemoryRecords.withLeaderChangeMessage((long)currentTimeMs, (int)this.quorum.epoch(), (LeaderChangeMessage)leaderChangeMessage);
        this.appendAsLeader(state, (Records)records, currentTimeMs);
    }

    private boolean maybeTransitionToLeader(CandidateState state, long currentTimeMs) throws IOException {
        if (state.isVoteGranted()) {
            long endOffset = this.log.endOffset().offset;
            this.quorum.transitionToLeader(endOffset);
            this.onBecomeLeader(currentTimeMs);
            return true;
        }
        return false;
    }

    private void onBecomeCandidate(long currentTimeMs) throws IOException {
        CandidateState state = this.quorum.candidateStateOrThrow();
        if (!this.maybeTransitionToLeader(state, currentTimeMs)) {
            this.resetConnections();
            this.kafkaRaftMetrics.updateElectionStartMs(currentTimeMs);
        }
    }

    private void transitionToCandidate(long currentTimeMs) throws IOException {
        this.quorum.transitionToCandidate();
        this.onBecomeCandidate(currentTimeMs);
    }

    private void transitionToUnattached(int epoch) throws IOException {
        this.quorum.transitionToUnattached(epoch);
        this.resetConnections();
    }

    private void transitionToVoted(int candidateId, int epoch) throws IOException {
        this.quorum.transitionToVoted(epoch, candidateId);
        this.resetConnections();
    }

    private void onBecomeFollower(long currentTimeMs) {
        this.kafkaRaftMetrics.maybeUpdateElectionLatency(currentTimeMs);
        this.resetConnections();
        this.fetchPurgatory.completeAllExceptionally((Throwable)new NotLeaderOrFollowerException("Cannot process the fetch request because the node is no longer the leader."));
        this.appendPurgatory.completeAllExceptionally((Throwable)new NotLeaderOrFollowerException("Failed to receive sufficient acknowledgments for this append before leader change."));
        this.failPendingAppends((KafkaException)new NotLeaderOrFollowerException("Append refused since this node is no longer the leader"));
    }

    private void transitionToFollower(int epoch, int leaderId, long currentTimeMs) throws IOException {
        this.quorum.transitionToFollower(epoch, leaderId);
        this.onBecomeFollower(currentTimeMs);
    }

    private VoteResponseData buildVoteResponse(Errors partitionLevelError, boolean voteGranted) {
        return VoteResponse.singletonResponse((Errors)Errors.NONE, (TopicPartition)this.log.topicPartition(), (Errors)partitionLevelError, (int)this.quorum.epoch(), (int)this.quorum.leaderIdOrNil(), (boolean)voteGranted);
    }

    private VoteResponseData handleVoteRequest(RaftRequest.Inbound requestMetadata) throws IOException {
        boolean voteGranted;
        VoteRequestData request = (VoteRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new VoteResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        VoteRequestData.PartitionData partitionRequest = (VoteRequestData.PartitionData)((VoteRequestData.TopicData)request.topics().get(0)).partitions().get(0);
        int candidateId = partitionRequest.candidateId();
        int candidateEpoch = partitionRequest.candidateEpoch();
        int lastEpoch = partitionRequest.lastOffsetEpoch();
        long lastEpochEndOffset = partitionRequest.lastOffset();
        if (lastEpochEndOffset < 0L || lastEpoch < 0 || lastEpoch >= candidateEpoch) {
            return this.buildVoteResponse(Errors.INVALID_REQUEST, false);
        }
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(candidateId, candidateEpoch);
        if (errorOpt.isPresent()) {
            return this.buildVoteResponse(errorOpt.get(), false);
        }
        if (candidateEpoch > this.quorum.epoch()) {
            this.transitionToUnattached(candidateEpoch);
        }
        if (this.quorum.isLeader()) {
            this.logger.debug("Ignoring vote request {} with epoch {} since we are already leader on that epoch", (Object)request, (Object)candidateEpoch);
            voteGranted = false;
        } else if (this.quorum.isCandidate()) {
            this.logger.debug("Ignoring vote request {} with epoch {} since we are already candidate on that epoch", (Object)request, (Object)candidateEpoch);
            voteGranted = false;
        } else if (this.quorum.isFollower()) {
            FollowerState state = this.quorum.followerStateOrThrow();
            this.logger.debug("Rejecting vote request {} with epoch {} since we already have a leader {} on that epoch", new Object[]{request, candidateEpoch, state.leaderId()});
            voteGranted = false;
        } else if (this.quorum.isVoted()) {
            VotedState state = this.quorum.votedStateOrThrow();
            boolean bl = voteGranted = state.votedId() == candidateId;
            if (!voteGranted) {
                this.logger.debug("Rejecting vote request {} with epoch {} since we already have voted for another candidate {} on that epoch", new Object[]{request, candidateEpoch, state.votedId()});
            }
        } else if (this.quorum.isUnattached()) {
            OffsetAndEpoch lastEpochEndOffsetAndEpoch = new OffsetAndEpoch(lastEpochEndOffset, lastEpoch);
            boolean bl = voteGranted = lastEpochEndOffsetAndEpoch.compareTo(this.endOffset()) >= 0;
            if (voteGranted) {
                this.transitionToVoted(candidateId, candidateEpoch);
            }
        } else {
            throw new IllegalStateException("Unexpected quorum state " + this.quorum);
        }
        this.logger.info("Vote request {} is {}", (Object)request, (Object)(voteGranted ? "granted" : "rejected"));
        return this.buildVoteResponse(Errors.NONE, voteGranted);
    }

    private boolean handleVoteResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        int responseEpoch;
        OptionalInt responseLeaderId;
        int remoteNodeId = responseMetadata.sourceId();
        VoteResponseData response = (VoteResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode((short)response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        VoteResponseData.PartitionData partitionResponse = (VoteResponseData.PartitionData)((VoteResponseData.TopicData)response.topics().get(0)).partitions().get(0);
        Errors error = Errors.forCode((short)partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(error, responseLeaderId = this.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (error == Errors.NONE) {
            if (this.quorum.isLeader()) {
                this.logger.debug("Ignoring vote response {} since we already became leader for epoch {}", (Object)partitionResponse, (Object)this.quorum.epoch());
            } else if (this.quorum.isCandidate()) {
                CandidateState state = this.quorum.candidateStateOrThrow();
                if (partitionResponse.voteGranted()) {
                    state.recordGrantedVote(remoteNodeId);
                    this.maybeTransitionToLeader(state, currentTimeMs);
                } else {
                    state.recordRejectedVote(remoteNodeId);
                    if (state.isVoteRejected() && !state.isBackingOff()) {
                        this.logger.info("Insufficient remaining votes to become leader (rejected by {}). We will backoff before retrying election again", state.rejectingVoters());
                        state.startBackingOff(currentTimeMs, this.binaryExponentialElectionBackoffMs(state.retries()));
                    }
                }
            } else {
                this.logger.debug("Ignoring vote response {} since we are no longer a candidate in epoch {}", (Object)partitionResponse, (Object)this.quorum.epoch());
            }
            return true;
        }
        return this.handleUnexpectedError(error, responseMetadata);
    }

    private int binaryExponentialElectionBackoffMs(int retries) {
        if (retries <= 0) {
            throw new IllegalArgumentException("Retries " + retries + " should be larger than zero");
        }
        return Math.min(100 * this.random.nextInt(2 << Math.min(20, retries - 1)), this.electionBackoffMaxMs);
    }

    private int strictExponentialElectionBackoffMs(int positionInSuccessors, int totalNumSuccessors) {
        if (positionInSuccessors <= 0 || positionInSuccessors >= totalNumSuccessors) {
            throw new IllegalArgumentException("Position " + positionInSuccessors + " should be larger than zero and smaller than total number of successors " + totalNumSuccessors);
        }
        int retryBackOffBaseMs = this.electionBackoffMaxMs >> totalNumSuccessors - 1;
        return Math.min(this.electionBackoffMaxMs, retryBackOffBaseMs << positionInSuccessors - 1);
    }

    private BeginQuorumEpochResponseData buildBeginQuorumEpochResponse(Errors partitionLevelError) {
        return BeginQuorumEpochResponse.singletonResponse((Errors)Errors.NONE, (TopicPartition)this.log.topicPartition(), (Errors)partitionLevelError, (int)this.quorum.epoch(), (int)this.quorum.leaderIdOrNil());
    }

    private BeginQuorumEpochResponseData handleBeginQuorumEpochRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) throws IOException {
        int requestEpoch;
        BeginQuorumEpochRequestData request = (BeginQuorumEpochRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new BeginQuorumEpochResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        BeginQuorumEpochRequestData.PartitionData partitionRequest = (BeginQuorumEpochRequestData.PartitionData)((BeginQuorumEpochRequestData.TopicData)request.topics().get(0)).partitions().get(0);
        int requestLeaderId = partitionRequest.leaderId();
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(requestLeaderId, requestEpoch = partitionRequest.leaderEpoch());
        if (errorOpt.isPresent()) {
            return this.buildBeginQuorumEpochResponse(errorOpt.get());
        }
        this.maybeTransition(OptionalInt.of(requestLeaderId), requestEpoch, currentTimeMs);
        return this.buildBeginQuorumEpochResponse(Errors.NONE);
    }

    private boolean handleBeginQuorumEpochResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        int responseEpoch;
        OptionalInt responseLeaderId;
        int remoteNodeId = responseMetadata.sourceId();
        BeginQuorumEpochResponseData response = (BeginQuorumEpochResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode((short)response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        BeginQuorumEpochResponseData.PartitionData partitionResponse = (BeginQuorumEpochResponseData.PartitionData)((BeginQuorumEpochResponseData.TopicData)response.topics().get(0)).partitions().get(0);
        Errors partitionError = Errors.forCode((short)partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(partitionError, responseLeaderId = this.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (partitionError == Errors.NONE) {
            if (this.quorum.isLeader()) {
                LeaderState state = this.quorum.leaderStateOrThrow();
                state.addEndorsementFrom(remoteNodeId);
            } else {
                this.logger.debug("Ignoring BeginQuorumEpoch response {} since this node is not the leader anymore", (Object)response);
            }
            return true;
        }
        return this.handleUnexpectedError(partitionError, responseMetadata);
    }

    private EndQuorumEpochResponseData buildEndQuorumEpochResponse(Errors partitionLevelError) {
        return EndQuorumEpochResponse.singletonResponse((Errors)Errors.NONE, (TopicPartition)this.log.topicPartition(), (Errors)partitionLevelError, (int)this.quorum.epoch(), (int)this.quorum.leaderIdOrNil());
    }

    private EndQuorumEpochResponseData handleEndQuorumEpochRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) throws IOException {
        VotedState state;
        EndQuorumEpochRequestData request = (EndQuorumEpochRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new EndQuorumEpochResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        EndQuorumEpochRequestData.PartitionData partitionRequest = (EndQuorumEpochRequestData.PartitionData)((EndQuorumEpochRequestData.TopicData)request.topics().get(0)).partitions().get(0);
        int requestEpoch = partitionRequest.leaderEpoch();
        int requestReplicaId = partitionRequest.replicaId();
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(requestReplicaId, requestEpoch);
        if (errorOpt.isPresent()) {
            return this.buildEndQuorumEpochResponse(errorOpt.get());
        }
        OptionalInt requestLeaderId = this.optionalLeaderId(partitionRequest.leaderId());
        this.maybeTransition(requestLeaderId, requestEpoch, currentTimeMs);
        if (this.quorum.isFollower()) {
            FollowerState state2 = this.quorum.followerStateOrThrow();
            if (state2.leaderId() == requestReplicaId) {
                List preferredSuccessors = partitionRequest.preferredSuccessors();
                if (!preferredSuccessors.contains(this.quorum.localId)) {
                    return this.buildEndQuorumEpochResponse(Errors.INCONSISTENT_VOTER_SET);
                }
                long electionBackoffMs = this.endEpochElectionBackoff(preferredSuccessors);
                state2.overrideFetchTimeout(currentTimeMs, electionBackoffMs);
            }
        } else if (this.quorum.isVoted() && (state = this.quorum.votedStateOrThrow()).votedId() == requestReplicaId) {
            long electionBackoffMs = this.binaryExponentialElectionBackoffMs(1);
            state.overrideElectionTimeout(currentTimeMs, electionBackoffMs);
        }
        return this.buildEndQuorumEpochResponse(Errors.NONE);
    }

    private long endEpochElectionBackoff(List<Integer> preferredSuccessors) {
        int position = preferredSuccessors.indexOf(this.quorum.localId);
        if (position == 0) {
            return 0L;
        }
        return this.strictExponentialElectionBackoffMs(position, preferredSuccessors.size());
    }

    private boolean handleEndQuorumEpochResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        int responseEpoch;
        OptionalInt responseLeaderId;
        EndQuorumEpochResponseData response = (EndQuorumEpochResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode((short)response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        EndQuorumEpochResponseData.PartitionData partitionResponse = (EndQuorumEpochResponseData.PartitionData)((EndQuorumEpochResponseData.TopicData)response.topics().get(0)).partitions().get(0);
        Errors partitionError = Errors.forCode((short)partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(partitionError, responseLeaderId = this.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (partitionError == Errors.NONE) {
            return true;
        }
        return this.handleUnexpectedError(partitionError, responseMetadata);
    }

    private FetchResponseData buildFetchResponse(Errors error, Records records, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, Optional<LogOffsetMetadata> highWatermark) {
        return RaftUtil.singletonFetchResponse(this.log.topicPartition(), Errors.NONE, partitionData -> {
            partitionData.setRecordSet((BaseRecords)records).setErrorCode(error.code()).setLogStartOffset(this.log.startOffset()).setHighWatermark(highWatermark.map(offsetMetadata -> offsetMetadata.offset).orElse(-1L).longValue());
            partitionData.currentLeader().setLeaderEpoch(this.quorum.epoch()).setLeaderId(this.quorum.leaderIdOrNil());
            divergingEpoch.ifPresent(arg_0 -> ((FetchResponseData.FetchablePartitionResponse)partitionData).setDivergingEpoch(arg_0));
        });
    }

    private FetchResponseData buildEmptyFetchResponse(Errors error, Optional<LogOffsetMetadata> highWatermark) {
        return this.buildFetchResponse(error, (Records)MemoryRecords.EMPTY, Optional.empty(), highWatermark);
    }

    private CompletableFuture<FetchResponseData> handleFetchRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        FetchRequestData request = (FetchRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return CompletableFuture.completedFuture(new FetchResponseData().setErrorCode(Errors.INVALID_REQUEST.code()));
        }
        FetchRequestData.FetchPartition fetchPartition = (FetchRequestData.FetchPartition)((FetchRequestData.FetchTopic)request.topics().get(0)).partitions().get(0);
        if (request.maxWaitMs() < 0 || fetchPartition.fetchOffset() < 0L || fetchPartition.lastFetchedEpoch() < 0 || fetchPartition.lastFetchedEpoch() > fetchPartition.currentLeaderEpoch()) {
            return CompletableFuture.completedFuture(this.buildEmptyFetchResponse(Errors.INVALID_REQUEST, Optional.empty()));
        }
        FetchResponseData response = this.tryCompleteFetchRequest(request.replicaId(), fetchPartition, currentTimeMs);
        FetchResponseData.FetchablePartitionResponse partitionResponse = (FetchResponseData.FetchablePartitionResponse)((FetchResponseData.FetchableTopicResponse)response.responses().get(0)).partitionResponses().get(0);
        if (partitionResponse.errorCode() != Errors.NONE.code() || partitionResponse.recordSet().sizeInBytes() > 0 || request.maxWaitMs() == 0) {
            return CompletableFuture.completedFuture(response);
        }
        CompletableFuture<Long> future = this.fetchPurgatory.await(LogOffset.awaitUncommitted(fetchPartition.fetchOffset()), request.maxWaitMs());
        return future.handle((completionTimeMs, exception) -> {
            Throwable cause;
            Errors error;
            if (exception != null && (error = Errors.forException((Throwable)(cause = exception instanceof ExecutionException ? exception.getCause() : exception))) != Errors.REQUEST_TIMED_OUT) {
                this.logger.debug("Failed to handle fetch from {} at {} due to {}", new Object[]{request.replicaId(), fetchPartition.fetchOffset(), error});
                return this.buildEmptyFetchResponse(error, Optional.empty());
            }
            this.logger.trace("Completing delayed fetch from {} starting at offset {} at {}", new Object[]{request.replicaId(), fetchPartition.fetchOffset(), completionTimeMs});
            try {
                return this.tryCompleteFetchRequest(request.replicaId(), fetchPartition, this.time.milliseconds());
            }
            catch (Exception e) {
                this.logger.error("Caught unexpected error in fetch completion of request {}", (Object)request, (Object)e);
                return this.buildEmptyFetchResponse(Errors.UNKNOWN_SERVER_ERROR, Optional.empty());
            }
        });
    }

    @Override
    public CompletableFuture<Records> read(OffsetAndEpoch fetchOffsetAndEpoch, Isolation isolation, long maxWaitTimeMs) {
        CompletableFuture<Records> future = new CompletableFuture<Records>();
        this.tryCompleteRead(future, fetchOffsetAndEpoch, isolation, maxWaitTimeMs <= 0L);
        if (!future.isDone()) {
            CompletableFuture<Long> completion = this.fetchPurgatory.await(LogOffset.await(fetchOffsetAndEpoch.offset, isolation), maxWaitTimeMs);
            completion.whenComplete((completeTimeMs, exception) -> {
                if (exception != null) {
                    future.completeExceptionally((Throwable)exception);
                } else {
                    this.tryCompleteRead(future, fetchOffsetAndEpoch, isolation, true);
                }
            });
        }
        return future;
    }

    private void tryCompleteRead(CompletableFuture<Records> future, OffsetAndEpoch fetchOffsetAndEpoch, Isolation isolation, boolean completeIfEmpty) {
        Optional<OffsetAndEpoch> nextOffsetOpt = this.validateFetchOffsetAndEpoch(fetchOffsetAndEpoch.offset, fetchOffsetAndEpoch.epoch);
        if (nextOffsetOpt.isPresent()) {
            future.completeExceptionally((Throwable)((Object)new LogTruncationException("Failed to read data from " + fetchOffsetAndEpoch + " since the log has been truncated. The diverging offset is " + nextOffsetOpt.get())));
        } else {
            try {
                LogFetchInfo info = this.log.read(fetchOffsetAndEpoch.offset, isolation);
                Records records = info.records;
                if (records.sizeInBytes() > 0 || completeIfEmpty) {
                    future.complete(records);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }
    }

    private FetchResponseData tryCompleteFetchRequest(int replicaId, FetchRequestData.FetchPartition request, long currentTimeMs) {
        Optional<Errors> errorOpt = this.validateLeaderOnlyRequest(request.currentLeaderEpoch());
        if (errorOpt.isPresent()) {
            return this.buildEmptyFetchResponse(errorOpt.get(), Optional.empty());
        }
        long fetchOffset = request.fetchOffset();
        int lastFetchedEpoch = request.lastFetchedEpoch();
        LeaderState state = this.quorum.leaderStateOrThrow();
        Optional<OffsetAndEpoch> divergingEpochOpt = this.validateFetchOffsetAndEpoch(fetchOffset, lastFetchedEpoch);
        if (divergingEpochOpt.isPresent()) {
            Optional<FetchResponseData.EpochEndOffset> divergingEpoch = divergingEpochOpt.map(offsetAndEpoch -> new FetchResponseData.EpochEndOffset().setEpoch(offsetAndEpoch.epoch).setEndOffset(offsetAndEpoch.offset));
            return this.buildFetchResponse(Errors.NONE, (Records)MemoryRecords.EMPTY, divergingEpoch, state.highWatermark());
        }
        LogFetchInfo info = this.log.read(fetchOffset, Isolation.UNCOMMITTED);
        this.updateReplicaEndOffsetAndTimestamp(state, replicaId, info.startOffsetMetadata, currentTimeMs);
        return this.buildFetchResponse(Errors.NONE, info.records, Optional.empty(), state.highWatermark());
    }

    private Optional<OffsetAndEpoch> validateFetchOffsetAndEpoch(long fetchOffset, int lastFetchedEpoch) {
        if (fetchOffset == 0L && lastFetchedEpoch == 0) {
            return Optional.empty();
        }
        OffsetAndEpoch endOffsetAndEpoch = this.log.endOffsetForEpoch(lastFetchedEpoch).orElse(new OffsetAndEpoch(-1L, -1));
        if (endOffsetAndEpoch.epoch != lastFetchedEpoch || endOffsetAndEpoch.offset < fetchOffset) {
            return Optional.of(endOffsetAndEpoch);
        }
        return Optional.empty();
    }

    private OptionalInt optionalLeaderId(int leaderIdOrNil) {
        if (leaderIdOrNil < 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(leaderIdOrNil);
    }

    private boolean handleFetchResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        FetchResponseData response = (FetchResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode((short)response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        FetchResponseData.FetchablePartitionResponse partitionResponse = (FetchResponseData.FetchablePartitionResponse)((FetchResponseData.FetchableTopicResponse)response.responses().get(0)).partitionResponses().get(0);
        FetchResponseData.LeaderIdAndEpoch currentLeaderIdAndEpoch = partitionResponse.currentLeader();
        OptionalInt responseLeaderId = this.optionalLeaderId(currentLeaderIdAndEpoch.leaderId());
        int responseEpoch = currentLeaderIdAndEpoch.leaderEpoch();
        Errors error = Errors.forCode((short)partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(error, responseLeaderId, responseEpoch, currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        FollowerState state = this.quorum.followerStateOrThrow();
        if (error == Errors.NONE) {
            FetchResponseData.EpochEndOffset divergingEpoch = partitionResponse.divergingEpoch();
            if (divergingEpoch.epoch() >= 0) {
                OffsetAndEpoch divergingOffsetAndEpoch = new OffsetAndEpoch(divergingEpoch.endOffset(), divergingEpoch.epoch());
                state.highWatermark().ifPresent(highWatermark -> {
                    if (divergingOffsetAndEpoch.offset < highWatermark.offset) {
                        throw new KafkaException("The leader requested truncation to offset " + divergingOffsetAndEpoch.offset + ", which is below the current high watermark " + highWatermark);
                    }
                });
                this.log.truncateToEndOffset(divergingOffsetAndEpoch).ifPresent(truncationOffset -> {
                    this.logger.info("Truncated to offset {} from Fetch response from leader {}", (Object)truncationOffset, (Object)this.quorum.leaderIdOrNil());
                    this.fetchPurgatory.maybeComplete(new LogOffset(Long.MAX_VALUE, Isolation.UNCOMMITTED), currentTimeMs);
                });
            } else {
                Records records = (Records)partitionResponse.recordSet();
                if (records.sizeInBytes() > 0) {
                    LogAppendInfo info = this.log.appendAsFollower(records);
                    OffsetAndEpoch endOffset = this.endOffset();
                    this.kafkaRaftMetrics.updateFetchedRecords(info.lastOffset - info.firstOffset + 1L);
                    this.kafkaRaftMetrics.updateLogEnd(endOffset);
                    this.logger.trace("Follower end offset updated to {} after append", (Object)endOffset);
                }
                OptionalLong highWatermark2 = partitionResponse.highWatermark() < 0L ? OptionalLong.empty() : OptionalLong.of(partitionResponse.highWatermark());
                this.updateFollowerHighWatermark(state, highWatermark2, currentTimeMs);
            }
            state.resetFetchTimeout(currentTimeMs);
            return true;
        }
        return this.handleUnexpectedError(error, responseMetadata);
    }

    private LogAppendInfo appendAsLeader(LeaderState state, Records records, long currentTimeMs) {
        LogAppendInfo info = this.log.appendAsLeader(records, this.quorum.epoch());
        OffsetAndEpoch endOffset = this.endOffset();
        this.updateLeaderEndOffsetAndTimestamp(state, currentTimeMs);
        this.kafkaRaftMetrics.updateAppendRecords(info.lastOffset - info.firstOffset + 1L);
        this.kafkaRaftMetrics.updateLogEnd(endOffset);
        this.logger.trace("Leader appended records at base offset {}, new end offset is {}", (Object)info.firstOffset, (Object)endOffset);
        return info;
    }

    private DescribeQuorumResponseData handleDescribeQuorumRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        DescribeQuorumRequestData describeQuorumRequestData = (DescribeQuorumRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(describeQuorumRequestData, this.log.topicPartition())) {
            return DescribeQuorumRequest.getPartitionLevelErrorResponse((DescribeQuorumRequestData)describeQuorumRequestData, (Errors)Errors.UNKNOWN_TOPIC_OR_PARTITION);
        }
        if (!this.quorum.isLeader()) {
            return DescribeQuorumRequest.getTopLevelErrorResponse((Errors)Errors.INVALID_REQUEST);
        }
        LeaderState leaderState = this.quorum.leaderStateOrThrow();
        return DescribeQuorumResponse.singletonResponse((TopicPartition)this.log.topicPartition(), (int)leaderState.localId(), (int)leaderState.epoch(), (long)(leaderState.highWatermark().isPresent() ? leaderState.highWatermark().get().offset : -1L), this.convertToReplicaStates(leaderState.getVoterEndOffsets()), this.convertToReplicaStates(leaderState.getObserverStates(currentTimeMs)));
    }

    List<DescribeQuorumResponseData.ReplicaState> convertToReplicaStates(Map<Integer, Long> replicaEndOffsets) {
        return replicaEndOffsets.entrySet().stream().map(entry -> new DescribeQuorumResponseData.ReplicaState().setReplicaId(((Integer)entry.getKey()).intValue()).setLogEndOffset(((Long)entry.getValue()).longValue())).collect(Collectors.toList());
    }

    private boolean hasConsistentLeader(int epoch, OptionalInt leaderId) {
        if (leaderId.isPresent() && leaderId.getAsInt() == this.quorum.localId) {
            return this.quorum.isLeader();
        }
        return epoch != this.quorum.epoch() || !leaderId.isPresent() || !this.quorum.leaderId().isPresent() || leaderId.equals(this.quorum.leaderId());
    }

    private Optional<Boolean> maybeHandleCommonResponse(Errors error, OptionalInt leaderId, int epoch, long currentTimeMs) throws IOException {
        if (epoch < this.quorum.epoch() || error == Errors.UNKNOWN_LEADER_EPOCH) {
            return Optional.of(true);
        }
        if (epoch > this.quorum.epoch() || error == Errors.FENCED_LEADER_EPOCH || error == Errors.NOT_LEADER_OR_FOLLOWER) {
            this.maybeTransition(leaderId, epoch, currentTimeMs);
            return Optional.of(true);
        }
        if (epoch == this.quorum.epoch() && leaderId.isPresent() && !this.quorum.hasLeader()) {
            this.transitionToFollower(epoch, leaderId.getAsInt(), currentTimeMs);
            if (error == Errors.NONE) {
                return Optional.empty();
            }
            return Optional.of(true);
        }
        if (error == Errors.BROKER_NOT_AVAILABLE) {
            return Optional.of(false);
        }
        if (error == Errors.INCONSISTENT_GROUP_PROTOCOL) {
            throw new IllegalStateException("Received error indicating inconsistent voter sets");
        }
        if (error == Errors.INVALID_REQUEST) {
            throw new IllegalStateException("Received unexpected invalid request error");
        }
        return Optional.empty();
    }

    private void maybeTransition(OptionalInt leaderId, int epoch, long currentTimeMs) throws IOException {
        if (!this.hasConsistentLeader(epoch, leaderId)) {
            throw new IllegalStateException("Received request or response with leader " + leaderId + " and epoch " + epoch + " which is inconsistent with current leader " + this.quorum.leaderId() + " and epoch " + this.quorum.epoch());
        }
        if (epoch > this.quorum.epoch()) {
            if (leaderId.isPresent()) {
                this.transitionToFollower(epoch, leaderId.getAsInt(), currentTimeMs);
            } else {
                this.transitionToUnattached(epoch);
            }
        } else if (leaderId.isPresent() && !this.quorum.hasLeader()) {
            this.transitionToFollower(epoch, leaderId.getAsInt(), currentTimeMs);
        }
    }

    private boolean handleTopLevelError(Errors error, RaftResponse.Inbound response) {
        if (error == Errors.BROKER_NOT_AVAILABLE) {
            return false;
        }
        if (error == Errors.CLUSTER_AUTHORIZATION_FAILED) {
            throw new ClusterAuthorizationException("Received cluster authorization error in response " + response);
        }
        return this.handleUnexpectedError(error, response);
    }

    private boolean handleUnexpectedError(Errors error, RaftResponse.Inbound response) {
        this.logger.error("Unexpected error {} in {} response: {}", new Object[]{error, response.data.apiKey(), response});
        return false;
    }

    private void handleResponse(RaftResponse.Inbound response, long currentTimeMs) throws IOException {
        boolean handledSuccessfully;
        ApiKeys apiKey = ApiKeys.forId((int)response.data.apiKey());
        switch (apiKey) {
            case FETCH: {
                handledSuccessfully = this.handleFetchResponse(response, currentTimeMs);
                break;
            }
            case VOTE: {
                handledSuccessfully = this.handleVoteResponse(response, currentTimeMs);
                break;
            }
            case BEGIN_QUORUM_EPOCH: {
                handledSuccessfully = this.handleBeginQuorumEpochResponse(response, currentTimeMs);
                break;
            }
            case END_QUORUM_EPOCH: {
                handledSuccessfully = this.handleEndQuorumEpochResponse(response, currentTimeMs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Received unexpected response type: " + apiKey);
            }
        }
        RequestManager.ConnectionState connection = this.requestManager.getOrCreate(response.sourceId());
        if (handledSuccessfully) {
            connection.onResponseReceived(response.correlationId, currentTimeMs);
        } else {
            connection.onResponseError(response.correlationId, currentTimeMs);
        }
    }

    private Optional<Errors> validateVoterOnlyRequest(int remoteNodeId, int requestEpoch) {
        if (requestEpoch < this.quorum.epoch()) {
            return Optional.of(Errors.FENCED_LEADER_EPOCH);
        }
        if (remoteNodeId < 0) {
            return Optional.of(Errors.INVALID_REQUEST);
        }
        if (this.quorum.isObserver() || !this.quorum.isVoter(remoteNodeId)) {
            return Optional.of(Errors.INCONSISTENT_VOTER_SET);
        }
        return Optional.empty();
    }

    private Optional<Errors> validateLeaderOnlyRequest(int requestEpoch) {
        if (requestEpoch < this.quorum.epoch()) {
            return Optional.of(Errors.FENCED_LEADER_EPOCH);
        }
        if (requestEpoch > this.quorum.epoch()) {
            return Optional.of(Errors.UNKNOWN_LEADER_EPOCH);
        }
        if (!this.quorum.isLeader()) {
            return Optional.of(Errors.NOT_LEADER_OR_FOLLOWER);
        }
        if (this.shutdown.get() != null) {
            return Optional.of(Errors.BROKER_NOT_AVAILABLE);
        }
        return Optional.empty();
    }

    private void handleRequest(RaftRequest.Inbound request, long currentTimeMs) throws IOException {
        CompletableFuture<FetchResponseData> responseFuture;
        ApiKeys apiKey = ApiKeys.forId((int)request.data.apiKey());
        switch (apiKey) {
            case FETCH: {
                responseFuture = this.handleFetchRequest(request, currentTimeMs);
                break;
            }
            case VOTE: {
                responseFuture = CompletableFuture.completedFuture(this.handleVoteRequest(request));
                break;
            }
            case BEGIN_QUORUM_EPOCH: {
                responseFuture = CompletableFuture.completedFuture(this.handleBeginQuorumEpochRequest(request, currentTimeMs));
                break;
            }
            case END_QUORUM_EPOCH: {
                responseFuture = CompletableFuture.completedFuture(this.handleEndQuorumEpochRequest(request, currentTimeMs));
                break;
            }
            case DESCRIBE_QUORUM: {
                responseFuture = CompletableFuture.completedFuture(this.handleDescribeQuorumRequest(request, currentTimeMs));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type " + apiKey);
            }
        }
        responseFuture.whenComplete((response, exception) -> {
            ApiMessage message = response != null ? response : RaftUtil.errorResponse(apiKey, Errors.forException((Throwable)exception));
            this.sendOutboundMessage(new RaftResponse.Outbound(request.correlationId(), message));
        });
    }

    private void handleInboundMessage(RaftMessage message, long currentTimeMs) throws IOException {
        this.logger.trace("Received inbound message {}", (Object)message);
        if (message instanceof RaftRequest.Inbound) {
            RaftRequest.Inbound request = (RaftRequest.Inbound)message;
            this.handleRequest(request, currentTimeMs);
        } else if (message instanceof RaftResponse.Inbound) {
            RaftResponse.Inbound response = (RaftResponse.Inbound)message;
            this.handleResponse(response, currentTimeMs);
        } else {
            throw new IllegalArgumentException("Unexpected message " + message);
        }
    }

    private void sendOutboundMessage(RaftMessage message) {
        this.channel.send(message);
        this.logger.trace("Sent outbound message: {}", (Object)message);
    }

    private long maybeSendRequest(long currentTimeMs, int destinationId, Supplier<ApiMessage> requestSupplier) {
        RequestManager.ConnectionState connection = this.requestManager.getOrCreate(destinationId);
        if (connection.isBackingOff(currentTimeMs)) {
            return connection.remainingBackoffMs(currentTimeMs);
        }
        if (connection.isReady(currentTimeMs)) {
            int correlationId = this.channel.newCorrelationId();
            ApiMessage request = requestSupplier.get();
            this.sendOutboundMessage(new RaftRequest.Outbound(correlationId, request, destinationId, currentTimeMs));
            connection.onRequestSent(correlationId, currentTimeMs);
            return Long.MAX_VALUE;
        }
        return connection.remainingRequestTimeMs(currentTimeMs);
    }

    private EndQuorumEpochRequestData buildEndQuorumEpochRequest() {
        List preferredSuccessors = this.quorum.isLeader() ? this.quorum.leaderStateOrThrow().nonLeaderVotersByDescendingFetchOffset() : Collections.emptyList();
        return EndQuorumEpochRequest.singletonRequest((TopicPartition)this.log.topicPartition(), (int)this.quorum.localId, (int)this.quorum.epoch(), (int)this.quorum.leaderIdOrNil(), preferredSuccessors);
    }

    private long maybeSendRequests(long currentTimeMs, Set<Integer> destinationIds, Supplier<ApiMessage> requestSupplier) {
        long minBackoffMs = Long.MAX_VALUE;
        for (Integer destinationId : destinationIds) {
            long backoffMs = this.maybeSendRequest(currentTimeMs, destinationId, requestSupplier);
            if (backoffMs >= minBackoffMs) continue;
            minBackoffMs = backoffMs;
        }
        return minBackoffMs;
    }

    private BeginQuorumEpochRequestData buildBeginQuorumEpochRequest() {
        return BeginQuorumEpochRequest.singletonRequest((TopicPartition)this.log.topicPartition(), (int)this.quorum.epoch(), (int)this.quorum.localId);
    }

    private VoteRequestData buildVoteRequest() {
        OffsetAndEpoch endOffset = this.endOffset();
        return VoteRequest.singletonRequest((TopicPartition)this.log.topicPartition(), (int)this.quorum.epoch(), (int)this.quorum.localId, (int)endOffset.epoch, (long)endOffset.offset);
    }

    private FetchRequestData buildFetchRequest() {
        FetchRequestData request = RaftUtil.singletonFetchRequest(this.log.topicPartition(), fetchPartition -> fetchPartition.setCurrentLeaderEpoch(this.quorum.epoch()).setLastFetchedEpoch(this.log.lastFetchedEpoch()).setFetchOffset(this.log.endOffset().offset));
        return request.setMaxWaitMs(this.fetchMaxWaitMs).setReplicaId(this.quorum.localId);
    }

    private long maybeSendAnyVoterFetch(long currentTimeMs) {
        OptionalInt readyVoterIdOpt = this.requestManager.findReadyVoter(currentTimeMs);
        if (readyVoterIdOpt.isPresent()) {
            return this.maybeSendRequest(currentTimeMs, readyVoterIdOpt.getAsInt(), this::buildFetchRequest);
        }
        return this.requestManager.backoffBeforeAvailableVoter(currentTimeMs);
    }

    public boolean isRunning() {
        GracefulShutdown gracefulShutdown = this.shutdown.get();
        return gracefulShutdown == null || !gracefulShutdown.isFinished();
    }

    public boolean isShuttingDown() {
        GracefulShutdown gracefulShutdown = this.shutdown.get();
        return gracefulShutdown != null && !gracefulShutdown.isFinished();
    }

    private void pollShutdown(GracefulShutdown shutdown) throws IOException {
        shutdown.update();
        if (shutdown.isFinished()) {
            return;
        }
        long currentTimeMs = shutdown.finishTimer.currentTimeMs();
        if (this.quorum.remoteVoters().isEmpty() || this.quorum.hasRemoteLeader()) {
            shutdown.complete();
            return;
        }
        long pollTimeoutMs = shutdown.finishTimer.remainingMs();
        if (this.quorum.isLeader() || this.quorum.isCandidate()) {
            long backoffMs = this.maybeSendRequests(currentTimeMs, this.quorum.remoteVoters(), this::buildEndQuorumEpochRequest);
            pollTimeoutMs = Math.min(backoffMs, pollTimeoutMs);
        }
        List<RaftMessage> inboundMessages = this.channel.receive(pollTimeoutMs);
        for (RaftMessage message : inboundMessages) {
            this.handleInboundMessage(message, currentTimeMs);
            currentTimeMs = this.time.milliseconds();
        }
    }

    private long pollLeader(long currentTimeMs) {
        LeaderState state = this.quorum.leaderStateOrThrow();
        this.pollPendingAppends(currentTimeMs);
        return this.maybeSendRequests(currentTimeMs, state.nonEndorsingFollowers(), this::buildBeginQuorumEpochRequest);
    }

    private long pollCandidate(long currentTimeMs) throws IOException {
        CandidateState state = this.quorum.candidateStateOrThrow();
        if (state.isBackingOff()) {
            if (state.isBackoffComplete(currentTimeMs)) {
                this.logger.info("Re-elect as candidate after election backoff has completed");
                this.transitionToCandidate(currentTimeMs);
                return 0L;
            }
            return state.remainingBackoffMs(currentTimeMs);
        }
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            long backoffDurationMs = this.binaryExponentialElectionBackoffMs(state.retries());
            this.logger.debug("Election has timed out, backing off for {}ms before becoming a candidate again", (Object)backoffDurationMs);
            state.startBackingOff(currentTimeMs, backoffDurationMs);
            return backoffDurationMs;
        }
        if (!state.isVoteRejected()) {
            long minRequestBackoffMs = this.maybeSendRequests(currentTimeMs, state.unrecordedVoters(), this::buildVoteRequest);
            return Math.min(minRequestBackoffMs, state.remainingElectionTimeMs(currentTimeMs));
        }
        return state.remainingElectionTimeMs(currentTimeMs);
    }

    private long pollFollower(long currentTimeMs) throws IOException {
        FollowerState state = this.quorum.followerStateOrThrow();
        if (this.quorum.isVoter()) {
            return this.pollFollowerAsVoter(state, currentTimeMs);
        }
        return this.pollFollowerAsObserver(state, currentTimeMs);
    }

    private long pollFollowerAsVoter(FollowerState state, long currentTimeMs) throws IOException {
        this.failPendingAppends((KafkaException)new NotLeaderOrFollowerException("Failing append since this node is not the current leader"));
        if (state.hasFetchTimeoutExpired(currentTimeMs)) {
            this.logger.info("Become candidate due to fetch timeout");
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        long backoffMs = this.maybeSendRequest(currentTimeMs, state.leaderId(), this::buildFetchRequest);
        return Math.min(backoffMs, state.remainingFetchTimeMs(currentTimeMs));
    }

    private long pollFollowerAsObserver(FollowerState state, long currentTimeMs) {
        long backoffMs;
        if (state.hasFetchTimeoutExpired(currentTimeMs)) {
            return this.maybeSendAnyVoterFetch(currentTimeMs);
        }
        RequestManager.ConnectionState connection = this.requestManager.getOrCreate(state.leaderId());
        if (connection.hasRequestTimedOut(currentTimeMs)) {
            backoffMs = this.maybeSendAnyVoterFetch(currentTimeMs);
            connection.reset();
        } else {
            backoffMs = connection.isBackingOff(currentTimeMs) ? this.maybeSendAnyVoterFetch(currentTimeMs) : this.maybeSendRequest(currentTimeMs, state.leaderId(), this::buildFetchRequest);
        }
        return Math.min(backoffMs, state.remainingFetchTimeMs(currentTimeMs));
    }

    private long pollVoted(long currentTimeMs) throws IOException {
        VotedState state = this.quorum.votedStateOrThrow();
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        return state.remainingElectionTimeMs(currentTimeMs);
    }

    private long pollUnattached(long currentTimeMs) throws IOException {
        UnattachedState state = this.quorum.unattachedStateOrThrow();
        if (this.quorum.isVoter()) {
            return this.pollUnattachedAsVoter(state, currentTimeMs);
        }
        return this.pollUnattachedAsObserver(state, currentTimeMs);
    }

    private long pollUnattachedAsVoter(UnattachedState state, long currentTimeMs) throws IOException {
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        return state.remainingElectionTimeMs(currentTimeMs);
    }

    private long pollUnattachedAsObserver(UnattachedState state, long currentTimeMs) {
        long fetchBackoffMs = this.maybeSendAnyVoterFetch(currentTimeMs);
        return Math.min(fetchBackoffMs, state.remainingElectionTimeMs(currentTimeMs));
    }

    private long pollCurrentState(long currentTimeMs) throws IOException {
        if (this.quorum.isLeader()) {
            return this.pollLeader(currentTimeMs);
        }
        if (this.quorum.isCandidate()) {
            return this.pollCandidate(currentTimeMs);
        }
        if (this.quorum.isFollower()) {
            return this.pollFollower(currentTimeMs);
        }
        if (this.quorum.isVoted()) {
            return this.pollVoted(currentTimeMs);
        }
        if (this.quorum.isUnattached()) {
            return this.pollUnattached(currentTimeMs);
        }
        throw new IllegalStateException("Unexpected quorum state " + this.quorum);
    }

    public void poll() throws IOException {
        GracefulShutdown gracefulShutdown = this.shutdown.get();
        if (gracefulShutdown != null) {
            this.pollShutdown(gracefulShutdown);
        } else {
            long currentTimeMs = this.time.milliseconds();
            long pollTimeoutMs = this.pollCurrentState(currentTimeMs);
            this.kafkaRaftMetrics.updatePollStart(currentTimeMs);
            List<RaftMessage> inboundMessages = this.channel.receive(pollTimeoutMs);
            currentTimeMs = this.time.milliseconds();
            this.kafkaRaftMetrics.updatePollEnd(currentTimeMs);
            for (RaftMessage message : inboundMessages) {
                this.handleInboundMessage(message, currentTimeMs);
                currentTimeMs = this.time.milliseconds();
            }
        }
    }

    private void failPendingAppends(KafkaException exception) {
        for (UnwrittenAppend unwrittenAppend : this.unwrittenAppends) {
            unwrittenAppend.fail((Throwable)exception);
        }
        this.unwrittenAppends.clear();
    }

    private void pollPendingAppends(long currentTimeMs) {
        int numAppends = 0;
        int maxNumAppends = this.unwrittenAppends.size();
        while (!this.unwrittenAppends.isEmpty() && numAppends < maxNumAppends) {
            UnwrittenAppend unwrittenAppend = (UnwrittenAppend)this.unwrittenAppends.poll();
            if (unwrittenAppend.future.isDone()) continue;
            if (unwrittenAppend.isTimedOut(currentTimeMs)) {
                unwrittenAppend.fail(new TimeoutException("Request timeout " + unwrittenAppend.requestTimeoutMs + " expired before the records could be appended to the log"));
            } else {
                LeaderState leaderState = this.quorum.leaderStateOrThrow();
                int epoch = this.quorum.epoch();
                LogAppendInfo info = this.appendAsLeader(leaderState, unwrittenAppend.records, currentTimeMs);
                OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(info.lastOffset, epoch);
                if (unwrittenAppend.ackMode == AckMode.LEADER) {
                    unwrittenAppend.complete(offsetAndEpoch);
                } else if (unwrittenAppend.ackMode == AckMode.QUORUM) {
                    CompletableFuture<Long> future = this.appendPurgatory.await(LogOffset.awaitCommitted(offsetAndEpoch.offset), unwrittenAppend.requestTimeoutMs);
                    future.whenComplete((completionTimeMs, exception) -> {
                        if (exception != null) {
                            this.logger.error("Failed to commit append at {} due to {}", (Object)offsetAndEpoch, exception);
                            unwrittenAppend.fail((Throwable)exception);
                        } else {
                            long elapsedTime = Math.max(0L, completionTimeMs - currentTimeMs);
                            long numCommittedRecords = info.lastOffset - info.firstOffset + 1L;
                            double elapsedTimePerRecord = (double)elapsedTime / (double)numCommittedRecords;
                            this.kafkaRaftMetrics.updateCommitLatency(elapsedTimePerRecord, currentTimeMs);
                            unwrittenAppend.complete(offsetAndEpoch);
                            this.logger.debug("Completed committing append with {} records at {}", (Object)numCommittedRecords, (Object)offsetAndEpoch);
                        }
                    });
                }
            }
            ++numAppends;
        }
    }

    @Override
    public CompletableFuture<OffsetAndEpoch> append(Records records, AckMode ackMode, long timeoutMs) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append empty record set");
        }
        if (this.shutdown.get() != null) {
            throw new IllegalStateException("Cannot append records while we are shutting down");
        }
        if (this.quorum.isObserver()) {
            throw new IllegalStateException("Illegal attempt to write to an observer");
        }
        CompletableFuture<OffsetAndEpoch> future = new CompletableFuture<OffsetAndEpoch>();
        UnwrittenAppend unwrittenAppend = new UnwrittenAppend(records, this.time.milliseconds(), timeoutMs, ackMode, future);
        if (!this.unwrittenAppends.offer(unwrittenAppend)) {
            future.completeExceptionally((Throwable)new KafkaException("Failed to append records since the unsent append queue is full"));
        }
        this.channel.wakeup();
        return future;
    }

    @Override
    public CompletableFuture<Void> shutdown(int timeoutMs) {
        this.logger.info("Beginning graceful shutdown");
        CompletableFuture<Void> shutdownComplete = new CompletableFuture<Void>();
        this.shutdown.set(new GracefulShutdown(timeoutMs, shutdownComplete));
        this.channel.wakeup();
        return shutdownComplete;
    }

    private void close() {
        this.kafkaRaftMetrics.close();
    }

    public OptionalLong highWatermark() {
        return this.quorum.highWatermark().isPresent() ? OptionalLong.of(this.quorum.highWatermark().get().offset) : OptionalLong.empty();
    }

    private static class UnwrittenAppend {
        private final Records records;
        private final long createTimeMs;
        private final long requestTimeoutMs;
        private final AckMode ackMode;
        private final CompletableFuture<OffsetAndEpoch> future;

        private UnwrittenAppend(Records records, long createTimeMs, long requestTimeoutMs, AckMode ackMode, CompletableFuture<OffsetAndEpoch> future) {
            this.future = future;
            this.records = records;
            this.ackMode = ackMode;
            this.createTimeMs = createTimeMs;
            this.requestTimeoutMs = requestTimeoutMs;
        }

        public void complete(OffsetAndEpoch offsetAndEpoch) {
            this.future.complete(offsetAndEpoch);
        }

        public void fail(Throwable e) {
            this.future.completeExceptionally(e);
        }

        public boolean isTimedOut(long currentTimeMs) {
            return currentTimeMs > this.createTimeMs + this.requestTimeoutMs;
        }
    }

    private class GracefulShutdown {
        final Timer finishTimer;
        final CompletableFuture<Void> completeFuture;

        public GracefulShutdown(long shutdownTimeoutMs, CompletableFuture<Void> completeFuture) {
            this.finishTimer = KafkaRaftClient.this.time.timer(shutdownTimeoutMs);
            this.completeFuture = completeFuture;
        }

        public void update() {
            this.finishTimer.update();
            if (this.finishTimer.isExpired()) {
                KafkaRaftClient.this.close();
                KafkaRaftClient.this.logger.warn("Graceful shutdown timed out after {}ms", (Object)this.finishTimer.timeoutMs());
                this.completeFuture.completeExceptionally(new TimeoutException("Timeout expired before shutdown completed"));
            }
        }

        public boolean isFinished() {
            return this.completeFuture.isDone();
        }

        public boolean succeeded() {
            return this.isFinished() && !this.failed();
        }

        public boolean failed() {
            return this.completeFuture.isCompletedExceptionally();
        }

        public void complete() {
            KafkaRaftClient.this.close();
            KafkaRaftClient.this.logger.info("Graceful shutdown completed");
            this.completeFuture.complete(null);
        }
    }
}

