/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSource.class);
    private String topic;
    private Properties props = new Properties();
    private String allPartitionOffsets;
    Map<Integer, Long> partitionOffsets = new HashMap<Integer, Long>();
    private static final String KAFKA_DESERIALIZER_METHOD = "org.apache.kafka.common.serialization.ByteArrayDeserializer";
    private static final String KAFKA_SESSION_TIMEOUT = "session.timeout.ms";
    private boolean isRestoreFromDB = false;
    private KafkaConsumer<String, byte[]> kafkaConsumer;
    private long offset = 0L;

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            LOGGER.info("KafkaSource init: {}", (Object)profile.toJsonStr());
            this.topic = profile.getInstanceId();
            this.props.put("bootstrap.servers", profile.get("task.kafkaTask.bootstrap.servers"));
            this.props.put("group.id", this.taskId);
            this.props.put("key.deserializer", KAFKA_DESERIALIZER_METHOD);
            this.props.put("value.deserializer", KAFKA_DESERIALIZER_METHOD);
            this.props.put("auto.offset.reset", profile.get("task.kafkaTask.autoOffsetReset"));
            this.props.put("enable.auto.commit", (Object)false);
            this.allPartitionOffsets = profile.get("task.kafkaTask.partition.offset", null);
            this.isRestoreFromDB = profile.getBoolean("task.restoreFromDB", false);
            if (!this.isRestoreFromDB && StringUtils.isNotBlank((CharSequence)this.allPartitionOffsets)) {
                String[] offsets;
                for (String offset : offsets = this.allPartitionOffsets.split("_")) {
                    this.partitionOffsets.put(Integer.valueOf(offset.split("#")[0]), Long.valueOf(offset.split("#")[1]));
                }
            }
            this.kafkaConsumer = this.getKafkaConsumer();
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.topic, (Throwable)ex);
        }
    }

    @Override
    protected String getThreadName() {
        return "kafka-source-" + this.taskId + "-" + this.instanceId;
    }

    @Override
    protected boolean doPrepareToRead() {
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        ArrayList<AbstractSource.SourceData> dataList = new ArrayList<AbstractSource.SourceData>();
        ConsumerRecords records = this.kafkaConsumer.poll(Duration.ofMillis(1000L));
        for (ConsumerRecord record : records) {
            AbstractSource.SourceData sourceData = new AbstractSource.SourceData(this, (byte[])record.value(), Long.toString(record.offset()));
            dataList.add(sourceData);
            this.offset = record.offset();
        }
        this.kafkaConsumer.commitSync();
        return dataList;
    }

    private KafkaConsumer<String, byte[]> getKafkaConsumer() {
        KafkaConsumer kafkaConsumer = null;
        this.props.put(KAFKA_SESSION_TIMEOUT, (Object)30000);
        try {
            kafkaConsumer = new KafkaConsumer(this.props);
            List partitionInfoList = kafkaConsumer.partitionsFor(this.topic);
            if (partitionInfoList == null) {
                kafkaConsumer.close();
                return null;
            }
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            for (PartitionInfo partitionInfo : partitionInfoList) {
                TopicPartition topicPartition = new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
                topicPartitions.add(topicPartition);
            }
            kafkaConsumer.assign(topicPartitions);
            if (!this.isRestoreFromDB && StringUtils.isNotBlank((CharSequence)this.allPartitionOffsets)) {
                for (TopicPartition topicPartition : topicPartitions) {
                    Long offset = this.partitionOffsets.get(topicPartition.partition());
                    if (!ObjectUtils.isNotEmpty((Object)offset)) continue;
                    kafkaConsumer.seek(topicPartition, offset.longValue());
                }
            } else {
                LOGGER.info("Skip to seek offset");
            }
            return kafkaConsumer;
        }
        catch (Exception e) {
            if (kafkaConsumer != null) {
                kafkaConsumer.close();
            }
            LOGGER.error("get kafka consumer error", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("kafka topic is {}, offset is {}", (Object)this.topic, (Object)this.offset);
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable;
    }

    public boolean sourceExist() {
        return true;
    }

    @Override
    protected void releaseSource() {
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.close();
        }
    }
}

