/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.moilioncircle.redis.replicator.RedisReplicator;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.DefaultCommand;
import com.moilioncircle.redis.replicator.cmd.parser.DefaultCommandParser;
import com.moilioncircle.redis.replicator.event.PostRdbSyncEvent;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueHash;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueList;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueSet;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueString;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueZSet;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSource.class);
    private static final long MAX_DATA_SIZE = 512000L;
    private static final int REDIS_QUEUE_SIZE = 10000;
    private static final long DEFAULT_FREQ = 60000L;
    private static final String GET_COMMAND = "GET";
    private static final String MGET_COMMAND = "MGET";
    private static final String HGET_COMMAND = "HGET";
    private static final String ZSCORE_COMMAND = "ZSCORE";
    private static final String ZREVRANK_COMMAND = "ZREVRANK";
    private static final String EXISTS_COMMAND = "EXISTS";
    private Gson gson;
    public InstanceProfile profile;
    private String port;
    private Jedis jedis;
    private String hostName;
    private boolean ssl;
    private String authUser;
    private String authPassword;
    private String readTimeout;
    private String replId;
    private String snapShot;
    private String dbName;
    private String redisCommand;
    private String fieldOrMember;
    private boolean destroyed;
    private boolean isSubscribe;
    private Set<String> keys;
    private Set<String> subscribeOperations;
    private Replicator redisReplicator;
    private BlockingQueue<AbstractSource.SourceData> redisQueue;
    private ScheduledExecutorService executor;
    private static final Map<String, CommandHandler> commandHandlers = Maps.newConcurrentMap();

    @Override
    protected String getThreadName() {
        return "redis-source-" + this.taskId + "-" + this.instanceId;
    }

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        LOGGER.info("Redis Source init: {}", (Object)profile.toJsonStr());
        this.port = profile.get("task.redisTask.port");
        this.hostName = profile.get("task.redisTask.hostname");
        this.ssl = profile.getBoolean("task.redisTask.ssl", false);
        this.authUser = profile.get("task.redisTask.authUser", "");
        this.authPassword = profile.get("task.redisTask.authPassword", "");
        this.readTimeout = profile.get("task.redisTask.readTimeout", "");
        this.replId = profile.get("task.redisTask.replId", "");
        this.snapShot = profile.get("task.redisTask.offset", "-1");
        this.dbName = profile.get("task.redisTask.dbName");
        this.keys = new ConcurrentSkipListSet<String>(Arrays.asList(profile.get("task.redisTask.keys").split(",")));
        this.isSubscribe = profile.getBoolean("task.redisTask.isSubscribe", false);
        this.instanceId = profile.getInstanceId();
        this.redisQueue = new LinkedBlockingQueue<AbstractSource.SourceData>(10000);
        this.initGson();
        String uri = this.getRedisUri();
        try {
            if (this.isSubscribe) {
                this.subscribeOperations = new ConcurrentSkipListSet<String>(Arrays.asList(profile.get("task.redisTask.subscriptionOperation").split(",")));
                this.executor = (ScheduledExecutorService)Executors.newSingleThreadExecutor();
                this.redisReplicator = new RedisReplicator(uri);
                this.initReplicator();
                this.executor.execute(this.startReplicatorSync());
            } else {
                this.executor = Executors.newScheduledThreadPool(1);
                this.redisCommand = profile.get("task.redisTask.command", GET_COMMAND);
                this.fieldOrMember = profile.get("task.redisTask.fieldOrMember", null);
                long syncFreq = profile.getLong("task.redisTask.syncFreq", 60000L);
                this.jedis = new Jedis(uri);
                this.jedis.connect();
                this.executor.scheduleWithFixedDelay(this.startJedisSync(), 0L, syncFreq, TimeUnit.MILLISECONDS);
            }
        }
        catch (IOException | URISyntaxException | JedisConnectionException e) {
            this.sourceMetric.pluginReadFailCount.addAndGet(1L);
            LOGGER.error("Connect to redis {}:{} failed.", new Object[]{this.hostName, this.port, e});
        }
    }

    private Runnable startReplicatorSync() {
        return () -> {
            AgentThreadFactory.nameThread((String)(this.getThreadName() + "redis subscribe mode"));
            this.executor.execute(new Thread(() -> {
                try {
                    this.redisReplicator.open();
                }
                catch (IOException e) {
                    LOGGER.error("Redis source error, fail to start replicator", (Throwable)e);
                }
            }));
        };
    }

    private Runnable startJedisSync() {
        return () -> {
            AgentThreadFactory.nameThread((String)(this.getThreadName() + "redis command mode"));
            this.executor.execute(new Thread(() -> {
                Map<String, Object> dataMap = this.fetchDataByJedis(this.jedis, this.redisCommand, new ArrayList<String>(this.keys), this.fieldOrMember);
                this.synchronizeData(this.gson.toJson(dataMap));
            }));
        };
    }

    private Map<String, Object> fetchDataByJedis(Jedis jedis, String command, List<String> keys, String fieldOrMember) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CommandHandler handler = commandHandlers.get(command.toUpperCase());
        if (handler == null) {
            LOGGER.error("Unsupported command: " + command);
            throw new UnsupportedOperationException("Unsupported command: " + command);
        }
        handler.handle(jedis, keys, fieldOrMember, result);
        return result;
    }

    private static void handleGet(Jedis jedis, List<String> keys, String fieldOrMember, Map<String, Object> result) {
        Pipeline pipeline = jedis.pipelined();
        for (String key : keys) {
            pipeline.get(key);
        }
        List getValues = pipeline.syncAndReturnAll();
        for (int i = 0; i < keys.size(); ++i) {
            result.put(keys.get(i), getValues.get(i));
        }
    }

    private static void handleMGet(Jedis jedis, List<String> keys, String fieldOrMember, Map<String, Object> result) {
        List mGetValues = jedis.mget(keys.toArray(new String[0]));
        for (int i = 0; i < keys.size(); ++i) {
            result.put(keys.get(i), mGetValues.get(i));
        }
    }

    private static void handleHGet(Jedis jedis, List<String> keys, String fieldOrMember, Map<String, Object> result) {
        for (String key : keys) {
            String value = jedis.hget(key, fieldOrMember);
            result.put(key, value);
        }
    }

    private static void handleZScore(Jedis jedis, List<String> keys, String fieldOrMember, Map<String, Object> result) {
        for (String key : keys) {
            if (StringUtils.isEmpty((String)fieldOrMember)) continue;
            Double score = jedis.zscore(key, fieldOrMember);
            result.put(key, score);
        }
    }

    private static void handleZRevRank(Jedis jedis, List<String> keys, String fieldOrMember, Map<String, Object> result) {
        for (String key : keys) {
            if (StringUtils.isEmpty((String)fieldOrMember)) continue;
            Long rank = jedis.zrevrank(key, fieldOrMember);
            result.put(key, rank);
        }
    }

    private static void handleExists(Jedis jedis, List<String> keys, String fieldOrMember, Map<String, Object> result) {
        for (String key : keys) {
            boolean exists = jedis.exists(key);
            result.put(key, exists);
        }
    }

    private void synchronizeData(String data) {
        try {
            if (!StringUtils.isEmpty((String)data)) {
                byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
                if ((long)dataBytes.length <= 512000L) {
                    AbstractSource.SourceData sourceData = new AbstractSource.SourceData(this, dataBytes, "0L");
                    boolean offerSuc = false;
                    while (this.isRunnable() && !offerSuc) {
                        offerSuc = this.redisQueue.offer(sourceData, 1L, TimeUnit.SECONDS);
                    }
                    AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_READ_SUCCESS, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)System.currentTimeMillis(), (int)1, (long)data.length());
                    this.sourceMetric.pluginReadCount.incrementAndGet();
                } else {
                    this.sourceMetric.pluginReadFailCount.incrementAndGet();
                    LOGGER.warn("Read redis data warn, data overload, Automatically skip and discard");
                }
            }
        }
        catch (InterruptedException e) {
            this.sourceMetric.pluginReadFailCount.incrementAndGet();
            LOGGER.error("Read redis data error", (Throwable)e);
        }
    }

    @Override
    protected void printCurrentState() {
        if (this.isSubscribe) {
            LOGGER.info("redis subscribe synchronization is {} on source {}", (Object)(this.redisReplicator != null && !this.executor.isShutdown() ? "running" : "stop"), (Object)(this.hostName + ":" + this.port));
        } else {
            LOGGER.info("redis command synchronization is {} on source {}", (Object)(!this.executor.isShutdown() ? "running" : "stop"), (Object)(this.hostName + ":" + this.port));
        }
    }

    @Override
    protected boolean doPrepareToRead() {
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        ArrayList<AbstractSource.SourceData> dataList = new ArrayList<AbstractSource.SourceData>();
        try {
            AbstractSource.SourceData sourceData;
            for (int size = 0; size < this.BATCH_READ_LINE_TOTAL_LEN && (sourceData = this.redisQueue.poll(1L, TimeUnit.SECONDS)) != null; size += sourceData.getData().length) {
                dataList.add(sourceData);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("poll {} data from redis queue interrupted.", (Object)this.instanceId);
        }
        return dataList;
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable;
    }

    @Override
    protected void releaseSource() {
        LOGGER.info("releasing redis source");
        if (!this.destroyed) {
            try {
                this.executor.shutdown();
                if (this.redisReplicator != null) {
                    this.redisReplicator.close();
                }
                if (this.jedis.isConnected()) {
                    this.jedis.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Redis reader close failed.");
            }
            this.destroyed = true;
        }
    }

    @Override
    public boolean sourceFinish() {
        return false;
    }

    public boolean sourceExist() {
        return true;
    }

    private String getRedisUri() {
        StringBuffer sb = new StringBuffer("redis://");
        sb.append(this.hostName).append(":").append(this.port);
        if (!StringUtils.isEmpty((String)this.dbName)) {
            sb.append("/").append(this.dbName);
        }
        sb.append("?");
        if (!StringUtils.isEmpty((String)this.authPassword)) {
            sb.append("authPassword=").append(this.authPassword).append("&");
        }
        if (!StringUtils.isEmpty((String)this.authUser)) {
            sb.append("authUser=").append(this.authUser).append("&");
        }
        if (!StringUtils.isEmpty((String)this.readTimeout)) {
            sb.append("readTimeout=").append(this.readTimeout).append("&");
        }
        if (this.ssl) {
            sb.append("ssl=").append("yes").append("&");
        }
        if (!StringUtils.isEmpty((String)this.snapShot)) {
            sb.append("replOffset=").append(this.snapShot).append("&");
        }
        if (!StringUtils.isEmpty((String)this.replId)) {
            sb.append("replId=").append(this.replId).append("&");
        }
        if (sb.charAt(sb.length() - 1) == '?' || sb.charAt(sb.length() - 1) == '&') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private void initReplicator() {
        if (!this.subscribeOperations.isEmpty()) {
            DefaultCommandParser replicatorCommandParser = new DefaultCommandParser();
            for (String subOperation : this.subscribeOperations) {
                this.redisReplicator.addCommandParser(CommandName.name((String)subOperation), (CommandParser)replicatorCommandParser);
            }
            this.redisReplicator.addEventListener((replicator, event) -> {
                String key;
                DefaultCommand defaultCommand;
                byte[][] args;
                if (event instanceof DefaultCommand && (args = (defaultCommand = (DefaultCommand)event).getArgs())[0] instanceof byte[] && this.keys.contains(key = new String(args[0], StandardCharsets.UTF_8))) {
                    this.synchronizeData(this.gson.toJson((Object)event));
                }
                if (event instanceof PostRdbSyncEvent) {
                    this.snapShot = String.valueOf(replicator.getConfiguration().getReplOffset());
                    LOGGER.info("after rdb snapShot is: {}", (Object)this.snapShot);
                }
            });
        } else {
            this.initDefaultReplicator();
        }
    }

    private void initDefaultReplicator() {
        DefaultCommandParser defaultCommandParser = new DefaultCommandParser();
        this.redisReplicator.addCommandParser(CommandName.name((String)"APPEND"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SETEX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"MSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"DEL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HMSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EXPIRE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EXPIREAT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"GETSET"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HSETNX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PSETEX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SETNX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SETRANGE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HDEL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LPOP"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LPUSH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LPUSHX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LRem"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RPOP"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RPUSH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RPUSHX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZREM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RENAME"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"INCR"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"DECR"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"INCRBY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"DECRBY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PERSIST"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SELECT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"FLUSHALL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"FLUSHDB"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"HINCRBY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZINCRBY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"MOVE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SMOVE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PFADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PFCOUNT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PFMERGE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SDIFFSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SINTERSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SUNIONSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZINTERSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZUNIONSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"BRPOPLPUSH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LINSERT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RENAMENX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RESTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PEXPIRE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PEXPIREAT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"GEOADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EVAL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EVALSHA"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SCRIPT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"PUBLISH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"BITOP"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"BITFIELD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SETBIT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SREM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"UNLINK"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SWAPDB"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"MULTI"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"EXEC"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZREMRANGEBYSCORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZREMRANGEBYRANK"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZREMRANGEBYLEX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LTRIM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SORT"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"RPOPLPUSH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZPOPMIN"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZPOPMAX"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"REPLCONF"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XACK"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XADD"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XCLAIM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XDEL"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XGROUP"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XTRIM"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"XSETID"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"COPY"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"LMOVE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"BLMOVE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"ZDIFFSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"GEOSEARCHSTORE"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"SPUBLISH"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addCommandParser(CommandName.name((String)"FUNCTION"), (CommandParser)defaultCommandParser);
        this.redisReplicator.addEventListener((replicator, event) -> {
            KeyValuePair kvEvent;
            String key;
            if ((event instanceof KeyValuePair || event instanceof DefaultCommand) && this.keys.contains(key = (kvEvent = (KeyValuePair)event).getKey().toString())) {
                this.synchronizeData(this.gson.toJson((Object)event));
            }
            if (event instanceof PostRdbSyncEvent) {
                this.snapShot = String.valueOf(replicator.getConfiguration().getReplOffset());
                LOGGER.info("after rdb snapShot is: {}", (Object)this.snapShot);
            }
        });
    }

    private void initGson() {
        this.gson = new GsonBuilder().registerTypeAdapter(KeyStringValueHash.class, (Object)new TypeAdapter<KeyStringValueHash>(){

            public void write(JsonWriter out, KeyStringValueHash kv) throws IOException {
                out.beginObject();
                out.name("DB").beginObject();
                out.name("dbNumber").value(kv.getDb().getDbNumber());
                out.name("dbSize").value((Number)kv.getDb().getDbsize());
                out.name("expires").value((Number)kv.getDb().getExpires());
                out.endObject();
                out.name("valueRdbType").value((long)kv.getValueRdbType());
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").beginObject();
                for (byte[] b : ((Map)kv.getValue()).keySet()) {
                    out.name(new String(b)).value(new String((byte[])((Map)kv.getValue()).get(b)));
                }
                out.endObject();
                out.endObject();
            }

            public KeyStringValueHash read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(DefaultCommand.class, (Object)new TypeAdapter<DefaultCommand>(){

            public void write(JsonWriter out, DefaultCommand dc) throws IOException {
                out.beginObject();
                out.name("key").value(new String(dc.getCommand()));
                out.name("value").beginArray();
                for (byte[] bytes : dc.getArgs()) {
                    out.value(new String(bytes));
                }
                out.endArray();
                out.endObject();
            }

            public DefaultCommand read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(KeyStringValueList.class, (Object)new TypeAdapter<KeyStringValueList>(){

            public void write(JsonWriter out, KeyStringValueList kv) throws IOException {
                out.beginObject();
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").beginArray();
                for (byte[] bytes : (List)kv.getValue()) {
                    out.value(new String(bytes));
                }
                out.endArray();
                out.endObject();
            }

            public KeyStringValueList read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(KeyStringValueSet.class, (Object)new TypeAdapter<KeyStringValueSet>(){

            public void write(JsonWriter out, KeyStringValueSet kv) throws IOException {
                out.beginObject();
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").beginArray();
                for (byte[] bytes : (Set)kv.getValue()) {
                    out.value(new String(bytes));
                }
                out.endArray();
                out.endObject();
            }

            public KeyStringValueSet read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(KeyStringValueString.class, (Object)new TypeAdapter<KeyStringValueString>(){

            public void write(JsonWriter out, KeyStringValueString kv) throws IOException {
                out.beginObject();
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").value(new String((byte[])kv.getValue()));
                out.endObject();
            }

            public KeyStringValueString read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(KeyStringValueZSet.class, (Object)new TypeAdapter<KeyStringValueZSet>(){

            public void write(JsonWriter out, KeyStringValueZSet kv) throws IOException {
                out.beginObject();
                out.name("key").value(new String((byte[])kv.getKey()));
                out.name("value").beginArray();
                for (ZSetEntry entry : (Set)kv.getValue()) {
                    out.beginObject();
                    out.name("element").value(new String(entry.getElement()));
                    out.name("score").value(entry.getScore());
                    out.endObject();
                }
                out.endArray();
                out.endObject();
            }

            public KeyStringValueZSet read(JsonReader in) throws IOException {
                return null;
            }
        }).create();
    }

    static {
        commandHandlers.put(GET_COMMAND, RedisSource::handleGet);
        commandHandlers.put(MGET_COMMAND, RedisSource::handleMGet);
        commandHandlers.put(HGET_COMMAND, RedisSource::handleHGet);
        commandHandlers.put(ZSCORE_COMMAND, RedisSource::handleZScore);
        commandHandlers.put(ZREVRANK_COMMAND, RedisSource::handleZRevRank);
        commandHandlers.put(EXISTS_COMMAND, RedisSource::handleExists);
    }

    @FunctionalInterface
    private static interface CommandHandler {
        public void handle(Jedis var1, List<String> var2, String var3, Map<String, Object> var4);
    }
}

