/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.CloseListener;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.ExceptionListener;
import com.moilioncircle.redis.replicator.FileType;
import com.moilioncircle.redis.replicator.RedisAofReplicator;
import com.moilioncircle.redis.replicator.RedisMixReplicator;
import com.moilioncircle.redis.replicator.RedisRdbReplicator;
import com.moilioncircle.redis.replicator.RedisSocketReplicator;
import com.moilioncircle.redis.replicator.RedisURI;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.SslConfiguration;
import com.moilioncircle.redis.replicator.Status;
import com.moilioncircle.redis.replicator.StatusListener;
import com.moilioncircle.redis.replicator.cmd.Command;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.event.EventListener;
import com.moilioncircle.redis.replicator.io.PeekableInputStream;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Objects;

public class RedisReplicator
implements Replicator {
    protected Replicator replicator;

    public RedisReplicator(File file, FileType fileType, Configuration configuration) throws FileNotFoundException {
        switch (fileType) {
            case AOF: {
                this.replicator = new RedisAofReplicator(file, configuration);
                break;
            }
            case RDB: {
                this.replicator = new RedisRdbReplicator(file, configuration);
                break;
            }
            case MIXED: {
                this.replicator = new RedisMixReplicator(file, configuration);
                break;
            }
            default: {
                throw new UnsupportedOperationException(fileType.toString());
            }
        }
    }

    public RedisReplicator(InputStream in, FileType fileType, Configuration configuration) {
        switch (fileType) {
            case AOF: {
                this.replicator = new RedisAofReplicator(in, configuration);
                break;
            }
            case RDB: {
                this.replicator = new RedisRdbReplicator(in, configuration);
                break;
            }
            case MIXED: {
                this.replicator = new RedisMixReplicator(in, configuration);
                break;
            }
            default: {
                throw new UnsupportedOperationException(fileType.toString());
            }
        }
    }

    public RedisReplicator(String host, int port, Configuration configuration) {
        this.replicator = new RedisSocketReplicator(host, port, configuration);
    }

    public RedisReplicator(String uri) throws URISyntaxException, IOException {
        Objects.requireNonNull(uri);
        this.initialize(new RedisURI(uri), null);
    }

    public RedisReplicator(RedisURI uri) throws IOException {
        this.initialize(uri, null);
    }

    public RedisReplicator(String uri, SslConfiguration sslConfiguration) throws URISyntaxException, IOException {
        Objects.requireNonNull(uri);
        this.initialize(new RedisURI(uri), sslConfiguration);
    }

    public RedisReplicator(RedisURI uri, SslConfiguration sslConfiguration) throws IOException {
        this.initialize(uri, sslConfiguration);
    }

    private void initialize(RedisURI uri, SslConfiguration sslConfiguration) throws IOException {
        Objects.requireNonNull(uri);
        Configuration configuration = Configuration.valueOf(uri).merge(sslConfiguration);
        if (uri.getFileType() != null) {
            PeekableInputStream in = new PeekableInputStream(uri.toURL().openStream());
            switch (uri.getFileType()) {
                case AOF: {
                    if (in.peek() == 82) {
                        this.replicator = new RedisMixReplicator(in, configuration);
                        break;
                    }
                    this.replicator = new RedisAofReplicator(in, configuration);
                    break;
                }
                case RDB: {
                    this.replicator = new RedisRdbReplicator(in, configuration);
                    break;
                }
                case MIXED: {
                    this.replicator = new RedisMixReplicator(in, configuration);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(uri.getFileType().toString());
                }
            }
        } else {
            this.replicator = new RedisSocketReplicator(uri.getHost(), uri.getPort(), configuration);
        }
    }

    public <T extends Replicator> T getReplicator() {
        return (T)this.replicator;
    }

    @Override
    public boolean addRawByteListener(RawByteListener listener) {
        return this.replicator.addRawByteListener(listener);
    }

    @Override
    public boolean removeRawByteListener(RawByteListener listener) {
        return this.replicator.removeRawByteListener(listener);
    }

    @Override
    public void builtInCommandParserRegister() {
        this.replicator.builtInCommandParserRegister();
    }

    @Override
    public CommandParser<? extends Command> getCommandParser(CommandName command) {
        return this.replicator.getCommandParser(command);
    }

    @Override
    public <T extends Command> void addCommandParser(CommandName command, CommandParser<T> parser) {
        this.replicator.addCommandParser(command, parser);
    }

    @Override
    public CommandParser<? extends Command> removeCommandParser(CommandName command) {
        return this.replicator.removeCommandParser(command);
    }

    @Override
    public ModuleParser<? extends Module> getModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.getModuleParser(moduleName, moduleVersion);
    }

    @Override
    public <T extends Module> void addModuleParser(String moduleName, int moduleVersion, ModuleParser<T> parser) {
        this.replicator.addModuleParser(moduleName, moduleVersion, parser);
    }

    @Override
    public ModuleParser<? extends Module> removeModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.removeModuleParser(moduleName, moduleVersion);
    }

    @Override
    public void setRdbVisitor(RdbVisitor rdbVisitor) {
        this.replicator.setRdbVisitor(rdbVisitor);
    }

    @Override
    public RdbVisitor getRdbVisitor() {
        return this.replicator.getRdbVisitor();
    }

    @Override
    public boolean addEventListener(EventListener listener) {
        return this.replicator.addEventListener(listener);
    }

    @Override
    public boolean removeEventListener(EventListener listener) {
        return this.replicator.removeEventListener(listener);
    }

    @Override
    public boolean addCloseListener(CloseListener listener) {
        return this.replicator.addCloseListener(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        return this.replicator.removeCloseListener(listener);
    }

    @Override
    public boolean addExceptionListener(ExceptionListener listener) {
        return this.replicator.addExceptionListener(listener);
    }

    @Override
    public boolean removeExceptionListener(ExceptionListener listener) {
        return this.replicator.removeExceptionListener(listener);
    }

    @Override
    public boolean addStatusListener(StatusListener listener) {
        return this.replicator.addStatusListener(listener);
    }

    @Override
    public boolean removeStatusListener(StatusListener listener) {
        return this.replicator.removeStatusListener(listener);
    }

    @Override
    public boolean verbose() {
        return this.replicator.verbose();
    }

    @Override
    public Status getStatus() {
        return this.replicator.getStatus();
    }

    @Override
    public Configuration getConfiguration() {
        return this.replicator.getConfiguration();
    }

    @Override
    public void open() throws IOException {
        this.replicator.open();
    }

    @Override
    public void close() throws IOException {
        this.replicator.close();
    }
}

