/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupCreateCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupCreateConsumerCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupDelConsumerCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupDestroyCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupSetIdCommand;
import com.moilioncircle.redis.replicator.util.Strings;

public class XGroupParser
implements CommandParser<XGroupCommand> {
    @Override
    public XGroupCommand parse(Object[] command) {
        String next;
        int idx = 1;
        if (Strings.isEquals(next = CommandParsers.toRune(command[idx++]), "CREATE")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            byte[] id = CommandParsers.toBytes(command[++idx]);
            ++idx;
            boolean mkStream = false;
            Long entriesRead = null;
            while (idx < command.length) {
                if (Strings.isEquals(next = CommandParsers.toRune(command[idx++]), "MKSTREAM")) {
                    mkStream = true;
                    continue;
                }
                if (Strings.isEquals(next, "ENTRIESREAD")) {
                    entriesRead = CommandParsers.toLong(command[idx++]);
                    continue;
                }
                throw new UnsupportedOperationException(next);
            }
            return new XGroupCreateCommand(key, group, id, mkStream, entriesRead);
        }
        if (Strings.isEquals(next, "SETID")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            byte[] id = CommandParsers.toBytes(command[++idx]);
            ++idx;
            Long entriesRead = null;
            while (idx < command.length) {
                if (Strings.isEquals(next = CommandParsers.toRune(command[idx++]), "ENTRIESREAD")) {
                    entriesRead = CommandParsers.toLong(command[idx++]);
                    continue;
                }
                throw new UnsupportedOperationException(next);
            }
            return new XGroupSetIdCommand(key, group, id, entriesRead);
        }
        if (Strings.isEquals(next, "DESTROY")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            ++idx;
            return new XGroupDestroyCommand(key, group);
        }
        if (Strings.isEquals(next, "CREATECONSUMER")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            byte[] consumer = CommandParsers.toBytes(command[++idx]);
            ++idx;
            return new XGroupCreateConsumerCommand(key, group, consumer);
        }
        if (Strings.isEquals(next, "DELCONSUMER")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            byte[] consumer = CommandParsers.toBytes(command[++idx]);
            ++idx;
            return new XGroupDelConsumerCommand(key, group, consumer);
        }
        throw new UnsupportedOperationException(next);
    }
}

