/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.module;

import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRdbModuleParser {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultRdbModuleParser.class);
    private final RedisInputStream in;
    private final BaseRdbParser parser;

    public DefaultRdbModuleParser(RedisInputStream in) {
        this.in = in;
        this.parser = new BaseRdbParser(in);
    }

    public RedisInputStream inputStream() {
        return this.in;
    }

    public long loadSigned(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 2L) {
            throw new UnsupportedOperationException("Error loading signed or unsigned long from RDB.");
        }
        return this.parser.rdbLoadLen().len;
    }

    public BigInteger loadUnsigned(int version) throws IOException {
        byte[] ary = new byte[8];
        long value = this.loadSigned(version);
        for (int i = 0; i < 8; ++i) {
            ary[7 - i] = (byte)(value >>> (i << 3) & 0xFFL);
        }
        return new BigInteger(1, ary);
    }

    public String loadString(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 5L) {
            throw new UnsupportedOperationException("Error loading string from RDB.");
        }
        ByteArray bytes = this.parser.rdbGenericLoadStringObject(0);
        return Strings.toString(bytes.first());
    }

    public byte[] loadStringBuffer(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 5L) {
            throw new UnsupportedOperationException("Error loading string from RDB.");
        }
        ByteArray bytes = this.parser.rdbGenericLoadStringObject(2);
        return bytes.first();
    }

    public double loadDouble(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 4L) {
            throw new UnsupportedOperationException("Error loading double from RDB.");
        }
        return this.parser.rdbLoadBinaryDoubleValue();
    }

    public float loadFloat(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 3L) {
            throw new UnsupportedOperationException("Error loading float from RDB.");
        }
        return this.parser.rdbLoadBinaryFloatValue();
    }

    public BigDecimal loadLongDouble(int version) throws IOException {
        return new BigDecimal(this.loadString(version));
    }
}

