/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class Concurrents {
    public static long sub(long v1, long v2) {
        return Math.max(Math.max(v1, 0L) - Math.max(v2, 0L), 0L);
    }

    public static long terminate(ExecutorService exec, long timeout, TimeUnit unit) throws InterruptedException {
        if (exec == null) {
            return timeout;
        }
        if (!exec.isShutdown()) {
            exec.shutdown();
        }
        if (timeout <= 0L) {
            return 0L;
        }
        long now = System.nanoTime();
        exec.awaitTermination(timeout, unit);
        long elapsedTime = System.nanoTime() - now;
        return Concurrents.sub(timeout, unit.convert(elapsedTime, TimeUnit.NANOSECONDS));
    }

    public static long terminateQuietly(ExecutorService exec, long timeout, TimeUnit unit) {
        long now = System.nanoTime();
        try {
            return Concurrents.terminate(exec, timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            long elapsedTime = System.nanoTime() - now;
            return Concurrents.sub(timeout, unit.convert(elapsedTime, TimeUnit.NANOSECONDS));
        }
    }
}

