/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterRequest;

@JsonTypeDefine(value="PULSAR")
@ApiModel(value="Inlong cluster info for Pulsar")
public class PulsarClusterInfo
extends ClusterInfo {
    public static final String HTTP_PREFIX = "http://";
    @ApiModelProperty(value="Pulsar admin URL, such as: http://127.0.0.1:8080", notes="Pulsar service URL is the 'url' field of the cluster")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar tenant, default is 'public'")
    private String pulsarTenant;

    public PulsarClusterInfo() {
        this.setType("PULSAR");
    }

    @Override
    public PulsarClusterRequest genRequest() {
        return (PulsarClusterRequest)CommonBeanUtils.copyProperties((Object)this, PulsarClusterRequest::new);
    }

    public String[] getAdminUrls(String urlSuffix) {
        String adminUrl = this.getAdminUrl();
        Preconditions.expectNotBlank((String)adminUrl, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"admin url is blank");
        String[] adminUrls = adminUrl.replace(HTTP_PREFIX, "").split(",");
        for (int i = 0; i < adminUrls.length; ++i) {
            adminUrls[i] = HTTP_PREFIX + adminUrls[i] + urlSuffix;
        }
        return adminUrls;
    }

    protected PulsarClusterInfo(PulsarClusterInfoBuilder<?, ?> b) {
        super(b);
        this.adminUrl = ((PulsarClusterInfoBuilder)b).adminUrl;
        this.pulsarTenant = ((PulsarClusterInfoBuilder)b).pulsarTenant;
    }

    public static PulsarClusterInfoBuilder<?, ?> builder() {
        return new PulsarClusterInfoBuilderImpl();
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getPulsarTenant() {
        return this.pulsarTenant;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setPulsarTenant(String pulsarTenant) {
        this.pulsarTenant = pulsarTenant;
    }

    @Override
    public String toString() {
        return "PulsarClusterInfo(super=" + super.toString() + ", adminUrl=" + this.getAdminUrl() + ", pulsarTenant=" + this.getPulsarTenant() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarClusterInfo)) {
            return false;
        }
        PulsarClusterInfo other = (PulsarClusterInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$pulsarTenant = this.getPulsarTenant();
        String other$pulsarTenant = other.getPulsarTenant();
        return !(this$pulsarTenant == null ? other$pulsarTenant != null : !this$pulsarTenant.equals(other$pulsarTenant));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarClusterInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $pulsarTenant = this.getPulsarTenant();
        result = result * 59 + ($pulsarTenant == null ? 43 : $pulsarTenant.hashCode());
        return result;
    }

    private static final class PulsarClusterInfoBuilderImpl
    extends PulsarClusterInfoBuilder<PulsarClusterInfo, PulsarClusterInfoBuilderImpl> {
        private PulsarClusterInfoBuilderImpl() {
        }

        @Override
        protected PulsarClusterInfoBuilderImpl self() {
            return this;
        }

        @Override
        public PulsarClusterInfo build() {
            return new PulsarClusterInfo(this);
        }
    }

    public static abstract class PulsarClusterInfoBuilder<C extends PulsarClusterInfo, B extends PulsarClusterInfoBuilder<C, B>>
    extends ClusterInfo.ClusterInfoBuilder<C, B> {
        private String adminUrl;
        private String pulsarTenant;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return (B)this.self();
        }

        public B pulsarTenant(String pulsarTenant) {
            this.pulsarTenant = pulsarTenant;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PulsarClusterInfo.PulsarClusterInfoBuilder(super=" + super.toString() + ", adminUrl=" + this.adminUrl + ", pulsarTenant=" + this.pulsarTenant + ")";
        }
    }
}

