/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.es;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.SinkField;

@JsonTypeDefine(value="ES")
public class ElasticsearchFieldInfo
extends SinkField {
    @ApiModelProperty(value="Elasticsearch Analyzer")
    private String analyzer;
    @ApiModelProperty(value="Elasticsearch Search Analyzer")
    private String searchAnalyzer;
    @ApiModelProperty(value="Elasticsearch Scaling Factor")
    private String scalingFactor;

    public static ElasticsearchFieldInfo getFromRequest(SinkField sinkField) {
        return (ElasticsearchFieldInfo)CommonBeanUtils.copyProperties((Object)sinkField, ElasticsearchFieldInfo::new, (boolean)true);
    }

    public static ElasticsearchFieldInfo getFromJson(@NotNull String extParams) {
        if (StringUtils.isEmpty((CharSequence)extParams)) {
            return new ElasticsearchFieldInfo();
        }
        try {
            return (ElasticsearchFieldInfo)JsonUtils.parseObject((String)extParams, ElasticsearchFieldInfo.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("Failed to parse extParams for Elasticsearch fieldInfo: %s", e.getMessage()));
        }
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public String getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public String getScalingFactor() {
        return this.scalingFactor;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setSearchAnalyzer(String searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
    }

    public void setScalingFactor(String scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchFieldInfo)) {
            return false;
        }
        ElasticsearchFieldInfo other = (ElasticsearchFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$analyzer = this.getAnalyzer();
        String other$analyzer = other.getAnalyzer();
        if (this$analyzer == null ? other$analyzer != null : !this$analyzer.equals(other$analyzer)) {
            return false;
        }
        String this$searchAnalyzer = this.getSearchAnalyzer();
        String other$searchAnalyzer = other.getSearchAnalyzer();
        if (this$searchAnalyzer == null ? other$searchAnalyzer != null : !this$searchAnalyzer.equals(other$searchAnalyzer)) {
            return false;
        }
        String this$scalingFactor = this.getScalingFactor();
        String other$scalingFactor = other.getScalingFactor();
        return !(this$scalingFactor == null ? other$scalingFactor != null : !this$scalingFactor.equals(other$scalingFactor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchFieldInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $analyzer = this.getAnalyzer();
        result = result * 59 + ($analyzer == null ? 43 : $analyzer.hashCode());
        String $searchAnalyzer = this.getSearchAnalyzer();
        result = result * 59 + ($searchAnalyzer == null ? 43 : $searchAnalyzer.hashCode());
        String $scalingFactor = this.getScalingFactor();
        result = result * 59 + ($scalingFactor == null ? 43 : $scalingFactor.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ElasticsearchFieldInfo(analyzer=" + this.getAnalyzer() + ", searchAnalyzer=" + this.getSearchAnalyzer() + ", scalingFactor=" + this.getScalingFactor() + ")";
    }

    public ElasticsearchFieldInfo() {
    }

    public ElasticsearchFieldInfo(String analyzer, String searchAnalyzer, String scalingFactor) {
        this.analyzer = analyzer;
        this.searchAnalyzer = searchAnalyzer;
        this.scalingFactor = scalingFactor;
    }
}

