/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hdfs;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.BaseStreamSink;
import org.apache.inlong.manager.pojo.sink.hdfs.HDFSPartitionField;
import org.apache.inlong.manager.pojo.sink.hdfs.HDFSSinkRequest;

public class HDFSSinkDTO
extends BaseStreamSink {
    @ApiModelProperty(value="File format, support: TextFile, RCFile, SequenceFile, Avro")
    private String fileFormat;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/usr/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="Compress format")
    private String compressFormat;
    @ApiModelProperty(value="Server timeZone")
    private String serverTimeZone;
    @ApiModelProperty(value="Data field separator")
    private String dataSeparator;
    @ApiModelProperty(value="Partition field list")
    private List<HDFSPartitionField> partitionFieldList;
    @ApiModelProperty(value="Properties for hbase")
    private Map<String, Object> properties;

    public static HDFSSinkDTO getFromRequest(HDFSSinkRequest request, String extParams) {
        HDFSSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? HDFSSinkDTO.getFromJson(extParams) : new HDFSSinkDTO();
        return (HDFSSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static HDFSSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (HDFSSinkDTO)JsonUtils.parseObject((String)extParams, HDFSSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of HDFS SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static HDFSSinkDTOBuilder builder() {
        return new HDFSSinkDTOBuilder();
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getCompressFormat() {
        return this.compressFormat;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public List<HDFSPartitionField> getPartitionFieldList() {
        return this.partitionFieldList;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setCompressFormat(String compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setPartitionFieldList(List<HDFSPartitionField> partitionFieldList) {
        this.partitionFieldList = partitionFieldList;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HDFSSinkDTO)) {
            return false;
        }
        HDFSSinkDTO other = (HDFSSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$compressFormat = this.getCompressFormat();
        String other$compressFormat = other.getCompressFormat();
        if (this$compressFormat == null ? other$compressFormat != null : !this$compressFormat.equals(other$compressFormat)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        if (this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        List<HDFSPartitionField> this$partitionFieldList = this.getPartitionFieldList();
        List<HDFSPartitionField> other$partitionFieldList = other.getPartitionFieldList();
        if (this$partitionFieldList == null ? other$partitionFieldList != null : !((Object)this$partitionFieldList).equals(other$partitionFieldList)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HDFSSinkDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $compressFormat = this.getCompressFormat();
        result = result * 59 + ($compressFormat == null ? 43 : $compressFormat.hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        List<HDFSPartitionField> $partitionFieldList = this.getPartitionFieldList();
        result = result * 59 + ($partitionFieldList == null ? 43 : ((Object)$partitionFieldList).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HDFSSinkDTO(fileFormat=" + this.getFileFormat() + ", dataPath=" + this.getDataPath() + ", compressFormat=" + this.getCompressFormat() + ", serverTimeZone=" + this.getServerTimeZone() + ", dataSeparator=" + this.getDataSeparator() + ", partitionFieldList=" + this.getPartitionFieldList() + ", properties=" + this.getProperties() + ")";
    }

    public HDFSSinkDTO() {
    }

    public HDFSSinkDTO(String fileFormat, String dataPath, String compressFormat, String serverTimeZone, String dataSeparator, List<HDFSPartitionField> partitionFieldList, Map<String, Object> properties) {
        this.fileFormat = fileFormat;
        this.dataPath = dataPath;
        this.compressFormat = compressFormat;
        this.serverTimeZone = serverTimeZone;
        this.dataSeparator = dataSeparator;
        this.partitionFieldList = partitionFieldList;
        this.properties = properties;
    }

    public static class HDFSSinkDTOBuilder {
        private String fileFormat;
        private String dataPath;
        private String compressFormat;
        private String serverTimeZone;
        private String dataSeparator;
        private List<HDFSPartitionField> partitionFieldList;
        private Map<String, Object> properties;

        HDFSSinkDTOBuilder() {
        }

        public HDFSSinkDTOBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public HDFSSinkDTOBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public HDFSSinkDTOBuilder compressFormat(String compressFormat) {
            this.compressFormat = compressFormat;
            return this;
        }

        public HDFSSinkDTOBuilder serverTimeZone(String serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public HDFSSinkDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public HDFSSinkDTOBuilder partitionFieldList(List<HDFSPartitionField> partitionFieldList) {
            this.partitionFieldList = partitionFieldList;
            return this;
        }

        public HDFSSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public HDFSSinkDTO build() {
            return new HDFSSinkDTO(this.fileFormat, this.dataPath, this.compressFormat, this.serverTimeZone, this.dataSeparator, this.partitionFieldList, this.properties);
        }

        public String toString() {
            return "HDFSSinkDTO.HDFSSinkDTOBuilder(fileFormat=" + this.fileFormat + ", dataPath=" + this.dataPath + ", compressFormat=" + this.compressFormat + ", serverTimeZone=" + this.serverTimeZone + ", dataSeparator=" + this.dataSeparator + ", partitionFieldList=" + this.partitionFieldList + ", properties=" + this.properties + ")";
        }
    }
}

