/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hive;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.enums.FileFormat;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.hive.HivePartitionField;

@ApiModel(value="Hive sink request")
@JsonTypeDefine(value="HIVE")
public class HiveSinkRequest
extends SinkRequest {
    @ApiModelProperty(value="Hive JDBC URL, such as jdbc:hive2://${ip}:${port}")
    @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url")
    private @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url") String jdbcUrl;
    @ApiModelProperty(value="Username of the Hive server")
    private String username;
    @ApiModelProperty(value="User password of the Hive server")
    private String password;
    @NotBlank(message="dbName cannot be blank")
    @ApiModelProperty(value="Target database name")
    private @NotBlank(message="dbName cannot be blank") String dbName;
    @NotBlank(message="tableName cannot be blank")
    @ApiModelProperty(value="Target table name")
    private @NotBlank(message="tableName cannot be blank") String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="Partition interval, support: 1 H, 1 D, 30 I, 10 I")
    private Integer partitionInterval;
    @ApiModelProperty(value="Partition field list")
    private List<HivePartitionField> partitionFieldList;
    @ApiModelProperty(value="Partition creation strategy, partition start, partition close")
    private String partitionCreationStrategy;
    @ApiModelProperty(value="File format, support: TextFile, ORCFile, RCFile, SequenceFile, Avro, Parquet, etc")
    private String fileFormat = FileFormat.TextFile.name();
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding = StandardCharsets.UTF_8.toString();
    @ApiModelProperty(value="Data separator")
    private String dataSeparator = String.valueOf(1);
    @ApiModelProperty(value="Version for Hive, such as: 3.2.1")
    private String hiveVersion;
    @ApiModelProperty(value="Config directory of Hive on HDFS, needed by sort in light mode, must include hive-site.xml")
    private String hiveConfDir;

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public Integer getPartitionInterval() {
        return this.partitionInterval;
    }

    public List<HivePartitionField> getPartitionFieldList() {
        return this.partitionFieldList;
    }

    public String getPartitionCreationStrategy() {
        return this.partitionCreationStrategy;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public String getHiveConfDir() {
        return this.hiveConfDir;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setPartitionInterval(Integer partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public void setPartitionFieldList(List<HivePartitionField> partitionFieldList) {
        this.partitionFieldList = partitionFieldList;
    }

    public void setPartitionCreationStrategy(String partitionCreationStrategy) {
        this.partitionCreationStrategy = partitionCreationStrategy;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setHiveVersion(String hiveVersion) {
        this.hiveVersion = hiveVersion;
    }

    public void setHiveConfDir(String hiveConfDir) {
        this.hiveConfDir = hiveConfDir;
    }

    @Override
    public String toString() {
        return "HiveSinkRequest(super=" + super.toString() + ", jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", partitionInterval=" + this.getPartitionInterval() + ", partitionFieldList=" + this.getPartitionFieldList() + ", partitionCreationStrategy=" + this.getPartitionCreationStrategy() + ", fileFormat=" + this.getFileFormat() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", hiveVersion=" + this.getHiveVersion() + ", hiveConfDir=" + this.getHiveConfDir() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveSinkRequest)) {
            return false;
        }
        HiveSinkRequest other = (HiveSinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitionInterval = this.getPartitionInterval();
        Integer other$partitionInterval = other.getPartitionInterval();
        if (this$partitionInterval == null ? other$partitionInterval != null : !((Object)this$partitionInterval).equals(other$partitionInterval)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        List<HivePartitionField> this$partitionFieldList = this.getPartitionFieldList();
        List<HivePartitionField> other$partitionFieldList = other.getPartitionFieldList();
        if (this$partitionFieldList == null ? other$partitionFieldList != null : !((Object)this$partitionFieldList).equals(other$partitionFieldList)) {
            return false;
        }
        String this$partitionCreationStrategy = this.getPartitionCreationStrategy();
        String other$partitionCreationStrategy = other.getPartitionCreationStrategy();
        if (this$partitionCreationStrategy == null ? other$partitionCreationStrategy != null : !this$partitionCreationStrategy.equals(other$partitionCreationStrategy)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$hiveVersion = this.getHiveVersion();
        String other$hiveVersion = other.getHiveVersion();
        if (this$hiveVersion == null ? other$hiveVersion != null : !this$hiveVersion.equals(other$hiveVersion)) {
            return false;
        }
        String this$hiveConfDir = this.getHiveConfDir();
        String other$hiveConfDir = other.getHiveConfDir();
        return !(this$hiveConfDir == null ? other$hiveConfDir != null : !this$hiveConfDir.equals(other$hiveConfDir));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HiveSinkRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitionInterval = this.getPartitionInterval();
        result = result * 59 + ($partitionInterval == null ? 43 : ((Object)$partitionInterval).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        List<HivePartitionField> $partitionFieldList = this.getPartitionFieldList();
        result = result * 59 + ($partitionFieldList == null ? 43 : ((Object)$partitionFieldList).hashCode());
        String $partitionCreationStrategy = this.getPartitionCreationStrategy();
        result = result * 59 + ($partitionCreationStrategy == null ? 43 : $partitionCreationStrategy.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $hiveVersion = this.getHiveVersion();
        result = result * 59 + ($hiveVersion == null ? 43 : $hiveVersion.hashCode());
        String $hiveConfDir = this.getHiveConfDir();
        result = result * 59 + ($hiveConfDir == null ? 43 : $hiveConfDir.hashCode());
        return result;
    }
}

