/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeStrategyFactory;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.load.ClickHouseLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClickHouseProvider
implements LoadNodeProvider {
    @Autowired
    private FieldTypeStrategyFactory fieldTypeStrategyFactory;

    @Override
    public Boolean accept(String sinkType) {
        return "CLICKHOUSE".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        ClickHouseSink streamSink = (ClickHouseSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(streamSink.getProperties());
        FieldTypeMappingStrategy fieldTypeMappingStrategy = this.fieldTypeStrategyFactory.getInstance(streamSink.getSinkType());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(streamSink.getSinkFieldList(), streamSink.getSinkName(), fieldTypeMappingStrategy);
        List<FieldRelation> fieldRelations = this.parseSinkFields(streamSink.getSinkFieldList(), constantFieldMap);
        return new ClickHouseLoadNode(streamSink.getSinkName(), streamSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, streamSink.getDbName() + "." + streamSink.getTableName(), streamSink.getJdbcUrl() + "/" + streamSink.getDbName(), streamSink.getUsername(), streamSink.getPassword(), streamSink.getPrimaryKey());
    }
}

