/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.pojo.sink.kudu.KuduSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.load.KuduLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.springframework.stereotype.Service;

@Service
public class KuduProvider
implements LoadNodeProvider {
    @Override
    public Boolean accept(String sinkType) {
        return "KUDU".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        KuduSink kuduSink = (KuduSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(kuduSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(kuduSink.getSinkFieldList(), kuduSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(kuduSink.getSinkFieldList(), constantFieldMap);
        return new KuduLoadNode(kuduSink.getSinkName(), kuduSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, kuduSink.getMasters(), kuduSink.getTableName(), kuduSink.getPartitionKey());
    }
}

