/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.sort.util.StreamParseUtils;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.manager.pojo.stream.StreamPipeline;
import org.apache.inlong.manager.pojo.stream.StreamTransform;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.pojo.transform.joiner.IntervalJoinerDefinition;
import org.apache.inlong.manager.pojo.transform.joiner.JoinerDefinition;
import org.apache.inlong.manager.pojo.transform.joiner.LookUpJoinerDefinition;
import org.apache.inlong.manager.pojo.transform.joiner.TemporalJoinerDefinition;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.StreamInfo;
import org.apache.inlong.sort.protocol.node.transform.TransformNode;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.LogicOperator;
import org.apache.inlong.sort.protocol.transformation.SingleValueCompareOperator;
import org.apache.inlong.sort.protocol.transformation.function.SingleValueFilterFunction;
import org.apache.inlong.sort.protocol.transformation.operator.AndOperator;
import org.apache.inlong.sort.protocol.transformation.operator.EmptyOperator;
import org.apache.inlong.sort.protocol.transformation.operator.EqualOperator;
import org.apache.inlong.sort.protocol.transformation.relation.InnerJoinNodeRelation;
import org.apache.inlong.sort.protocol.transformation.relation.IntervalJoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.LeftOuterJoinNodeRelation;
import org.apache.inlong.sort.protocol.transformation.relation.LeftOuterTemporalJoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.NodeRelation;
import org.apache.inlong.sort.protocol.transformation.relation.RightOuterJoinNodeRelation;
import org.apache.inlong.sort.protocol.transformation.relation.UnionNodeRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRelationUtils {
    private static final Logger log = LoggerFactory.getLogger(NodeRelationUtils.class);
    private static final Set<TransformType> JOIN_NODES = new HashSet<TransformType>();

    public static List<NodeRelation> createNodeRelations(InlongStreamInfo streamInfo) {
        if (StringUtils.isEmpty((CharSequence)streamInfo.getExtParams())) {
            log.warn("stream node relation is empty for {}", (Object)streamInfo);
            return Lists.newArrayList();
        }
        StreamPipeline pipeline = StreamParseUtils.parseStreamPipeline(streamInfo.getExtParams(), streamInfo.getInlongStreamId());
        return pipeline.getPipeline().stream().map(nodeRelation -> {
            if (nodeRelation.getInputNodes().size() > 1) {
                return new UnionNodeRelation((List)Lists.newArrayList(nodeRelation.getInputNodes()), (List)Lists.newArrayList(nodeRelation.getOutputNodes()));
            }
            return new NodeRelation((List)Lists.newArrayList(nodeRelation.getInputNodes()), (List)Lists.newArrayList(nodeRelation.getOutputNodes()));
        }).collect(Collectors.toList());
    }

    public static List<NodeRelation> createNodeRelations(List<StreamSource> sources, List<StreamSink> sinks) {
        NodeRelation relation = new NodeRelation();
        List inputs = sources.stream().map(StreamSource::getSourceName).collect(Collectors.toList());
        List outputs = sinks.stream().map(StreamSink::getSinkName).collect(Collectors.toList());
        relation.setInputs(inputs);
        relation.setOutputs(outputs);
        return Lists.newArrayList((Object[])new NodeRelation[]{relation});
    }

    public static NodeRelation createNodeRelation(List<String> inputs, List<String> outputs) {
        NodeRelation relation = new NodeRelation();
        relation.setInputs(inputs);
        relation.setOutputs(outputs);
        return relation;
    }

    public static void optimizeNodeRelation(StreamInfo streamInfo, List<TransformResponse> transformResponses) {
        if (CollectionUtils.isEmpty(transformResponses)) {
            return;
        }
        Map<String, TransformDefinition> transformTypeMap = transformResponses.stream().collect(Collectors.toMap(TransformResponse::getTransformName, transformResponse -> {
            TransformType transformType = TransformType.forType((String)transformResponse.getTransformType());
            return StreamParseUtils.parseTransformDefinition(transformResponse.getTransformDefinition(), transformType);
        }));
        List nodes = streamInfo.getNodes();
        Map<String, TransformNode> joinNodes = nodes.stream().filter(node -> node instanceof TransformNode).map(node -> (TransformNode)node).filter(transformNode -> {
            TransformDefinition transformDefinition = (TransformDefinition)transformTypeMap.get(transformNode.getName());
            return JOIN_NODES.contains(transformDefinition.getTransformType());
        }).collect(Collectors.toMap(TransformNode::getName, transformNode -> transformNode));
        List relations = streamInfo.getRelations();
        ListIterator shipIterator = relations.listIterator();
        ArrayList joinRelations = Lists.newArrayList();
        block6: while (shipIterator.hasNext()) {
            String nodeName;
            NodeRelation relation = (NodeRelation)shipIterator.next();
            List outputs = relation.getOutputs();
            if (outputs.size() != 1 || joinNodes.get(nodeName = (String)outputs.get(0)) == null) continue;
            TransformDefinition transformDefinition = transformTypeMap.get(nodeName);
            TransformType transformType = transformDefinition.getTransformType();
            switch (transformType) {
                case JOINER: {
                    joinRelations.add(NodeRelationUtils.getNodeRelation((JoinerDefinition)transformDefinition, relation));
                    shipIterator.remove();
                    continue block6;
                }
                case LOOKUP_JOINER: {
                    assert (transformDefinition instanceof LookUpJoinerDefinition);
                    joinRelations.add(NodeRelationUtils.getNodeRelation((LookUpJoinerDefinition)transformDefinition, relation));
                    shipIterator.remove();
                    continue block6;
                }
                case INTERVAL_JOINER: {
                    if (transformDefinition instanceof IntervalJoinerDefinition) {
                        joinRelations.add(NodeRelationUtils.getNodeRelation((IntervalJoinerDefinition)transformDefinition, relation));
                    }
                    shipIterator.remove();
                    continue block6;
                }
                case TEMPORAL_JOINER: {
                    assert (transformDefinition instanceof TemporalJoinerDefinition);
                    joinRelations.add(NodeRelationUtils.getNodeRelation((TemporalJoinerDefinition)transformDefinition, relation));
                    shipIterator.remove();
                    continue block6;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported transformType for %s", transformType));
        }
        relations.addAll(joinRelations);
    }

    private static NodeRelation getNodeRelation(JoinerDefinition joinerDefinition, NodeRelation nodeRelation) {
        JoinerDefinition.JoinMode joinMode = joinerDefinition.getJoinMode();
        String leftNode = NodeRelationUtils.getNodeName(joinerDefinition.getLeftNode());
        String rightNode = NodeRelationUtils.getNodeName(joinerDefinition.getRightNode());
        ArrayList preNodes = Lists.newArrayList((Object[])new String[]{leftNode, rightNode});
        List<StreamField> leftJoinFields = joinerDefinition.getLeftJoinFields();
        List<StreamField> rightJoinFields = joinerDefinition.getRightJoinFields();
        ArrayList filterFunctions = Lists.newArrayList();
        for (int index = 0; index < leftJoinFields.size(); ++index) {
            StreamField leftField = leftJoinFields.get(index);
            StreamField rightField = rightJoinFields.get(index);
            Object operator = index != 0 ? AndOperator.getInstance() : EmptyOperator.getInstance();
            filterFunctions.add(NodeRelationUtils.createFilterFunction(leftField, rightField, (LogicOperator)operator));
        }
        HashMap<String, ArrayList> joinConditions = new HashMap<String, ArrayList>();
        joinConditions.put(rightNode, filterFunctions);
        switch (joinMode) {
            case LEFT_JOIN: {
                return new LeftOuterJoinNodeRelation((List)preNodes, nodeRelation.getOutputs(), joinConditions);
            }
            case INNER_JOIN: {
                return new InnerJoinNodeRelation((List)preNodes, nodeRelation.getOutputs(), joinConditions);
            }
            case RIGHT_JOIN: {
                return new RightOuterJoinNodeRelation((List)preNodes, nodeRelation.getOutputs(), joinConditions);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported join mode=%s for inlong", new Object[]{joinMode}));
    }

    private static NodeRelation getNodeRelation(LookUpJoinerDefinition joinerDefinition, NodeRelation nodeRelation) {
        String leftNode = NodeRelationUtils.getNodeName(joinerDefinition.getLeftNode());
        String rightNode = NodeRelationUtils.getNodeName(joinerDefinition.getRightNode());
        ArrayList preNodes = Lists.newArrayList((Object[])new String[]{leftNode, rightNode});
        List<StreamField> leftJoinFields = joinerDefinition.getLeftJoinFields();
        List<StreamField> rightJoinFields = joinerDefinition.getRightJoinFields();
        ArrayList filterFunctions = Lists.newArrayList();
        for (int index = 0; index < leftJoinFields.size(); ++index) {
            StreamField leftField = leftJoinFields.get(index);
            StreamField rightField = rightJoinFields.get(index);
            Object operator = index != 0 ? AndOperator.getInstance() : EmptyOperator.getInstance();
            filterFunctions.add(NodeRelationUtils.createFilterFunction(leftField, rightField, (LogicOperator)operator));
        }
        HashMap<String, ArrayList> joinConditions = new HashMap<String, ArrayList>();
        joinConditions.put(rightNode, filterFunctions);
        FieldInfo systemTime = new FieldInfo(MetaField.PROCESS_TIME.name());
        return new LeftOuterTemporalJoinRelation((List)preNodes, nodeRelation.getOutputs(), joinConditions, systemTime);
    }

    private static NodeRelation getNodeRelation(IntervalJoinerDefinition joinerDefinition, NodeRelation nodeRelation) {
        String leftNode = NodeRelationUtils.getNodeName(joinerDefinition.getLeftNode());
        String rightNode = NodeRelationUtils.getNodeName(joinerDefinition.getRightNode());
        ArrayList preNodes = Lists.newArrayList((Object[])new String[]{leftNode, rightNode});
        List<StreamField> leftJoinFields = joinerDefinition.getLeftJoinFields();
        List<StreamField> rightJoinFields = joinerDefinition.getRightJoinFields();
        ArrayList filterFunctions = Lists.newArrayList();
        for (int index = 0; index < leftJoinFields.size(); ++index) {
            StreamField leftField = leftJoinFields.get(index);
            StreamField rightField = rightJoinFields.get(index);
            Object operator = index != 0 ? AndOperator.getInstance() : EmptyOperator.getInstance();
            filterFunctions.add(NodeRelationUtils.createFilterFunction(leftField, rightField, (LogicOperator)operator));
        }
        LinkedHashMap<String, ArrayList> joinConditions = new LinkedHashMap<String, ArrayList>();
        joinConditions.put(rightNode, filterFunctions);
        return new IntervalJoinRelation((List)preNodes, nodeRelation.getOutputs(), joinConditions);
    }

    private static NodeRelation getNodeRelation(TemporalJoinerDefinition joinerDefinition, NodeRelation nodeRelation) {
        JoinerDefinition.JoinMode joinMode = joinerDefinition.getJoinMode();
        String leftNode = NodeRelationUtils.getNodeName(joinerDefinition.getLeftNode());
        String rightNode = NodeRelationUtils.getNodeName(joinerDefinition.getRightNode());
        ArrayList preNodes = Lists.newArrayList((Object[])new String[]{leftNode, rightNode});
        List<StreamField> leftJoinFields = joinerDefinition.getLeftJoinFields();
        List<StreamField> rightJoinFields = joinerDefinition.getRightJoinFields();
        ArrayList filterFunctions = Lists.newArrayList();
        for (int index = 0; index < leftJoinFields.size(); ++index) {
            StreamField leftField = leftJoinFields.get(index);
            StreamField rightField = rightJoinFields.get(index);
            Object operator = index != 0 ? AndOperator.getInstance() : EmptyOperator.getInstance();
            filterFunctions.add(NodeRelationUtils.createFilterFunction(leftField, rightField, (LogicOperator)operator));
        }
        HashMap<String, ArrayList> joinConditions = new HashMap<String, ArrayList>();
        joinConditions.put(rightNode, filterFunctions);
        switch (joinMode) {
            case LEFT_JOIN: {
                return new LeftOuterJoinNodeRelation((List)preNodes, nodeRelation.getOutputs(), joinConditions);
            }
            case INNER_JOIN: {
                return new InnerJoinNodeRelation((List)preNodes, nodeRelation.getOutputs(), joinConditions);
            }
            case RIGHT_JOIN: {
                return new RightOuterJoinNodeRelation((List)preNodes, nodeRelation.getOutputs(), joinConditions);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported join mode=%s for inlong", new Object[]{joinMode}));
    }

    private static SingleValueFilterFunction createFilterFunction(StreamField leftField, StreamField rightField, LogicOperator operator) {
        FieldInfo sourceField = new FieldInfo(leftField.getOriginFieldName(), leftField.getOriginNodeName(), FieldInfoUtils.convertFieldFormat(leftField.getFieldType(), leftField.getFieldFormat()));
        FieldInfo targetField = new FieldInfo(rightField.getOriginFieldName(), rightField.getOriginNodeName(), FieldInfoUtils.convertFieldFormat(rightField.getFieldType(), rightField.getFieldFormat()));
        return new SingleValueFilterFunction(operator, (FunctionParam)sourceField, (SingleValueCompareOperator)EqualOperator.getInstance(), (FunctionParam)targetField);
    }

    private static String getNodeName(StreamNode node) {
        if (node instanceof StreamSource) {
            return ((StreamSource)node).getSourceName();
        }
        if (node instanceof StreamSink) {
            return ((StreamSink)node).getSinkName();
        }
        return ((StreamTransform)node).getTransformName();
    }

    static {
        JOIN_NODES.add(TransformType.JOINER);
        JOIN_NODES.add(TransformType.LOOKUP_JOINER);
        JOIN_NODES.add(TransformType.INTERVAL_JOINER);
        JOIN_NODES.add(TransformType.TEMPORAL_JOINER);
    }
}

