/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.utils.ExcuteLinux;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentUtils {
    public static final String EQUAL = "=";
    public static final String M_VALUE = "m";
    public static final String ADDITION_SPLITTER = "&";
    public static final String BEIJING_TIME_ZONE = "GMT+8:00";
    public static final String HOUR_PATTERN = "yyyyMMddHH";
    public static final String DAY_PATTERN = "yyyyMMdd";
    public static final String DEFAULT_PATTERN = "yyyyMMddHHmm";
    public static final String DAY = "D";
    public static final String HOUR = "H";
    public static final String HOUR_LOW_CASE = "h";
    public static final String MINUTE = "m";
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileMd5(File file) {
        try (InputStream is = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);){
            String string = DigestUtils.md5Hex((InputStream)is);
            return string;
        }
        catch (Exception ex) {
            LOGGER.warn("cannot get md5 of file: " + file, (Throwable)ex);
            return "";
        }
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static void finallyClose(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception ex) {
                LOGGER.info("error while closing: " + resource, (Throwable)ex);
            }
        }
    }

    public static void finallyClose(AutoCloseable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception ex) {
                LOGGER.info("error while closing: " + resource, (Throwable)ex);
            }
        }
    }

    public static int getRandomBySeed(int seed) {
        return ThreadLocalRandom.current().nextInt(0, seed) + seed;
    }

    public static String getLocalIp() {
        String ip = "127.0.0.1";
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            ip = socket.getLocalAddress().getHostAddress();
        }
        catch (Exception ex) {
            LOGGER.error("error while get local ip", (Throwable)ex);
        }
        return ip;
    }

    public static String getLocalHost() {
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            LOGGER.error("error while get local host", (Throwable)ex);
        }
        return host;
    }

    public static String getUniqId(String prefix, long index) {
        return AgentUtils.getUniqId(prefix, "", index);
    }

    public static String getUniqId(String prefix, String id, long index) {
        long currentTime = System.currentTimeMillis() / 1000L;
        return prefix + currentTime + "_" + id + "_" + index;
    }

    public static String getSingleJobId(String prefix, String id) {
        return prefix + id;
    }

    public static void silenceSleepInMs(long millisecond) {
        try {
            TimeUnit.MILLISECONDS.sleep(millisecond);
        }
        catch (Exception e) {
            LOGGER.warn("error in silence sleep: ", (Throwable)e);
        }
    }

    public static void silenceSleepInSeconds(long seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (Exception e) {
            LOGGER.warn("error in silence sleep: ", (Throwable)e);
        }
    }

    public static String formatCurrentTime(String formatter) {
        return AgentUtils.formatCurrentTime(formatter, Locale.getDefault());
    }

    public static String formatCurrentTime(String formatter, Locale locale) {
        ZonedDateTime zoned = ZonedDateTime.now();
        return DateTimeFormatter.ofPattern(formatter).withLocale(locale).format(zoned);
    }

    public static String formatCurrentTimeWithOffset(String formatter, int day, int hour, int min) {
        ZonedDateTime zoned = ZonedDateTime.now().plusDays(day).plusHours(hour).plusMinutes(min);
        return DateTimeFormatter.ofPattern(formatter).withLocale(Locale.getDefault()).format(zoned);
    }

    public static String formatCurrentTimeWithoutOffset(String formatter) {
        ZonedDateTime zoned = ZonedDateTime.now().plusDays(0L).plusHours(0L).plusMinutes(0L);
        return DateTimeFormatter.ofPattern(formatter).withLocale(Locale.getDefault()).format(zoned);
    }

    public static Pair<String, Map<String, String>> parseAddAttr(String additionStr) {
        HashMap<String, String> attr = new HashMap<String, String>();
        String[] split = additionStr.split(ADDITION_SPLITTER);
        String mValue = "";
        for (String s : split) {
            if (!s.contains(EQUAL)) continue;
            String[] pairs = s.split(EQUAL);
            if (pairs[0].equalsIgnoreCase("m")) {
                mValue = pairs[1];
                continue;
            }
            AgentUtils.getAttrs(attr, s, pairs);
        }
        return Pair.of((Object)mValue, attr);
    }

    public static Map<String, String> parseAddAttrToMap(String addictiveAttr) {
        StringTokenizer token = new StringTokenizer(addictiveAttr, ADDITION_SPLITTER);
        HashMap<String, String> attr = new HashMap<String, String>();
        while (token.hasMoreTokens()) {
            String[] pairs;
            String value = token.nextToken().trim();
            if (!value.contains(EQUAL) || (pairs = value.split(EQUAL))[0].equalsIgnoreCase("m")) continue;
            if (value.endsWith(EQUAL) && pairs.length == 1) {
                attr.put(pairs[0], "");
                continue;
            }
            attr.put(pairs[0], pairs[1]);
        }
        return attr;
    }

    private static void getAttrs(Map<String, String> attr, String s, String[] pairs) {
        if (s.endsWith(EQUAL) && pairs.length == 1) {
            attr.put(pairs[0], "");
        } else {
            attr.put(pairs[0], pairs[1]);
        }
    }

    public static Map<String, String> getAdditionAttr(String additionStr) {
        Pair<String, Map<String, String>> mValueAttrs = AgentUtils.parseAddAttr(additionStr);
        return (Map)mValueAttrs.getRight();
    }

    public static String getmValue(String addictiveAttr) {
        Pair<String, Map<String, String>> mValueAttrs = AgentUtils.parseAddAttr(addictiveAttr);
        return (String)mValueAttrs.getLeft();
    }

    public static String fetchLocalIp() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{AgentConfiguration.getAgentConf().get("agent.custom.fixed.ip", null)})) {
            return AgentConfiguration.getAgentConf().get("agent.custom.fixed.ip");
        }
        return AgentConfiguration.getAgentConf().get("agent.local.ip", AgentUtils.getLocalIp());
    }

    public static String fetchLocalUuid() {
        String uuid = "";
        if (!AgentConfiguration.getAgentConf().getBoolean("agent.local.uuid.open", AgentConstants.DEFAULT_AGENT_LOCAL_UUID_OPEN)) {
            return uuid;
        }
        try {
            String localUuid = AgentConfiguration.getAgentConf().get("agent.local.uuid");
            if (StringUtils.isNotEmpty((CharSequence)localUuid)) {
                uuid = localUuid;
                return uuid;
            }
            String result = ExcuteLinux.exeCmd("dmidecode | grep UUID");
            if (StringUtils.isNotEmpty((CharSequence)result) && StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"UUID")) {
                uuid = result.split(":")[1].trim();
                return uuid;
            }
        }
        catch (Exception e) {
            LOGGER.error("fetch uuid error", (Throwable)e);
        }
        return uuid;
    }

    public static long timeStrConvertToMillSec(String time, String cycleUnit) {
        long defaultTime = System.currentTimeMillis();
        if (time.isEmpty() || cycleUnit.isEmpty()) {
            return defaultTime;
        }
        String pattern = DEFAULT_PATTERN;
        switch (cycleUnit) {
            case "D": {
                pattern = DAY_PATTERN;
                time = time.substring(0, 8);
                break;
            }
            case "H": 
            case "h": {
                pattern = HOUR_PATTERN;
                time = time.substring(0, 10);
                break;
            }
            case "m": {
                break;
            }
            default: {
                LOGGER.error("cycle unit {} is illegal, please check!", (Object)cycleUnit);
            }
        }
        return AgentUtils.parseTimeToMillSec(time, pattern);
    }

    private static long parseTimeToMillSec(String time, String pattern) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            df.setTimeZone(TimeZone.getTimeZone(BEIJING_TIME_ZONE));
            return df.parse(time).getTime();
        }
        catch (ParseException e) {
            LOGGER.error("convert time string {} to millSec error", (Object)time);
            return System.currentTimeMillis();
        }
    }

    public static File makeDirsIfNotExist(String childPath, String parentPath) {
        File finalPath = new File(parentPath, childPath);
        try {
            boolean result = finalPath.mkdirs();
            LOGGER.info("try to create local path {}, result is {}", (Object)finalPath, (Object)result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return finalPath;
    }

    public static boolean enableOOMExit() {
        return AgentConfiguration.getAgentConf().getBoolean("agent.enable.oom.exit", false);
    }
}

