/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import java.util.ArrayList;
import java.util.List;

public class ByteUtil {
    public static byte[][] split(byte[] source, byte[] separator) {
        return ByteUtil.split(source, separator, -1);
    }

    public static byte[][] split(byte[] source, byte[] separator, int limit) {
        List<Range> segments = ByteUtil.splitRanges(source, separator, limit);
        byte[][] splits = new byte[segments.size()][];
        for (int i = 0; i < segments.size(); ++i) {
            Range r = segments.get(i);
            byte[] tmp = new byte[r.length()];
            if (tmp.length > 0) {
                System.arraycopy(source, r.start(), tmp, 0, r.length());
            }
            splits[i] = tmp;
        }
        return splits;
    }

    public static List<Range> splitRanges(byte[] source, byte[] separator) {
        return ByteUtil.splitRanges(source, separator, -1);
    }

    public static List<Range> splitRanges(byte[] source, byte[] separator, int limit) {
        ArrayList<Range> segments = new ArrayList<Range>();
        int start = 0;
        block0: for (int i = 0; i < source.length; ++i) {
            for (int j = 0; j < separator.length; ++j) {
                if (source[i + j] != separator[j]) continue block0;
            }
            if (limit > 0 && segments.size() >= limit - 1) break;
            segments.add(new Range(start, i));
            start = i + separator.length;
            i += separator.length - 1;
        }
        if (start <= source.length) {
            segments.add(new Range(start, source.length));
        }
        return segments;
    }

    public static byte[] join(byte[] separator, byte[] ... components) {
        if (components == null || components.length == 0) {
            return new byte[0];
        }
        int finalSize = 0;
        if (separator != null) {
            finalSize = separator.length * (components.length - 1);
        }
        for (byte[] comp : components) {
            finalSize += comp.length;
        }
        byte[] buf = new byte[finalSize];
        int offset = 0;
        for (int i = 0; i < components.length; ++i) {
            System.arraycopy(components[i], 0, buf, offset, components[i].length);
            offset += components[i].length;
            if (i >= components.length - 1 || separator == null || separator.length <= 0) continue;
            System.arraycopy(separator, 0, buf, offset, separator.length);
            offset += separator.length;
        }
        return buf;
    }

    public static int indexOf(byte[] array, byte[] target, int fromIndex) {
        if (array == null || target == null) {
            return -1;
        }
        if (fromIndex < 0 || fromIndex > array.length - target.length) {
            return -1;
        }
        if (target.length == 0) {
            return fromIndex;
        }
        block0: for (int i = fromIndex; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static byte[] safeCopy(byte[] source, int offset, int length) {
        if (length < 0 || source.length < offset + length) {
            return null;
        }
        byte[] copy = new byte[length];
        System.arraycopy(source, offset, copy, 0, length);
        return copy;
    }

    public static class Range {
        private int startIdx;
        private int endIdx;

        public Range(int start, int end) {
            if (start < 0 || end < start) {
                throw new IllegalArgumentException("Invalid range, required that: 0 <= start <= end; start=" + start + ", end=" + end);
            }
            this.startIdx = start;
            this.endIdx = end;
        }

        public int start() {
            return this.startIdx;
        }

        public int end() {
            return this.endIdx;
        }

        public int length() {
            return this.endIdx - this.startIdx;
        }
    }
}

