/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils.file;

import com.google.common.base.Predicate;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirNameRegexMatchPredicate
implements Predicate<File> {
    private Pattern pattern;

    public DirNameRegexMatchPredicate(String regex, boolean caseSensitive) {
        if (regex == null || regex.isEmpty()) {
            regex = ".*";
        }
        this.pattern = !caseSensitive ? Pattern.compile(regex, 2) : Pattern.compile(regex);
    }

    public boolean apply(File input) {
        Matcher matcher = this.pattern.matcher(input.getAbsolutePath());
        return matcher.matches() || matcher.lookingAt();
    }
}

