/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.auth;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Locale;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="type")
public interface Authentication {
    public AuthType getAuthType();

    public void configure(Map<String, String> var1);

    public static enum AuthType {
        UNAME_PASSWD,
        TOKEN,
        SECRET,
        SECRET_AND_TOKEN;


        public static AuthType forType(String type) {
            for (AuthType authType : AuthType.values()) {
                if (!authType.name().equals(type.toUpperCase())) continue;
                return authType;
            }
            throw new IllegalArgumentException(String.format("Unsupported authType=%s", type));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

