/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.conversion;

import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.manager.common.conversion.ConversionStatusContext;
import org.apache.inlong.manager.common.conversion.ConversionStrategy;
import org.apache.inlong.manager.common.conversion.DaysToMinute;
import org.apache.inlong.manager.common.conversion.DaysToSeconds;
import org.apache.inlong.manager.common.conversion.GBToMB;
import org.apache.inlong.manager.common.conversion.HoursToMinute;
import org.apache.inlong.manager.common.conversion.HoursToSeconds;
import org.apache.inlong.manager.common.conversion.MBToMB;
import org.apache.inlong.manager.common.conversion.SecondsToSeconds;
import org.apache.inlong.manager.common.conversion.TBToMB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConversionHandle {
    private static final Logger log = LoggerFactory.getLogger(ConversionHandle.class);
    private static Map<String, ConversionStrategy> unitMap;

    private void loadStrategy() {
        unitMap = new HashMap<String, ConversionStrategy>(16);
        unitMap.put("hours_minutes", new HoursToMinute());
        unitMap.put("hours_seconds", new HoursToSeconds());
        unitMap.put("gb_mb", new GBToMB());
        unitMap.put("tb_mb", new TBToMB());
        unitMap.put("days_seconds", new DaysToSeconds());
        unitMap.put("days_minutes", new DaysToMinute());
        unitMap.put("seconds_seconds", new SecondsToSeconds());
        unitMap.put("mb_mb", new MBToMB());
    }

    public Integer handleConversion(Integer value, String type) {
        if (unitMap == null) {
            this.loadStrategy();
        }
        ConversionStrategy conversionStrategy = unitMap.get(type);
        ConversionStatusContext conversionStatusContext = new ConversionStatusContext(conversionStrategy);
        return conversionStatusContext.executeConversion(value);
    }
}

