/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public enum ConsumeStatus {
    TO_BE_SUBMIT(100, "waiting for submit"),
    TO_BE_APPROVAL(101, "waiting for approval"),
    APPROVE_REJECTED(102, "approval rejected"),
    APPROVE_PASSED(103, "approval passed"),
    APPROVE_CANCELED(104, "approval canceled"),
    DELETING(41, "deleting"),
    DELETED(40, "deleted");

    private static final Map<ConsumeStatus, Set<ConsumeStatus>> CONSUME_STATE_AUTOMATON;
    private final Integer code;
    private final String description;

    private ConsumeStatus(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static ConsumeStatus forCode(int code) {
        for (ConsumeStatus status : ConsumeStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new BusinessException(String.format("Illegal code=%s for ConsumeStatus", code));
    }

    public static boolean notAllowedTransfer(ConsumeStatus cur, ConsumeStatus next) {
        Set<ConsumeStatus> nextSet = CONSUME_STATE_AUTOMATON.get((Object)cur);
        return nextSet == null || !nextSet.contains((Object)next);
    }

    public static boolean allowedUpdate(ConsumeStatus status) {
        return status == TO_BE_SUBMIT || status == APPROVE_REJECTED || status == APPROVE_CANCELED;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        CONSUME_STATE_AUTOMATON = Maps.newHashMap();
        CONSUME_STATE_AUTOMATON.put(TO_BE_SUBMIT, Sets.newHashSet((Object[])new ConsumeStatus[]{TO_BE_SUBMIT, TO_BE_APPROVAL, DELETING}));
        CONSUME_STATE_AUTOMATON.put(TO_BE_APPROVAL, Sets.newHashSet((Object[])new ConsumeStatus[]{TO_BE_APPROVAL, APPROVE_REJECTED, APPROVE_PASSED, APPROVE_CANCELED, DELETING}));
        CONSUME_STATE_AUTOMATON.put(APPROVE_REJECTED, Sets.newHashSet((Object[])new ConsumeStatus[]{APPROVE_REJECTED, TO_BE_APPROVAL, DELETING}));
        CONSUME_STATE_AUTOMATON.put(APPROVE_CANCELED, Sets.newHashSet((Object[])new ConsumeStatus[]{APPROVE_CANCELED, TO_BE_APPROVAL, DELETING}));
        CONSUME_STATE_AUTOMATON.put(APPROVE_PASSED, Sets.newHashSet((Object[])new ConsumeStatus[]{APPROVE_PASSED, TO_BE_APPROVAL, DELETING}));
        CONSUME_STATE_AUTOMATON.put(DELETING, Sets.newHashSet((Object[])new ConsumeStatus[]{DELETING, DELETED}));
        CONSUME_STATE_AUTOMATON.put(DELETED, Sets.newHashSet((Object[])new ConsumeStatus[]{DELETED}));
    }
}

