/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.transform;

import java.util.List;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sort.util.FilterFunctionUtils;
import org.apache.inlong.manager.pojo.sort.util.StreamParseUtils;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.pojo.transform.filter.FilterDefinition;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformSqlParser {
    private static final Logger log = LoggerFactory.getLogger(TransformSqlParser.class);

    public static String parse(List<TransformResponse> transformResponseList, List<SinkField> sinkFields) {
        log.info("start to parse transform sql for transform list={}", transformResponseList);
        StringBuilder result = new StringBuilder().append((CharSequence)TransformSqlParser.genSimpleSelectSql(sinkFields)).append((CharSequence)TransformSqlParser.getFilterSql(transformResponseList));
        log.info("success to parse transform for transform list={}, result={}", transformResponseList, (Object)result);
        return result.toString().replaceAll("`", "");
    }

    private static StringBuilder genSimpleSelectSql(List<SinkField> fields) {
        StringBuilder sb = new StringBuilder("SELECT ");
        for (SinkField field : fields) {
            sb.append("`").append(field.getSourceFieldName()).append("`,");
        }
        sb.deleteCharAt(sb.length() - 1).append(" FROM SOURCE");
        return sb;
    }

    private static StringBuilder getFilterSql(List<TransformResponse> filterList) {
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (TransformResponse transformResponse : filterList) {
            TransformType transformType = TransformType.forType((String)transformResponse.getTransformType());
            TransformDefinition transformDefinition = StreamParseUtils.parseTransformDefinition((String)transformResponse.getTransformDefinition(), (TransformType)transformType);
            String transformName = transformResponse.getTransformName();
            switch (transformType) {
                case FILTER: {
                    stringBuilder.append(" WHERE");
                    FilterDefinition filterDefinition = (FilterDefinition)transformDefinition;
                    List filterFunctions = FilterFunctionUtils.createFilterFunctions((FilterDefinition)filterDefinition, (String)transformName);
                    for (FilterFunction filterFunction : filterFunctions) {
                        stringBuilder.append(" ").append(filterFunction.format());
                    }
                    continue block4;
                }
                case SPLITTER: 
                case STRING_REPLACER: 
                case ENCRYPT: 
                case DE_DUPLICATION: 
                case JOINER: 
                case LOOKUP_JOINER: 
                case TEMPORAL_JOINER: 
                case INTERVAL_JOINER: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported transformType=%s", transformType));
                }
            }
        }
        return stringBuilder;
    }
}

