/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDatabaseSchema.class);
    private final OracleDdlParser ddlParser;
    private boolean storageInitializationExecuted = false;

    public OracleDatabaseSchema(OracleConnectorConfig connectorConfig, OracleValueConverters valueConverters, DefaultValueConverter defaultValueConverter, SchemaNameAdjuster schemaNameAdjuster, TopicSelector<TableId> topicSelector, StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity) {
        super((HistorizedRelationalDatabaseConnectorConfig)connectorConfig, topicSelector, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder((ValueConverterProvider)valueConverters, defaultValueConverter, schemaNameAdjuster, connectorConfig.customConverterRegistry(), connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getSanitizeFieldNames(), false), StreamingAdapter.TableNameCaseSensitivity.INSENSITIVE.equals((Object)tableNameCaseSensitivity), connectorConfig.getKeyMapper());
        this.ddlParser = new OracleDdlParser(true, false, connectorConfig.isSchemaCommentsHistoryEnabled(), valueConverters, connectorConfig.getTableFilters().dataCollectionFilter());
    }

    public Tables getTables() {
        return this.tables();
    }

    public OracleDdlParser getDdlParser() {
        return this.ddlParser;
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
        switch (schemaChange.getType()) {
            case CREATE: 
            case ALTER: {
                schemaChange.getTableChanges().forEach(x -> {
                    this.buildAndRegisterSchema(x.getTable());
                    this.tables().overwriteTable(x.getTable());
                });
                break;
            }
            case DROP: {
                schemaChange.getTableChanges().forEach(x -> this.removeSchema(x.getId()));
                break;
            }
        }
        if (schemaChange.getTables().stream().map(Table::id).anyMatch(arg_0 -> ((Tables.TableFilter)this.getTableFilter()).isIncluded(arg_0))) {
            LOGGER.debug("Recorded DDL statements for database '{}': {}", (Object)schemaChange.getDatabase(), (Object)schemaChange.getDdl());
            this.record(schemaChange, schemaChange.getTableChanges());
        }
    }

    public void initializeStorage() {
        super.initializeStorage();
        this.storageInitializationExecuted = true;
    }

    public boolean isStorageInitializationExecuted() {
        return this.storageInitializationExecuted;
    }

    public boolean historyExists() {
        return this.databaseHistory.exists();
    }
}

