/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.example;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.consumer.ConsumePosition;
import org.apache.inlong.tubemq.client.consumer.ConsumerResult;
import org.apache.inlong.tubemq.client.consumer.PullMessageConsumer;
import org.apache.inlong.tubemq.client.factory.MessageSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeSingleSessionFactory;
import org.apache.inlong.tubemq.corebase.TErrCodeConstants;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.example.MsgSendReceiveStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagePullConsumerExample {
    private static final Logger logger = LoggerFactory.getLogger(MessagePullConsumerExample.class);
    private static final MsgSendReceiveStats msgRcvStats = new MsgSendReceiveStats(false);
    private static PullMessageConsumer pullConsumer;
    private static MessageSessionFactory sessionFactory;

    public static void main(String[] args) throws Throwable {
        String masterServers = args[0];
        String subTopicAndFiterItems = args[1];
        String groupName = args[2];
        final int consumeCount = Integer.parseInt(args[3]);
        int fetchThreadCnt = 3;
        if (args.length > 4) {
            fetchThreadCnt = MixedUtils.mid((int)Integer.parseInt(args[4]), (int)1, (int)Runtime.getRuntime().availableProcessors());
        }
        Map topicAndFiltersMap = MixedUtils.parseTopicParam((String)subTopicAndFiterItems);
        ConsumerConfig consumerConfig = new ConsumerConfig(masterServers, groupName);
        consumerConfig.setConsumePosition(ConsumePosition.CONSUMER_FROM_LATEST_OFFSET);
        sessionFactory = new TubeSingleSessionFactory((TubeClientConfig)consumerConfig);
        pullConsumer = sessionFactory.createPullConsumer(consumerConfig);
        for (Map.Entry entry : topicAndFiltersMap.entrySet()) {
            pullConsumer.subscribe((String)entry.getKey(), (TreeSet)entry.getValue());
        }
        pullConsumer.completeSubscribe();
        Thread[] fetchRunners = new Thread[fetchThreadCnt];
        for (int i = 0; i < fetchRunners.length; ++i) {
            fetchRunners[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int getCount = consumeCount;
                    while (!pullConsumer.isPartitionsReady(5000L) && !pullConsumer.isShutdown()) {
                    }
                    block3: while (true) {
                        try {
                            do {
                                if (pullConsumer.isShutdown()) {
                                    logger.warn("Consumer is shutdown!");
                                    break block3;
                                }
                                ConsumerResult csmResult = pullConsumer.getMessage();
                                if (csmResult.isSuccess()) {
                                    List messageList = csmResult.getMessageList();
                                    if (messageList != null && !messageList.isEmpty()) {
                                        msgRcvStats.addMsgCount(csmResult.getTopicName(), messageList.size());
                                    }
                                    pullConsumer.confirmConsume(csmResult.getConfirmContext(), true);
                                    continue;
                                }
                                if (TErrCodeConstants.IGNORE_ERROR_SET.contains(csmResult.getErrCode())) continue;
                                logger.debug("Receive messages errorCode is {}, Error message is {}", (Object)csmResult.getErrCode(), (Object)csmResult.getErrMsg());
                            } while (consumeCount <= 0 || --getCount > 0);
                            logger.info("Consumer has consumed {} messages!", (Object)consumeCount);
                        }
                        catch (Throwable throwable) {
                            continue;
                        }
                        break;
                    }
                    logger.info("The fetch thread has exited!");
                }
            }, "_fetch_runner_" + i);
        }
        for (Thread thread : fetchRunners) {
            thread.start();
        }
        Thread statisticThread = new Thread((Runnable)msgRcvStats, "Receive Statistic Thread");
        statisticThread.start();
    }
}

