/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.agg.batch;

import java.io.Serializable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator$;
import org.apache.flink.table.planner.codegen.agg.batch.AggCodeGenHelper$;
import org.apache.flink.table.planner.codegen.agg.batch.HashAggCodeGenHelper;
import org.apache.flink.table.planner.codegen.sort.SortCodeGenerator;
import org.apache.flink.table.planner.expressions.DeclarativeExpressionResolver;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.planner.plan.utils.AggregateInfo;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import org.apache.flink.table.runtime.generated.GeneratedNormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.aggregate.BytesHashMapSpillMemorySegmentPool;
import org.apache.flink.table.runtime.operators.sort.BufferedKVExternalSorter;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.KeyValueIterator;
import org.apache.flink.table.runtime.util.collections.binary.BytesHashMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesMap;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class HashAggCodeGenHelper$ {
    public static HashAggCodeGenHelper$ MODULE$;

    static {
        new HashAggCodeGenHelper$();
    }

    public void prepareHashAggKVTypes(CodeGeneratorContext ctx, String aggMapKeyTypesTerm, String aggBufferTypesTerm, RowType aggMapKeyType, RowType aggBufferType) {
        ctx.addReusableObjectWithName(aggMapKeyType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))), aggMapKeyTypesTerm, ctx.addReusableObjectWithName$default$3());
        ctx.addReusableObjectWithName(aggBufferType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))), aggBufferTypesTerm, ctx.addReusableObjectWithName$default$3());
    }

    public void prepareHashAggMap(CodeGeneratorContext ctx, String groupKeyTypesTerm, String aggBufferTypesTerm, String aggregateMapTerm) {
        String mapTypeTerm = BytesHashMap.class.getName();
        ctx.addReusableMember(new StringBuilder(20).append("private transient ").append(mapTypeTerm).append(" ").append(aggregateMapTerm).append(";").toString());
        ctx.addReusableOpenStatement(new StringBuilder(107).append(aggregateMapTerm).append(" ").append(new StringBuilder(7).append("= new ").append(mapTypeTerm).append("(").toString()).append("this.getContainingTask(),").append("this.getContainingTask().getEnvironment().getMemoryManager(),").append("computeMemorySize(),").append(new StringBuilder(2).append(" ").append(groupKeyTypesTerm).append(",").toString()).append(new StringBuilder(3).append(" ").append(aggBufferTypesTerm).append(");").toString()).toString());
        ctx.addReusableCloseStatement(new StringBuilder(8).append(aggregateMapTerm).append(".free();").toString());
        ctx.addReusableCloseStatement("");
    }

    public scala.Tuple2<String, String> prepareTermForAggMapIteration(CodeGeneratorContext ctx, String outputTerm, RowType outputType, Class<? extends RowData> outputClass) {
        String reuseAggMapKeyTerm = CodeGenUtils$.MODULE$.newName("reuseAggMapKey");
        String reuseAggBufferTerm = CodeGenUtils$.MODULE$.newName("reuseAggBuffer");
        String rowData = RowData.class.getName();
        ctx.addReusableOutputRecord((LogicalType)outputType, outputClass, outputTerm, ctx.addReusableOutputRecord$default$4());
        ctx.addReusableMember(new StringBuilder(20).append("private transient ").append(rowData).append(" ").append(reuseAggMapKeyTerm).append(";").toString());
        ctx.addReusableMember(new StringBuilder(20).append("private transient ").append(rowData).append(" ").append(reuseAggBufferTerm).append(";").toString());
        return new scala.Tuple2((Object)reuseAggMapKeyTerm, (Object)reuseAggBufferTerm);
    }

    public Tuple3<GeneratedExpression, GeneratedExpression, GeneratedExpression> genHashAggCodes(boolean isMerge, boolean isFinal, CodeGeneratorContext ctx, RelBuilder builder, scala.Tuple2<int[], int[]> groupingAndAuxGrouping, String inputTerm, RowType inputType, Seq<AggregateInfo> aggInfos, String currentAggBufferTerm, RowType aggBufferRowType, LogicalType[][] aggBufferTypes, String outputTerm, RowType outputType, String groupKeyTerm, String aggBufferTerm) {
        scala.Tuple2<int[], int[]> tuple2 = groupingAndAuxGrouping;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int[] grouping = (int[])tuple2._1();
        int[] auxGrouping = (int[])tuple2._2();
        scala.Tuple2 tuple22 = new scala.Tuple2((Object)grouping, (Object)auxGrouping);
        scala.Tuple2 tuple23 = tuple22;
        int[] grouping2 = (int[])tuple23._1();
        int[] auxGrouping2 = (int[])tuple23._2();
        scala.Tuple2<Object, LogicalType>[][] argsMapping = AggCodeGenHelper$.MODULE$.buildAggregateArgsMapping(isMerge, grouping2.length, inputType, auxGrouping2, aggInfos, aggBufferTypes);
        scala.Tuple2<Object, LogicalType>[][] aggBuffMapping = this.buildAggregateAggBuffMapping(aggBufferTypes);
        GeneratedExpression initedAggBuffer = this.genReusableEmptyAggBuffer(ctx, builder, inputTerm, inputType, auxGrouping2, aggInfos, aggBufferRowType);
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping2)).isEmpty()) {
            ctx.addReusableOpenStatement(initedAggBuffer.code());
        }
        GeneratedExpression aggregate = this.genAggregate(isMerge, ctx, builder, inputType, inputTerm, auxGrouping2, aggInfos, argsMapping, aggBuffMapping, currentAggBufferTerm, aggBufferRowType);
        GeneratedExpression outputExpr = this.genHashAggOutputExpr(isMerge, isFinal, ctx, builder, auxGrouping2, aggInfos, argsMapping, aggBuffMapping, outputTerm, outputType, inputTerm, inputType, (Option<String>)new Some((Object)groupKeyTerm), aggBufferTerm, aggBufferRowType);
        return new Tuple3((Object)initedAggBuffer, (Object)aggregate, (Object)outputExpr);
    }

    public scala.Tuple2<Object, LogicalType>[][] buildAggregateAggBuffMapping(LogicalType[][] aggBufferTypes) {
        IntRef aggBuffOffset = IntRef.create((int)0);
        IndexedSeq mapping = (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes)).indices().map((Function1 & Serializable & scala.Serializable)aggIndex -> HashAggCodeGenHelper$.$anonfun$buildAggregateAggBuffMapping$1(aggBufferTypes, aggBuffOffset, BoxesRunTime.unboxToInt((Object)aggIndex)), IndexedSeq$.MODULE$.canBuildFrom());
        return (scala.Tuple2[][])mapping.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(scala.Tuple2.class)));
    }

    public GeneratedExpression genReusableEmptyAggBuffer(CodeGeneratorContext ctx, RelBuilder builder, String inputTerm, RowType inputType, int[] auxGrouping, Seq<AggregateInfo> aggInfos, RowType aggBufferType) {
        ExprCodeGenerator exprCodeGen = new ExprCodeGenerator(ctx, false).bindInput((LogicalType)inputType, inputTerm, (Option<int[]>)new Some((Object)auxGrouping));
        ExpressionConverter converter = new ExpressionConverter(builder);
        GeneratedExpression[] initAuxGroupingExprs = (GeneratedExpression[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).map((Function1 & Serializable & scala.Serializable)idx -> GenerateUtils$.MODULE$.generateFieldAccess(ctx, (LogicalType)inputType, inputTerm, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        Seq initAggCallBufferExprs = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)aggInfos.map((Function1 & Serializable & scala.Serializable)x$2 -> (DeclarativeAggregateFunction)x$2.function(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.initialValuesExpressions())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> (RexNode)x$4.accept((ExpressionVisitor)converter), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rex -> exprCodeGen.generateExpression((RexNode)rex), Seq$.MODULE$.canBuildFrom());
        GeneratedExpression[] initAggBufferExprs = (GeneratedExpression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initAuxGroupingExprs)).$plus$plus((GenTraversableOnce)initAggCallBufferExprs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        String emptyAggBufferTerm = CodeGenUtils$.MODULE$.newName("emptyAggBuffer");
        String emptyAggBufferWriterTerm = CodeGenUtils$.MODULE$.newName("emptyAggBufferWriterTerm");
        return exprCodeGen.generateResultExpression((Seq<GeneratedExpression>)Predef$.MODULE$.wrapRefArray((Object[])initAggBufferExprs), aggBufferType, BinaryRowData.class, emptyAggBufferTerm, (Option<String>)new Some((Object)emptyAggBufferWriterTerm), exprCodeGen.generateResultExpression$default$6(), exprCodeGen.generateResultExpression$default$7());
    }

    public GeneratedExpression genAggregate(boolean isMerge, CodeGeneratorContext ctx, RelBuilder builder, RowType inputType, String inputTerm, int[] auxGrouping, Seq<AggregateInfo> aggInfos, scala.Tuple2<Object, LogicalType>[][] argsMapping, scala.Tuple2<Object, LogicalType>[][] aggBuffMapping, String currentAggBufferTerm, RowType aggBufferRowType) {
        return isMerge ? this.genMergeAggBuffer(ctx, builder, inputTerm, inputType, currentAggBufferTerm, auxGrouping, aggInfos, argsMapping, aggBuffMapping, aggBufferRowType) : this.genAccumulateAggBuffer(ctx, builder, inputTerm, inputType, currentAggBufferTerm, auxGrouping, aggInfos, argsMapping, aggBuffMapping, aggBufferRowType);
    }

    public GeneratedExpression genHashAggOutputExpr(boolean isMerge, boolean isFinal, CodeGeneratorContext ctx, RelBuilder builder, int[] auxGrouping, Seq<AggregateInfo> aggInfos, scala.Tuple2<Object, LogicalType>[][] argsMapping, scala.Tuple2<Object, LogicalType>[][] aggBuffMapping, String outputTerm, RowType outputType, String inputTerm, RowType inputType, Option<String> groupKeyTerm, String aggBufferTerm, RowType aggBufferType) {
        GeneratedExpression generatedExpression;
        GeneratedExpression generatedExpression2;
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        RowType x$19 = inputType;
        String x$20 = inputTerm;
        Option<int[]> x$21 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput((LogicalType)x$19, x$20, x$21);
        RowType x$22 = aggBufferType;
        String x$23 = aggBufferTerm;
        Option<int[]> x$24 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprCodeGen = qual$2.bindSecondInput((LogicalType)x$22, x$23, x$24);
        ExpressionConverter converter = new ExpressionConverter(builder);
        if (isFinal) {
            int bindRefOffset = inputType.getFieldCount();
            IndexedSeq getAuxGroupingExprs = (IndexedSeq)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).indices().map((Function1 & Serializable & scala.Serializable)idx -> HashAggCodeGenHelper$.$anonfun$genHashAggOutputExpr$1(builder, aggBuffMapping, bindRefOffset, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom());
            Seq getAggValueExprs = (Seq)aggInfos.map((Function1 & Serializable & scala.Serializable)aggInfo -> {
                int aggBufferIdx = auxGrouping.length + aggInfo.aggIndex();
                DeclarativeAggregateFunction function = (DeclarativeAggregateFunction)aggInfo.function();
                HashAggCodeGenHelper.ResolveReference ref = new HashAggCodeGenHelper.ResolveReference(ctx, builder, isMerge, bindRefOffset, function, aggBufferIdx, argsMapping, aggBuffMapping);
                return (ResolvedExpression)function.getValueExpression().accept((ExpressionVisitor)ref);
            }, Seq$.MODULE$.canBuildFrom());
            IndexedSeq getValueExprs = (IndexedSeq)((TraversableLike)((TraversableLike)getAuxGroupingExprs.$plus$plus((GenTraversableOnce)getAggValueExprs, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> (RexNode)x$5.accept((ExpressionVisitor)converter), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rex -> exprCodeGen.generateExpression((RexNode)rex), IndexedSeq$.MODULE$.canBuildFrom());
            String aggValueTerm = CodeGenUtils$.MODULE$.newName("aggVal");
            RowType valueType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)getValueExprs.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.resultType(), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))));
            generatedExpression2 = exprCodeGen.generateResultExpression((Seq<GeneratedExpression>)getValueExprs, valueType, GenericRowData.class, aggValueTerm, exprCodeGen.generateResultExpression$default$5(), exprCodeGen.generateResultExpression$default$6(), exprCodeGen.generateResultExpression$default$7());
        } else {
            generatedExpression2 = new GeneratedExpression(aggBufferTerm, "false", "", (LogicalType)aggBufferType, GeneratedExpression$.MODULE$.$lessinit$greater$default$5());
        }
        GeneratedExpression resultExpr = generatedExpression2;
        Option<String> option = groupKeyTerm;
        if (option instanceof Some) {
            Some some = (Some)option;
            String key = (String)some.value();
            String output = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(53).append("\n             |").append(resultExpr.code()).append("\n             |").append(outputTerm).append(".replace(").append(key).append(", ").append(resultExpr.resultTerm()).append(");\n         ").toString())).stripMargin();
            generatedExpression = new GeneratedExpression(outputTerm, "false", output, (LogicalType)outputType, GeneratedExpression$.MODULE$.$lessinit$greater$default$5());
        } else {
            generatedExpression = resultExpr;
        }
        return generatedExpression;
    }

    public GeneratedExpression genMergeAggBuffer(CodeGeneratorContext ctx, RelBuilder builder, String inputTerm, RowType inputType, String currentAggBufferTerm, int[] auxGrouping, Seq<AggregateInfo> aggInfos, scala.Tuple2<Object, LogicalType>[][] argsMapping, scala.Tuple2<Object, LogicalType>[][] aggBuffMapping, RowType aggBufferType) {
        ExprCodeGenerator qual$3 = new ExprCodeGenerator(ctx, false);
        RowType x$25 = inputType;
        String x$26 = inputTerm;
        Option<int[]> x$27 = qual$3.bindInput$default$3();
        ExprCodeGenerator qual$4 = qual$3.bindInput((LogicalType)x$25, x$26, x$27);
        RowType x$28 = aggBufferType;
        String x$29 = currentAggBufferTerm;
        Option<int[]> x$30 = qual$4.bindSecondInput$default$3();
        ExprCodeGenerator exprCodeGen = qual$4.bindSecondInput((LogicalType)x$28, x$29, x$30);
        ExpressionConverter converter = new ExpressionConverter(builder);
        Seq mergeExprs = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((IterableLike)aggInfos.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.function(), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> new ArrayOps.ofRef(HashAggCodeGenHelper$.$anonfun$genMergeAggBuffer$2(ctx, builder, inputType, auxGrouping, argsMapping, aggBuffMapping, x0$1)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$12 -> (RexNode)x$12.accept((ExpressionVisitor)converter), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rex -> exprCodeGen.generateExpression((RexNode)rex), Seq$.MODULE$.canBuildFrom());
        RowType aggBufferTypeWithoutAuxGrouping = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).nonEmpty() ? RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggBufferType.getChildren()).slice(auxGrouping.length, aggBufferType.getFieldCount())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))), (String[])((String[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggBufferType.getFieldNames()).slice(auxGrouping.length, aggBufferType.getFieldCount())).toArray(ClassTag$.MODULE$.apply(String.class)))) : aggBufferType;
        Map mergeExprIdxToOutputRowPosMap = ((TraversableOnce)mergeExprs.indices().map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)i) + auxGrouping.length))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return exprCodeGen.generateResultExpression((Seq<GeneratedExpression>)mergeExprs, (Map<Object, Object>)mergeExprIdxToOutputRowPosMap, aggBufferTypeWithoutAuxGrouping, BinaryRowData.class, currentAggBufferTerm, (Option<String>)None$.MODULE$, true, true);
    }

    public GeneratedExpression genAccumulateAggBuffer(CodeGeneratorContext ctx, RelBuilder builder, String inputTerm, RowType inputType, String currentAggBufferTerm, int[] auxGrouping, Seq<AggregateInfo> aggInfos, scala.Tuple2<Object, LogicalType>[][] argsMapping, scala.Tuple2<Object, LogicalType>[][] aggBuffMapping, RowType aggBufferType) {
        ExprCodeGenerator qual$5 = new ExprCodeGenerator(ctx, false);
        RowType x$31 = inputType;
        String x$32 = inputTerm;
        Option<int[]> x$33 = qual$5.bindInput$default$3();
        ExprCodeGenerator qual$6 = qual$5.bindInput((LogicalType)x$31, x$32, x$33);
        RowType x$34 = aggBufferType;
        String x$35 = currentAggBufferTerm;
        Option<int[]> x$36 = qual$6.bindSecondInput$default$3();
        ExprCodeGenerator exprCodeGen = qual$6.bindSecondInput((LogicalType)x$34, x$35, x$36);
        ExpressionConverter converter = new ExpressionConverter(builder);
        int bindRefOffset = inputType.getFieldCount();
        Seq accumulateExprsWithFilterArgs = (Seq)aggInfos.flatMap((Function1 & Serializable & scala.Serializable)aggInfo -> new ArrayOps.ofRef(HashAggCodeGenHelper$.$anonfun$genAccumulateAggBuffer$1(ctx, builder, auxGrouping, argsMapping, aggBuffMapping, exprCodeGen, converter, bindRefOffset, aggInfo)), Seq$.MODULE$.canBuildFrom());
        String code = ((TraversableOnce)((TraversableLike)accumulateExprsWithFilterArgs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            String string;
            scala.Tuple2 tuple2 = x0$2;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            scala.Tuple2 tuple22 = (scala.Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            GeneratedExpression accumulateExpr = (GeneratedExpression)tuple22._1();
            int filterArg = tuple22._2$mcI$sp();
            int idx = auxGrouping.length + index;
            LogicalType t = aggBufferType.getTypeAt(idx);
            String writeCode = CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, currentAggBufferTerm, t, accumulateExpr.resultTerm());
            String innerCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(141).append("\n               |").append(accumulateExpr.code()).append("\n               |if (").append(accumulateExpr.nullTerm()).append(") {\n               |  ").append(CodeGenUtils$.MODULE$.binaryRowSetNull(idx, currentAggBufferTerm, t)).append(";\n               |} else {\n               |  ").append(writeCode).append(";\n               |}\n               |").toString())).stripMargin().trim();
            if (filterArg >= 0) {
                String filterTerm = new StringBuilder(13).append(inputTerm).append(".getBoolean(").append(filterArg).append(")").toString();
                if (ctx.nullCheck()) {
                    filterTerm = new StringBuilder(16).append("!").append(inputTerm).append(".isNullAt(").append(filterArg).append(") && ").append(filterTerm).toString();
                }
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("\n               |if (").append(filterTerm).append(") {\n               | ").append(innerCode).append("\n               |}\n          ").toString())).stripMargin();
                return string;
            } else {
                string = innerCode;
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        return new GeneratedExpression(currentAggBufferTerm, "false", code, (LogicalType)aggBufferType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public String genAggMapIterationAndOutput(CodeGeneratorContext ctx, boolean isFinal, String aggregateMapTerm, String reuseGroupKeyTerm, String reuseAggBufferTerm, GeneratedExpression outputExpr) {
        String inputUnboxingCode = isFinal ? String.valueOf(ctx.reuseInputUnboxingCode(reuseAggBufferTerm)) : "";
        String iteratorTerm = CodeGenUtils$.MODULE$.newName("iterator");
        String iteratorType = KeyValueIterator.class.getCanonicalName();
        String rowDataType = RowData.class.getCanonicalName();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(267).append("\n       |").append(iteratorType).append("<").append(rowDataType).append(", ").append(rowDataType).append("> ").append(iteratorTerm).append(" =\n       |  ").append(aggregateMapTerm).append(".getEntryIterator(false); // reuse key/value during iterating\n       |while (").append(iteratorTerm).append(".advanceNext()) {\n       |   // set result and output\n       |   ").append(reuseGroupKeyTerm).append(" = (").append(rowDataType).append(")").append(iteratorTerm).append(".getKey();\n       |   ").append(reuseAggBufferTerm).append(" = (").append(rowDataType).append(")").append(iteratorTerm).append(".getValue();\n       |   ").append(inputUnboxingCode).append("\n       |   ").append(outputExpr.code()).append("\n       |   ").append(OperatorCodeGenerator$.MODULE$.generateCollect(outputExpr.resultTerm())).append("\n       |}\n       ").toString())).stripMargin();
    }

    public String genRetryAppendToMap(String aggregateMapTerm, String currentKeyTerm, GeneratedExpression initedAggBuffer, String lookupInfo, String currentAggBufferTerm) {
        String lookupInfoTypeTerm = BytesMap.LookupInfo.class.getCanonicalName();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(270).append("\n       | // reset aggregate map retry append\n       |").append(aggregateMapTerm).append(".reset();\n       |").append(lookupInfo).append(" = (").append(lookupInfoTypeTerm).append(") ").append(aggregateMapTerm).append(".lookup(").append(currentKeyTerm).append(");\n       |try {\n       |  ").append(currentAggBufferTerm).append(" =\n       |    ").append(aggregateMapTerm).append(".append(").append(lookupInfo).append(", ").append(initedAggBuffer.resultTerm()).append(");\n       |} catch (java.io.EOFException e) {\n       |  throw new OutOfMemoryError(\"BytesHashMap Out of Memory.\");\n       |}\n       ").toString())).stripMargin();
    }

    public scala.Tuple2<String, String> genAggMapOOMHandling(boolean isFinal, CodeGeneratorContext ctx, RelBuilder builder, scala.Tuple2<int[], int[]> groupingAndAuxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, String logTerm, String aggregateMapTerm, scala.Tuple2<String, String> aggMapKVTypesTerm, scala.Tuple2<RowType, RowType> aggMapKVRowType, String[][] aggBufferNames, LogicalType[][] aggBufferTypes, String outputTerm, RowType outputType, String outputResultFromMap, String sorterTerm, String retryAppend) {
        scala.Tuple2 tuple2;
        scala.Tuple2<int[], int[]> tuple22 = groupingAndAuxGrouping;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int[] grouping = (int[])tuple22._1();
        int[] auxGrouping = (int[])tuple22._2();
        scala.Tuple2 tuple23 = new scala.Tuple2((Object)grouping, (Object)auxGrouping);
        scala.Tuple2 tuple24 = tuple23;
        int[] grouping2 = (int[])tuple24._1();
        int[] auxGrouping2 = (int[])tuple24._2();
        if (isFinal) {
            String logMapSpilling = CodeGenUtils$.MODULE$.genLogInfo(logTerm, "BytesHashMap out of memory with {} entries, start spilling.", new StringBuilder(17).append(aggregateMapTerm).append(".getNumElements()").toString());
            scala.Tuple2<String, String> tuple25 = aggMapKVTypesTerm;
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            String groupKeyTypesTerm = (String)tuple25._1();
            String aggBufferTypesTerm = (String)tuple25._2();
            scala.Tuple2 tuple26 = new scala.Tuple2((Object)groupKeyTypesTerm, (Object)aggBufferTypesTerm);
            scala.Tuple2 tuple27 = tuple26;
            String groupKeyTypesTerm2 = (String)tuple27._1();
            String aggBufferTypesTerm2 = (String)tuple27._2();
            scala.Tuple2<RowType, RowType> tuple28 = aggMapKVRowType;
            if (tuple28 == null) {
                throw new MatchError(tuple28);
            }
            RowType groupKeyRowType = (RowType)tuple28._1();
            RowType aggBufferRowType = (RowType)tuple28._2();
            scala.Tuple2 tuple29 = new scala.Tuple2((Object)groupKeyRowType, (Object)aggBufferRowType);
            scala.Tuple2 tuple210 = tuple29;
            RowType groupKeyRowType2 = (RowType)tuple210._1();
            RowType aggBufferRowType2 = (RowType)tuple210._2();
            this.prepareFallbackSorter(ctx, sorterTerm);
            String createSorter = this.genCreateFallbackSorter(ctx, groupKeyRowType2, groupKeyTypesTerm2, aggBufferTypesTerm2, sorterTerm);
            String fallbackToSortAggCode = this.genFallbackToSortAgg(ctx, builder, grouping2, auxGrouping2, aggInfos, functionIdentifiers, aggregateMapTerm, (scala.Tuple2<RowType, RowType>)new scala.Tuple2((Object)groupKeyRowType2, (Object)aggBufferRowType2), aggregateMapTerm, sorterTerm, outputTerm, outputType, aggBufferNames, aggBufferTypes);
            String memPoolTypeTerm = BytesHashMapSpillMemorySegmentPool.class.getName();
            String dealWithAggHashMapOOM = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n           |").append(logMapSpilling).append("\n           | // hash map out of memory, spill to external sorter\n           |if (").append(sorterTerm).append(" == null) {\n           |  ").append(createSorter).append("\n           |}\n           | // sort and spill\n           |").append(sorterTerm).append(".sortAndSpill(\n           |  ").append(aggregateMapTerm).append(".getRecordAreaMemorySegments(),\n           |  ").append(aggregateMapTerm).append(".getNumElements(),\n           |  new ").append(memPoolTypeTerm).append("(").append(aggregateMapTerm).append(".getBucketAreaMemorySegments()));\n           | // retry append\n           |").append(retryAppend).append("\n       ").toString())).stripMargin();
            tuple2 = new scala.Tuple2((Object)dealWithAggHashMapOOM, (Object)fallbackToSortAggCode);
        } else {
            String logMapOutput = CodeGenUtils$.MODULE$.genLogInfo(logTerm, "BytesHashMap out of memory with {} entries, output directly.", new StringBuilder(17).append(aggregateMapTerm).append(".getNumElements()").toString());
            String dealWithAggHashMapOOM = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n           |").append(logMapOutput).append("\n           | // hash map out of memory, output directly\n           |").append(outputResultFromMap).append("\n           | // retry append\n           |").append(retryAppend).append("\n          ").toString())).stripMargin();
            tuple2 = new scala.Tuple2((Object)dealWithAggHashMapOOM, (Object)"");
        }
        return tuple2;
    }

    public void prepareFallbackSorter(CodeGeneratorContext ctx, String sorterTerm) {
        String sorterTypeTerm = BufferedKVExternalSorter.class.getName();
        ctx.addReusableMember(new StringBuilder(12).append("transient ").append(sorterTypeTerm).append(" ").append(sorterTerm).append(";").toString());
        ctx.addReusableCloseStatement(new StringBuilder(23).append("if (").append(sorterTerm).append(" != null) ").append(sorterTerm).append(".close();").toString());
    }

    public void prepareMetrics(CodeGeneratorContext ctx, String hashTerm, String sorterTerm) {
        block0: {
            String gauge = Gauge.class.getCanonicalName();
            String longType = Long.class.getCanonicalName();
            String numSpillFiles = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(191).append("\n         |getMetricGroup().gauge(\"numSpillFiles\", new ").append(gauge).append("<").append(longType).append(">() {\n         | @Override\n         | public ").append(longType).append(" getValue() {\n         |  return ").append(hashTerm).append(".getNumSpillFiles();\n         |  }\n         | });\n       ").toString())).stripMargin().trim();
            String memoryUsedSizeInBytes = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n         |getMetricGroup().gauge(\"memoryUsedSizeInBytes\", new ").append(gauge).append("<").append(longType).append(">() {\n         | @Override\n         | public ").append(longType).append(" getValue() {\n         |  return ").append(hashTerm).append(".getUsedMemoryInBytes();\n         |  }\n         | });\n       ").toString())).stripMargin().trim();
            ctx.addReusableOpenStatement(numSpillFiles);
            ctx.addReusableOpenStatement(memoryUsedSizeInBytes);
            if (sorterTerm == null) break block0;
            String spillInBytes = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(206).append("\n           | getMetricGroup().gauge(\"spillInBytes\", new ").append(gauge).append("<").append(longType).append(">() {\n           |  @Override\n           |  public ").append(longType).append(" getValue() {\n           |    return ").append(hashTerm).append(".getSpillInBytes();\n           |   }\n           |});\n       ").toString())).stripMargin().trim();
            ctx.addReusableOpenStatement(spillInBytes);
        }
    }

    public String genCreateFallbackSorter(CodeGeneratorContext ctx, RowType groupKeyRowType, String groupKeyTypesTerm, String aggBufferTypesTerm, String sorterTerm) {
        String keyComputerTerm = CodeGenUtils$.MODULE$.newName("keyComputer");
        String recordComparatorTerm = CodeGenUtils$.MODULE$.newName("recordComparator");
        String prepareSorterCode = this.genKVSorterPrepareCode(ctx, keyComputerTerm, recordComparatorTerm, groupKeyRowType);
        String binaryRowSerializerTypeTerm = BinaryRowDataSerializer.class.getName();
        String sorterTypeTerm = BufferedKVExternalSorter.class.getName();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(323).append("\n       |  ").append(prepareSorterCode).append("\n       |  ").append(sorterTerm).append(" = new ").append(sorterTypeTerm).append("(\n       |    getContainingTask().getEnvironment().getIOManager(),\n       |    new ").append(binaryRowSerializerTypeTerm).append("(").append(groupKeyTypesTerm).append(".length),\n       |    new ").append(binaryRowSerializerTypeTerm).append("(").append(aggBufferTypesTerm).append(".length),\n       |    ").append(keyComputerTerm).append(", ").append(recordComparatorTerm).append(",\n       |    getContainingTask().getEnvironment().getMemoryManager().getPageSize(),\n       |    getContainingTask().getJobConfiguration()\n       |  );\n       ").toString())).stripMargin();
    }

    public String genFallbackToSortAgg(CodeGeneratorContext ctx, RelBuilder builder, int[] grouping, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, String mapTerm, scala.Tuple2<RowType, RowType> mapKVRowTypes, String aggregateMapTerm, String sorterTerm, String outputTerm, RowType outputType, String[][] aggBufferNames, LogicalType[][] aggBufferTypes) {
        scala.Tuple2<RowType, RowType> tuple2 = mapKVRowTypes;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RowType groupKeyRowType = (RowType)tuple2._1();
        RowType aggBufferRowType = (RowType)tuple2._2();
        scala.Tuple2 tuple22 = new scala.Tuple2((Object)groupKeyRowType, (Object)aggBufferRowType);
        scala.Tuple2 tuple23 = tuple22;
        RowType groupKeyRowType2 = (RowType)tuple23._1();
        RowType aggBufferRowType2 = (RowType)tuple23._2();
        String keyTerm = CodeGenUtils$.MODULE$.newName("key");
        String lastKeyTerm = CodeGenUtils$.MODULE$.newName("lastKey");
        String keyNotEquals = AggCodeGenHelper$.MODULE$.genGroupKeyChangedCheckCode(keyTerm, lastKeyTerm);
        String joinedRow = JoinedRowData.class.getName();
        String fallbackInputTerm = ctx.addReusableLocalVariable(joinedRow, "fallbackInput");
        RowType fallbackInputType = RowType.of((LogicalType[])((LogicalType[])JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(groupKeyRowType2.getChildren()).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggBufferRowType2.getChildren())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))), (String[])((String[])JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(groupKeyRowType2.getFieldNames()).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggBufferRowType2.getFieldNames())).toArray(ClassTag$.MODULE$.apply(String.class))));
        Tuple3<String, String, GeneratedExpression> tuple3 = AggCodeGenHelper$.MODULE$.genSortAggCodes(true, true, ctx, builder, grouping, auxGrouping, aggInfos, functionIdentifiers, fallbackInputTerm, fallbackInputType, aggBufferNames, aggBufferTypes, outputType, true);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String initAggBufferCode = (String)tuple3._1();
        String updateAggBufferCode = (String)tuple3._2();
        GeneratedExpression resultExpr = (GeneratedExpression)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)initAggBufferCode, (Object)updateAggBufferCode, (Object)resultExpr);
        Tuple3 tuple33 = tuple32;
        String initAggBufferCode2 = (String)tuple33._1();
        String updateAggBufferCode2 = (String)tuple33._2();
        GeneratedExpression resultExpr2 = (GeneratedExpression)tuple33._3();
        String kvPairTerm = CodeGenUtils$.MODULE$.newName("kvPair");
        String kvPairTypeTerm = Tuple2.class.getName();
        String aggBuffTerm = CodeGenUtils$.MODULE$.newName("val");
        String binaryRow = BinaryRowData.class.getName();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1102).append("\n       |  ").append(binaryRow).append(" ").append(lastKeyTerm).append(" = null;\n       |  ").append(kvPairTypeTerm).append("<").append(binaryRow).append(", ").append(binaryRow).append("> ").append(kvPairTerm).append(" = null;\n       |  ").append(binaryRow).append(" ").append(keyTerm).append(" = null;\n       |  ").append(binaryRow).append(" ").append(aggBuffTerm).append(" = null;\n       |  ").append(fallbackInputTerm).append(" = new ").append(joinedRow).append("();\n       |\n       |  // free hash map memory, but not release back to memory manager\n       |\n       |  org.apache.flink.util.MutableObjectIterator<").append(kvPairTypeTerm).append("<").append(binaryRow).append(", ").append(binaryRow).append(">>\n       |    iterator = ").append(sorterTerm).append(".getKVIterator();\n       |\n       |  while (\n       |    (").append(kvPairTerm).append(" = (").append(kvPairTypeTerm).append("<").append(binaryRow).append(", ").append(binaryRow).append(">) iterator.next()) != null) {\n       |    ").append(keyTerm).append(" = (").append(binaryRow).append(") ").append(kvPairTerm).append(".f0;\n       |    ").append(aggBuffTerm).append(" = (").append(binaryRow).append(") ").append(kvPairTerm).append(".f1;\n       |    // prepare input\n       |    ").append(fallbackInputTerm).append(".replace(").append(keyTerm).append(", ").append(aggBuffTerm).append(");\n       |    if (").append(lastKeyTerm).append(" == null) {\n       |      // found first key group\n       |      ").append(lastKeyTerm).append(" = ").append(keyTerm).append(".copy();\n       |      ").append(initAggBufferCode2).append("\n       |    } else if (").append(keyNotEquals).append(") {\n       |      // output current group aggregate result\n       |      ").append(resultExpr2.code()).append("\n       |      ").append(outputTerm).append(".replace(").append(lastKeyTerm).append(", ").append(resultExpr2.resultTerm()).append(");\n       |      ").append(OperatorCodeGenerator$.MODULE$.generateCollect(outputTerm)).append("\n       |      // found new group\n       |      ").append(lastKeyTerm).append(" = ").append(keyTerm).append(".copy();\n       |      ").append(initAggBufferCode2).append("\n       |    }\n       |    // reusable field access codes for agg buffer merge\n       |    ").append(ctx.reuseInputUnboxingCode(fallbackInputTerm)).append("\n       |    // merge aggregate map's value into aggregate buffer fields\n       |    ").append(updateAggBufferCode2).append("\n       |  }\n       |\n       |  // output last key group aggregate result\n       |  ").append(resultExpr2.code()).append("\n       |  ").append(outputTerm).append(".replace(").append(lastKeyTerm).append(", ").append(resultExpr2.resultTerm()).append(");\n       |  ").append(OperatorCodeGenerator$.MODULE$.generateCollect(outputTerm)).append("\n       ").toString())).stripMargin();
    }

    public String genKVSorterPrepareCode(CodeGeneratorContext ctx, String keyComputerTerm, String recordComparatorTerm, RowType aggMapKeyType) {
        SortCodeGenerator sortCodeGenerator = new SortCodeGenerator(ctx.tableConfig(), aggMapKeyType, SortUtil$.MODULE$.getAscendingSortSpec(Array$.MODULE$.range(0, aggMapKeyType.getFieldCount())));
        GeneratedNormalizedKeyComputer computer = sortCodeGenerator.generateNormalizedKeyComputer("AggMapKeyComputer");
        GeneratedRecordComparator comparator = sortCodeGenerator.generateRecordComparator("AggMapValueComparator");
        String keyComputerTypeTerm = NormalizedKeyComputer.class.getName();
        String keyComputeInnerClassTerm = computer.getClassName();
        String recordComparatorTypeTerm = RecordComparator.class.getName();
        String recordComparatorInnerClassTerm = comparator.getClassName();
        ctx.addReusableInnerClass(keyComputeInnerClassTerm, computer.getCode());
        ctx.addReusableInnerClass(recordComparatorInnerClassTerm, comparator.getCode());
        String computerRefs = ctx.addReusableObject(computer.getReferences(), "computerRefs", ctx.addReusableObject$default$3());
        String comparatorRefs = ctx.addReusableObject(comparator.getReferences(), "comparatorRefs", ctx.addReusableObject$default$3());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n       |  ").append(keyComputerTypeTerm).append(" ").append(keyComputerTerm).append(" = new ").append(keyComputeInnerClassTerm).append("(").append(computerRefs).append(");\n       |  ").append(recordComparatorTypeTerm).append(" ").append(recordComparatorTerm).append(" =\n       |    new ").append(recordComparatorInnerClassTerm).append("(").append(comparatorRefs).append(");\n       |").toString())).stripMargin();
    }

    public static final /* synthetic */ scala.Tuple2[] $anonfun$buildAggregateAggBuffMapping$1(LogicalType[][] aggBufferTypes$1, IntRef aggBuffOffset$1, int aggIndex) {
        LogicalType[] types = aggBufferTypes$1[aggIndex];
        int[] indexes = (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(aggBuffOffset$1.elem), aggBuffOffset$1.elem + types.length).toArray(ClassTag$.MODULE$.Int());
        aggBuffOffset$1.elem += types.length;
        return (scala.Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indexes)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])types), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.Tuple2.class)));
    }

    public static final /* synthetic */ ResolvedExpression $anonfun$genHashAggOutputExpr$1(RelBuilder builder$1, scala.Tuple2[][] aggBuffMapping$1, int bindRefOffset$1, int idx) {
        LogicalType resultType;
        scala.Tuple2 tuple2 = aggBuffMapping$1[idx][0];
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalType logicalType = resultType = (LogicalType)tuple2._2();
        LogicalType resultType2 = logicalType;
        return DeclarativeExpressionResolver.toRexInputRef(builder$1, bindRefOffset$1 + idx, resultType2);
    }

    public static final /* synthetic */ Object[] $anonfun$genMergeAggBuffer$2(CodeGeneratorContext ctx$3, RelBuilder builder$2, RowType inputType$2, int[] auxGrouping$2, scala.Tuple2[][] argsMapping$2, scala.Tuple2[][] aggBuffMapping$2, scala.Tuple2 x0$1) {
        int aggIndex;
        UserDefinedFunction agg;
        block3: {
            scala.Tuple2 tuple2;
            block2: {
                tuple2 = x0$1;
                if (tuple2 == null) break block2;
                agg = (UserDefinedFunction)tuple2._1();
                aggIndex = tuple2._2$mcI$sp();
                if (agg instanceof DeclarativeAggregateFunction) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)agg;
        int aggBufferIdx = auxGrouping$2.length + aggIndex;
        int bindRefOffset = inputType$2.getFieldCount();
        HashAggCodeGenHelper.ResolveReference ref = new HashAggCodeGenHelper.ResolveReference(ctx$3, builder$2, true, bindRefOffset, declarativeAggregateFunction, aggBufferIdx, argsMapping$2, aggBuffMapping$2);
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.mergeExpressions())).map((Function1 & Serializable & scala.Serializable)x$11 -> (ResolvedExpression)x$11.accept((ExpressionVisitor)ref), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedExpression.class))));
        return objectArray;
    }

    public static final /* synthetic */ Object[] $anonfun$genAccumulateAggBuffer$1(CodeGeneratorContext ctx$4, RelBuilder builder$3, int[] auxGrouping$3, scala.Tuple2[][] argsMapping$3, scala.Tuple2[][] aggBuffMapping$3, ExprCodeGenerator exprCodeGen$4, ExpressionConverter converter$4, int bindRefOffset$2, AggregateInfo aggInfo) {
        int aggBufferIdx = auxGrouping$3.length + aggInfo.aggIndex();
        DeclarativeAggregateFunction function = (DeclarativeAggregateFunction)aggInfo.function();
        HashAggCodeGenHelper.ResolveReference ref = new HashAggCodeGenHelper.ResolveReference(ctx$4, builder$3, false, bindRefOffset$2, function, aggBufferIdx, argsMapping$3, aggBuffMapping$3);
        return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])function.accumulateExpressions())).map((Function1 & Serializable & scala.Serializable)x$13 -> (ResolvedExpression)x$13.accept((ExpressionVisitor)ref), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedExpression.class))))).map((Function1 & Serializable & scala.Serializable)e -> new scala.Tuple2((Object)exprCodeGen$4.generateExpression((RexNode)e.accept((ExpressionVisitor)converter$4)), (Object)BoxesRunTime.boxToInteger((int)aggInfo$1.agg().filterArg)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.Tuple2.class))));
    }

    private HashAggCodeGenHelper$() {
        MODULE$ = this;
    }
}

