/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecSink;

@Internal
public class ExecNodeGraphInternalPlan
implements InternalPlan {
    private final String serializedPlan;
    private final ExecNodeGraph execNodeGraph;

    public ExecNodeGraphInternalPlan(String serializedPlan, ExecNodeGraph execNodeGraph) {
        this.serializedPlan = serializedPlan;
        this.execNodeGraph = execNodeGraph;
    }

    public ExecNodeGraph getExecNodeGraph() {
        return this.execNodeGraph;
    }

    public String asJsonString() {
        return this.serializedPlan;
    }

    public void writeToFile(File file, boolean ignoreIfExists, boolean failIfExists) {
        if (file.exists()) {
            if (ignoreIfExists) {
                return;
            }
            if (failIfExists) {
                throw new TableException(String.format("Cannot overwrite the plan file '%s'. Either manually remove the file or, if you're debugging your job, set the option '%s' to true.", file, TableConfigOptions.PLAN_FORCE_RECOMPILE.key()));
            }
        }
        try {
            Files.write(file.toPath(), this.serializedPlan.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new TableException("Cannot write the compiled plan to file '" + file + "'.", (Throwable)e);
        }
    }

    public FlinkVersion getFlinkVersion() {
        return this.execNodeGraph.getFlinkVersion();
    }

    public List<String> getSinkIdentifiers() {
        return this.execNodeGraph.getRootNodes().stream().filter(execNode -> execNode instanceof StreamExecSink).map(execNode -> ((StreamExecSink)execNode).getTableSinkSpec().getContextResolvedTable().getIdentifier()).map(ObjectIdentifier::asSummaryString).collect(Collectors.toList());
    }
}

