/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.fun.SqlLeadLagAggFunction;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.InputSortedExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public abstract class BatchExecOverAggregateBase
extends ExecNodeBase<RowData>
implements InputSortedExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    protected final OverSpec overSpec;

    public BatchExecOverAggregateBase(int id, ExecNodeContext context, ReadableConfig persistedConfig, OverSpec overSpec, InputProperty inputProperty, RowType outputType, String description) {
        super(id, context, persistedConfig, Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.overSpec = overSpec;
    }

    protected RowType getInputTypeWithConstants() {
        RowType inputRowType = (RowType)this.getInputEdges().get(0).getOutputType();
        ArrayList<LogicalType> inputTypesWithConstants = new ArrayList<LogicalType>(inputRowType.getChildren());
        ArrayList<String> inputTypeNamesWithConstants = new ArrayList<String>(inputRowType.getFieldNames());
        for (int i = 0; i < this.overSpec.getConstants().size(); ++i) {
            inputTypesWithConstants.add(FlinkTypeFactory.toLogicalType(this.overSpec.getConstants().get(i).getType()));
            inputTypeNamesWithConstants.add("TMP" + i);
        }
        return RowType.of((LogicalType[])inputTypesWithConstants.toArray(new LogicalType[0]), (String[])inputTypeNamesWithConstants.toArray(new String[0]));
    }

    protected boolean isUnboundedWindow(OverSpec.GroupSpec group) {
        return group.getLowerBound().isUnbounded() && group.getUpperBound().isUnbounded();
    }

    protected boolean isUnboundedPrecedingWindow(OverSpec.GroupSpec group) {
        return group.getLowerBound().isUnbounded() && !group.getUpperBound().isUnbounded();
    }

    protected boolean isUnboundedFollowingWindow(OverSpec.GroupSpec group) {
        return !group.getLowerBound().isUnbounded() && group.getUpperBound().isUnbounded();
    }

    protected boolean isSlidingWindow(OverSpec.GroupSpec group) {
        return !group.getLowerBound().isUnbounded() && !group.getUpperBound().isUnbounded();
    }

    protected List<RexLiteral> getConstants() {
        return this.overSpec.getConstants();
    }

    protected OverWindowMode inferGroupMode(OverSpec.GroupSpec group) {
        AggregateCall aggCall = group.getAggCalls().get(0);
        if (aggCall.getAggregation().allowsFraming()) {
            if (group.isRows()) {
                return OverWindowMode.ROW;
            }
            return OverWindowMode.RANGE;
        }
        if (aggCall.getAggregation() instanceof SqlLeadLagAggFunction) {
            return OverWindowMode.OFFSET;
        }
        return OverWindowMode.INSENSITIVE;
    }

    public static enum OverWindowMode {
        ROW,
        RANGE,
        OFFSET,
        INSENSITIVE;

    }
}

