/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TemporalTableSourceSpec {
    public static final String FIELD_NAME_LOOK_UP_TABLE_SOURCE = "lookupTableSource";
    public static final String FIELD_NAME_OUTPUT_TYPE = "outputType";
    @JsonProperty(value="lookupTableSource")
    private DynamicTableSourceSpec tableSourceSpec;
    @JsonProperty(value="outputType")
    @Nullable
    private RelDataType outputType;
    @JsonIgnore
    private RelOptTable temporalTable;

    public TemporalTableSourceSpec(RelOptTable temporalTable) {
        this.temporalTable = temporalTable;
        if (temporalTable instanceof TableSourceTable) {
            TableSourceTable tableSourceTable = (TableSourceTable)temporalTable;
            this.outputType = tableSourceTable.getRowType();
            this.tableSourceSpec = new DynamicTableSourceSpec(tableSourceTable.contextResolvedTable(), Arrays.asList(tableSourceTable.abilitySpecs()));
        }
    }

    @JsonCreator
    public TemporalTableSourceSpec(@JsonProperty(value="lookupTableSource") @Nullable DynamicTableSourceSpec dynamicTableSourceSpec, @JsonProperty(value="outputType") @Nullable RelDataType outputType) {
        this.tableSourceSpec = dynamicTableSourceSpec;
        this.outputType = outputType;
    }

    @JsonIgnore
    public RelOptTable getTemporalTable(FlinkContext flinkContext) {
        if (null != this.temporalTable) {
            return this.temporalTable;
        }
        if (null != this.tableSourceSpec && null != this.outputType) {
            LookupTableSource lookupTableSource = this.tableSourceSpec.getLookupTableSource(flinkContext);
            SourceAbilitySpec[] sourceAbilitySpecs = null;
            if (null != this.tableSourceSpec.getSourceAbilities()) {
                sourceAbilitySpecs = this.tableSourceSpec.getSourceAbilities().toArray(new SourceAbilitySpec[0]);
            }
            return new TableSourceTable(null, this.outputType, FlinkStatistic.UNKNOWN(), (DynamicTableSource)lookupTableSource, true, this.tableSourceSpec.getContextResolvedTable(), flinkContext, sourceAbilitySpecs);
        }
        throw new TableException("Can not obtain temporalTable correctly!");
    }

    @JsonIgnore
    public DynamicTableSourceSpec getTableSourceSpec() {
        return this.tableSourceSpec;
    }

    @JsonIgnore
    @Nullable
    public RelDataType getOutputType() {
        return this.outputType;
    }
}

