/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecSortLimit;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRel;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil$;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001U\u0011aCQ1uG\"\u0004\u0006._:jG\u0006d7k\u001c:u\u0019&l\u0017\u000e\u001e\u0006\u0003\u0007\u0011\tQAY1uG\"T!!\u0002\u0004\u0002\u0011AD\u0017p]5dC2T!a\u0002\u0005\u0002\u000b9|G-Z:\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011c\u0001\u0001\u0017AA\u0011qCH\u0007\u00021)\u0011\u0011DG\u0001\u0005G>\u0014XM\u0003\u0002\u001c9\u0005\u0019!/\u001a7\u000b\u0005u\u0001\u0012aB2bY\u000eLG/Z\u0005\u0003?a\u0011AaU8siB\u0011\u0011EI\u0007\u0002\u0005%\u00111E\u0001\u0002\u0011\u0005\u0006$8\r\u001b)isNL7-\u00197SK2D\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\bG2,8\u000f^3s!\t9\u0013&D\u0001)\u0015\tIA$\u0003\u0002+Q\ti!+\u001a7PaR\u001cE.^:uKJD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\tiJ\f\u0017\u000e^*fiB\u0011qEL\u0005\u0003_!\u00121BU3m)J\f\u0017\u000e^*fi\"A\u0011\u0007\u0001B\u0001B\u0003%!'\u0001\u0005j]B,HOU3m!\t\u0019D'D\u0001\u001b\u0013\t)$DA\u0004SK2tu\u000eZ3\t\u0011]\u0002!\u0011!Q\u0001\na\nQb]8si\u000e{G\u000e\\1uS>t\u0007CA\u001a:\u0013\tQ$D\u0001\u0007SK2\u001cu\u000e\u001c7bi&|g\u000e\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0003\u0019ygMZ:fiB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tH\u0001\u0004e\u0016D\u0018B\u0001\"@\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!P\u0001\u0006M\u0016$8\r\u001b\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\u0006A\u0011n]$m_\n\fG\u000e\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0004C_>dW-\u00198\t\u000b9\u0003A\u0011A(\u0002\rqJg.\u001b;?)!\u0001\u0016KU*U+Z;\u0006CA\u0011\u0001\u0011\u0015)S\n1\u0001'\u0011\u0015aS\n1\u0001.\u0011\u0015\tT\n1\u00013\u0011\u00159T\n1\u00019\u0011\u0015aT\n1\u0001>\u0011\u0015!U\n1\u0001>\u0011\u00151U\n1\u0001H\u0011\u001dI\u0006A1A\u0005\ni\u000b!\u0002\\5nSR\u001cF/\u0019:u+\u0005Y\u0006C\u0001%]\u0013\ti\u0016J\u0001\u0003M_:<\u0007BB0\u0001A\u0003%1,A\u0006mS6LGo\u0015;beR\u0004\u0003bB1\u0001\u0005\u0004%IAW\u0001\tY&l\u0017\u000e^#oI\"11\r\u0001Q\u0001\nm\u000b\u0011\u0002\\5nSR,e\u000e\u001a\u0011\t\u000b\u0015\u0004A\u0011\t4\u0002\t\r|\u0007/\u001f\u000b\u0007-\u001dD'\u000e\\7\t\u000b1\"\u0007\u0019A\u0017\t\u000b%$\u0007\u0019\u0001\u001a\u0002\u00119,w/\u00138qkRDQa\u001b3A\u0002a\nAB\\3x\u0007>dG.\u0019;j_:DQ\u0001\u00103A\u0002uBQ\u0001\u00123A\u0002uBQa\u001c\u0001\u0005BA\fA\"\u001a=qY\u0006Lg\u000eV3s[N$\"!\u001d;\u0011\u0005M\u0012\u0018BA:\u001b\u0005%\u0011V\r\\,sSR,'\u000fC\u0003v]\u0002\u0007\u0011/\u0001\u0002qo\")q\u000f\u0001C!q\u0006\u0001Rm\u001d;j[\u0006$XMU8x\u0007>,h\u000e\u001e\u000b\u0003sr\u0004\"\u0001\u0013>\n\u0005mL%A\u0002#pk\ndW\rC\u0003~m\u0002\u0007a0\u0001\u0002ncB\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u00025\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002\b\u0005\u0005!\u0001\u0005*fY6+G/\u00193bi\u0006\fV/\u001a:z\u0011\u001d\tY\u0001\u0001C!\u0003\u001b\tqbY8naV$XmU3mM\u000e{7\u000f\u001e\u000b\u0007\u0003\u001f\t)\"!\b\u0011\u0007\u001d\n\t\"C\u0002\u0002\u0014!\u0012!BU3m\u001fB$8i\\:u\u0011\u001dY\u0011\u0011\u0002a\u0001\u0003/\u00012aJA\r\u0013\r\tY\u0002\u000b\u0002\u000e%\u0016dw\n\u001d;QY\u0006tg.\u001a:\t\ru\fI\u00011\u0001\u007f\u0011\u001d\t\t\u0003\u0001C!\u0003G\t1\u0003\u001e:b]Nd\u0017\r^3U_\u0016CXm\u0019(pI\u0016$\"!!\n1\t\u0005\u001d\u0012q\u0007\t\u0007\u0003S\ty#a\r\u000e\u0005\u0005-\"bAA\u0017\r\u0005!Q\r_3d\u0013\u0011\t\t$a\u000b\u0003\u0011\u0015CXm\u0019(pI\u0016\u0004B!!\u000e\u000281\u0001A\u0001DA\u001d\u0003?\t\t\u0011!A\u0003\u0002\u0005m\"aA0%cE!\u0011QHA\"!\rA\u0015qH\u0005\u0004\u0003\u0003J%a\u0002(pi\"Lgn\u001a\t\u0004\u0011\u0006\u0015\u0013bAA$\u0013\n\u0019\u0011I\\=")
public class BatchPhysicalSortLimit
extends Sort
implements BatchPhysicalRel {
    private final RelOptCluster cluster;
    private final RelCollation sortCollation;
    private final RexNode fetch;
    private final boolean isGlobal;
    private final long limitStart;
    private final long limitEnd;

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel.satisfyTraits$(this, requiredTraitSet);
    }

    @Override
    public ExecNode<?> translateToExecNode(boolean isCompiled) {
        return FlinkPhysicalRel.translateToExecNode$(this, isCompiled);
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode.getRelDetailedDescription$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionDetail);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, expressionDetail);
    }

    @Override
    public Enumeration.Value convertToExpressionDetail(SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.convertToExpressionDetail$(this, sqlExplainLevel);
    }

    private long limitStart() {
        return this.limitStart;
    }

    private long limitEnd() {
        return this.limitEnd;
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new BatchPhysicalSortLimit(this.cluster, traitSet, newInput, newCollation, offset, fetch, this.isGlobal);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("orderBy", RelExplainUtil$.MODULE$.collationToString(this.sortCollation, this.getRowType())).item("offset", BoxesRunTime.boxToLong((long)this.limitStart())).item("fetch", RelExplainUtil$.MODULE$.fetchToString(this.fetch)).item("global", BoxesRunTime.boxToBoolean((boolean)this.isGlobal));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double d;
        Double inputRows = mq.getRowCount(this.getInput());
        if (inputRows == null) {
            d = Predef$.MODULE$.Double2double(inputRows);
        } else {
            void var3_3;
            double rowCount = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.Double2double(inputRows) - (double)this.limitStart()), 1.0);
            d = this.fetch != null ? RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(rowCount), (double)RexLiteral.intValue(this.fetch)) : var3_3;
        }
        return d;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double inputRowCnt = mq.getRowCount(this.getInput());
        double heapLen = Math.min(Predef$.MODULE$.Double2double(inputRowCnt), (double)this.limitEnd());
        int numOfSort = this.sortCollation.getFieldCollations().size();
        double cpuCost = (double)(FlinkCost$.MODULE$.COMPARE_CPU_COST() * numOfSort) * Predef$.MODULE$.Double2double(inputRowCnt) * Math.log(heapLen);
        double memCost = heapLen * Predef$.MODULE$.Double2double(mq.getAverageRowSize(this));
        Double rowCount = mq.getRowCount(this);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(rowCount), cpuCost, 0.0, 0.0, memCost);
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        return new BatchExecSortLimit(ShortcutUtils.unwrapTableConfig(this), SortUtil$.MODULE$.getSortSpec((Seq<RelFieldCollation>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.sortCollation.getFieldCollations())), this.limitStart(), this.limitEnd(), this.isGlobal, InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).build(), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    public BatchPhysicalSortLimit(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelCollation sortCollation, RexNode offset, RexNode fetch, boolean isGlobal) {
        this.cluster = cluster;
        this.sortCollation = sortCollation;
        this.fetch = fetch;
        this.isGlobal = isGlobal;
        super(cluster, traitSet, inputRel, sortCollation, offset, fetch);
        FlinkRelNode.$init$(this);
        FlinkPhysicalRel.$init$(this);
        this.limitStart = SortUtil$.MODULE$.getLimitStart(offset);
        this.limitEnd = SortUtil$.MODULE$.getLimitEnd(offset, fetch);
    }
}

