/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalPythonGroupWindowAggregate;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public class StreamPhysicalPythonGroupWindowAggregateRule
extends ConverterRule {
    public static final StreamPhysicalPythonGroupWindowAggregateRule INSTANCE = new StreamPhysicalPythonGroupWindowAggregateRule();

    private StreamPhysicalPythonGroupWindowAggregateRule() {
        super(FlinkLogicalWindowAggregate.class, FlinkConventions.LOGICAL(), FlinkConventions.STREAM_PHYSICAL(), "StreamPhysicalPythonGroupWindowAggregateRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalWindowAggregate agg = (FlinkLogicalWindowAggregate)call.rel(0);
        List<AggregateCall> aggCalls = agg.getAggCallList();
        if (agg.getGroupType() != Aggregate.Group.SIMPLE) {
            throw new TableException("GROUPING SETS are currently not supported.");
        }
        agg.getClass();
        boolean existGeneralPythonFunction = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.GENERAL));
        boolean existPandasFunction = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.PANDAS));
        boolean existJavaFunction = aggCalls.stream().anyMatch(x -> !PythonUtil.isPythonAggregate(x, null) && !PythonUtil.isBuiltInAggregate(x));
        if (existPandasFunction && existGeneralPythonFunction) {
            throw new TableException("Pandas UDAFs and General Python UDAFs are not supported in used together currently.");
        }
        if (existPandasFunction || existGeneralPythonFunction) {
            if (existJavaFunction) {
                throw new TableException("Python UDAF and Java/Scala UDAF cannot be used together.");
            }
            return true;
        }
        return false;
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalWindowAggregate agg = (FlinkLogicalWindowAggregate)rel;
        LogicalWindow window = agg.getWindow();
        List<AggregateCall> aggCalls = agg.getAggCallList();
        boolean isPandasPythonUDAF = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.PANDAS));
        if (isPandasPythonUDAF && window instanceof SessionGroupWindow) {
            throw new TableException("Session Group Window is currently not supported for Pandas UDAF.");
        }
        RelNode input = agg.getInput();
        RelOptCluster cluster = rel.getCluster();
        FlinkRelDistribution requiredDistribution = agg.getGroupCount() != 0 ? FlinkRelDistribution.hash(agg.getGroupSet().asList(), true) : FlinkRelDistribution.SINGLETON();
        RelTraitSet requiredTraitSet = input.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL()).replace(requiredDistribution);
        RelTraitSet providedTraitSet = rel.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        RelNode newInput = RelOptRule.convert(input, requiredTraitSet);
        ReadableConfig config = ShortcutUtils.unwrapTableConfig(rel);
        WindowEmitStrategy emitStrategy = WindowEmitStrategy.apply(config, agg.getWindow());
        if (emitStrategy.produceUpdates().booleanValue()) {
            throw new TableException("Python Group Window Aggregate Function is currently not supported for early fired or lately fired.");
        }
        return new StreamPhysicalPythonGroupWindowAggregate(cluster, providedTraitSet, newInput, rel.getRowType(), agg.getGroupSet().toArray(), JavaScalaConversionUtil.toScala(aggCalls), agg.getWindow(), JavaScalaConversionUtil.toScala(agg.getNamedProperties()), emitStrategy);
    }
}

