/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTime;

final class DateTimeInterval {
    private final DateTime fFrom;
    private boolean fIsPlus;
    private DateTime.DayOverflow fDayOverflow;
    private int fYearIncr;
    private int fMonthIncr;
    private int fDayIncr;
    private int fHourIncr;
    private int fMinuteIncr;
    private int fSecondIncr;
    private int fNanosecondIncr;
    private Integer fYear;
    private Integer fMonth;
    private Integer fDay;
    private Integer fHour;
    private Integer fMinute;
    private Integer fSecond;
    private Integer fNanosecond;
    private static final int MIN = 0;
    private static final int MAX = 9999;
    private static final int MIN_NANOS = 0;
    private static final int MAX_NANOS = 999999999;
    private static final boolean PLUS = true;
    private static final boolean MINUS = false;

    DateTimeInterval(DateTime aFrom, DateTime.DayOverflow aMonthOverflow) {
        this.fFrom = aFrom;
        this.checkUnits();
        this.fYear = this.fFrom.getYear() == null ? 1 : this.fFrom.getYear();
        this.fMonth = this.fFrom.getMonth() == null ? 1 : this.fFrom.getMonth();
        this.fDay = this.fFrom.getDay() == null ? 1 : this.fFrom.getDay();
        this.fHour = this.fFrom.getHour() == null ? 0 : this.fFrom.getHour();
        this.fMinute = this.fFrom.getMinute() == null ? 0 : this.fFrom.getMinute();
        this.fSecond = this.fFrom.getSecond() == null ? 0 : this.fFrom.getSecond();
        this.fNanosecond = this.fFrom.getNanoseconds() == null ? 0 : this.fFrom.getNanoseconds();
        this.fDayOverflow = aMonthOverflow;
    }

    DateTime plus(int aYear, int aMonth, int aDay, int aHour, int aMinute, int aSecond, int aNanosecond) {
        return this.plusOrMinus(true, aYear, aMonth, aDay, aHour, aMinute, aSecond, aNanosecond);
    }

    DateTime minus(int aYear, int aMonth, int aDay, int aHour, int aMinute, int aSecond, int aNanosecond) {
        return this.plusOrMinus(false, aYear, aMonth, aDay, aHour, aMinute, aSecond, aNanosecond);
    }

    private void checkUnits() {
        boolean success = false;
        success = this.fFrom.unitsAllPresent(DateTime.Unit.YEAR, DateTime.Unit.MONTH, DateTime.Unit.DAY, DateTime.Unit.HOUR, DateTime.Unit.MINUTE, DateTime.Unit.SECOND) ? true : (this.fFrom.unitsAllPresent(DateTime.Unit.YEAR, DateTime.Unit.MONTH, DateTime.Unit.DAY) && this.fFrom.unitsAllAbsent(DateTime.Unit.HOUR, DateTime.Unit.MINUTE, DateTime.Unit.SECOND) ? true : this.fFrom.unitsAllAbsent(DateTime.Unit.YEAR, DateTime.Unit.MONTH, DateTime.Unit.DAY) && this.fFrom.unitsAllPresent(DateTime.Unit.HOUR, DateTime.Unit.MINUTE, DateTime.Unit.SECOND));
        if (!success) {
            throw new IllegalArgumentException("For interval calculations, DateTime must have year-month-day, or hour-minute-second, or both.");
        }
    }

    private DateTime plusOrMinus(boolean aIsPlus, Integer aYear, Integer aMonth, Integer aDay, Integer aHour, Integer aMinute, Integer aSecond, Integer aNanosecond) {
        this.fIsPlus = aIsPlus;
        this.fYearIncr = aYear;
        this.fMonthIncr = aMonth;
        this.fDayIncr = aDay;
        this.fHourIncr = aHour;
        this.fMinuteIncr = aMinute;
        this.fSecondIncr = aSecond;
        this.fNanosecondIncr = aNanosecond;
        this.checkRange(this.fYearIncr, "Year");
        this.checkRange(this.fMonthIncr, "Month");
        this.checkRange(this.fDayIncr, "Day");
        this.checkRange(this.fHourIncr, "Hour");
        this.checkRange(this.fMinuteIncr, "Minute");
        this.checkRange(this.fSecondIncr, "Second");
        this.checkRangeNanos(this.fNanosecondIncr);
        this.changeYear();
        this.changeMonth();
        this.handleMonthOverflow();
        this.changeDay();
        this.changeHour();
        this.changeMinute();
        this.changeSecond();
        this.changeNanosecond();
        return new DateTime(this.fYear, this.fMonth, this.fDay, this.fHour, this.fMinute, this.fSecond, this.fNanosecond);
    }

    private void checkRange(Integer aValue, String aName) {
        if (aValue < 0 || aValue > 9999) {
            throw new IllegalArgumentException(aName + " is not in the range " + 0 + ".." + 9999);
        }
    }

    private void checkRangeNanos(Integer aValue) {
        if (aValue < 0 || aValue > 999999999) {
            throw new IllegalArgumentException("Nanosecond interval is not in the range 0..999999999");
        }
    }

    private void changeYear() {
        this.fYear = this.fIsPlus ? Integer.valueOf(this.fYear + this.fYearIncr) : Integer.valueOf(this.fFrom.getYear() - this.fYearIncr);
    }

    private void changeMonth() {
        for (int count = 0; count < this.fMonthIncr; ++count) {
            this.stepMonth();
        }
    }

    private void changeDay() {
        for (int count = 0; count < this.fDayIncr; ++count) {
            this.stepDay();
        }
    }

    private void changeHour() {
        for (int count = 0; count < this.fHourIncr; ++count) {
            this.stepHour();
        }
    }

    private void changeMinute() {
        for (int count = 0; count < this.fMinuteIncr; ++count) {
            this.stepMinute();
        }
    }

    private void changeSecond() {
        for (int count = 0; count < this.fSecondIncr; ++count) {
            this.stepSecond();
        }
    }

    private void changeNanosecond() {
        this.fNanosecond = this.fIsPlus ? Integer.valueOf(this.fNanosecond + this.fNanosecondIncr) : Integer.valueOf(this.fNanosecond - this.fNanosecondIncr);
        if (this.fNanosecond > 999999999) {
            this.stepSecond();
            this.fNanosecond = this.fNanosecond - 999999999 - 1;
        } else if (this.fNanosecond < 0) {
            this.stepSecond();
            this.fNanosecond = 999999999 + this.fNanosecond + 1;
        }
    }

    private void stepYear() {
        this.fYear = this.fIsPlus ? Integer.valueOf(this.fYear + 1) : Integer.valueOf(this.fYear - 1);
    }

    private void stepMonth() {
        this.fMonth = this.fIsPlus ? Integer.valueOf(this.fMonth + 1) : Integer.valueOf(this.fMonth - 1);
        if (this.fMonth > 12) {
            this.fMonth = 1;
            this.stepYear();
        } else if (this.fMonth < 1) {
            this.fMonth = 12;
            this.stepYear();
        }
    }

    private void stepDay() {
        this.fDay = this.fIsPlus ? Integer.valueOf(this.fDay + 1) : Integer.valueOf(this.fDay - 1);
        if (this.fDay > this.numDaysInMonth()) {
            this.fDay = 1;
            this.stepMonth();
        } else if (this.fDay < 1) {
            this.fDay = this.numDaysInPreviousMonth();
            this.stepMonth();
        }
    }

    private int numDaysInMonth() {
        return DateTime.getNumDaysInMonth(this.fYear, this.fMonth);
    }

    private int numDaysInPreviousMonth() {
        int result = 0;
        result = this.fMonth > 1 ? DateTime.getNumDaysInMonth(this.fYear, this.fMonth - 1).intValue() : DateTime.getNumDaysInMonth(this.fYear - 1, 12).intValue();
        return result;
    }

    private void stepHour() {
        this.fHour = this.fIsPlus ? Integer.valueOf(this.fHour + 1) : Integer.valueOf(this.fHour - 1);
        if (this.fHour > 23) {
            this.fHour = 0;
            this.stepDay();
        } else if (this.fHour < 0) {
            this.fHour = 23;
            this.stepDay();
        }
    }

    private void stepMinute() {
        this.fMinute = this.fIsPlus ? Integer.valueOf(this.fMinute + 1) : Integer.valueOf(this.fMinute - 1);
        if (this.fMinute > 59) {
            this.fMinute = 0;
            this.stepHour();
        } else if (this.fMinute < 0) {
            this.fMinute = 59;
            this.stepHour();
        }
    }

    private void stepSecond() {
        this.fSecond = this.fIsPlus ? Integer.valueOf(this.fSecond + 1) : Integer.valueOf(this.fSecond - 1);
        if (this.fSecond > 59) {
            this.fSecond = 0;
            this.stepMinute();
        } else if (this.fSecond < 0) {
            this.fSecond = 59;
            this.stepMinute();
        }
    }

    private void handleMonthOverflow() {
        int daysInMonth = this.numDaysInMonth();
        if (this.fDay > daysInMonth) {
            if (DateTime.DayOverflow.Abort == this.fDayOverflow) {
                throw new RuntimeException("Day Overflow: Year:" + this.fYear + " Month:" + this.fMonth + " has " + daysInMonth + " days, but day has value:" + this.fDay + " To avoid these exceptions, please specify a different DayOverflow policy.");
            }
            if (DateTime.DayOverflow.FirstDay == this.fDayOverflow) {
                this.fDay = 1;
                this.stepMonth();
            } else if (DateTime.DayOverflow.LastDay == this.fDayOverflow) {
                this.fDay = daysInMonth;
            } else if (DateTime.DayOverflow.Spillover == this.fDayOverflow) {
                int overflowAmount = this.fDay - daysInMonth;
                this.fDay = overflowAmount;
                this.stepMonth();
            }
        }
    }
}

