/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class TopologySpreadConstraintFluentImpl<A extends TopologySpreadConstraintFluent<A>>
extends BaseFluent<A>
implements TopologySpreadConstraintFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private Integer maxSkew;
    private Integer minDomains;
    private String topologyKey;
    private String whenUnsatisfiable;
    private Map<String, Object> additionalProperties;

    public TopologySpreadConstraintFluentImpl() {
    }

    public TopologySpreadConstraintFluentImpl(TopologySpreadConstraint instance) {
        this.withLabelSelector(instance.getLabelSelector());
        this.withMaxSkew(instance.getMaxSkew());
        this.withMinDomains(instance.getMinDomains());
        this.withTopologyKey(instance.getTopologyKey());
        this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public LabelSelector getLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get("labelSelector").remove(this.labelSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector());
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : item);
    }

    @Override
    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    @Override
    public A withMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
        return (A)this;
    }

    @Override
    public Boolean hasMaxSkew() {
        return this.maxSkew != null;
    }

    @Override
    public Integer getMinDomains() {
        return this.minDomains;
    }

    @Override
    public A withMinDomains(Integer minDomains) {
        this.minDomains = minDomains;
        return (A)this;
    }

    @Override
    public Boolean hasMinDomains() {
        return this.minDomains != null;
    }

    @Override
    public String getTopologyKey() {
        return this.topologyKey;
    }

    @Override
    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    @Override
    public String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    @Override
    public A withWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
        return (A)this;
    }

    @Override
    public Boolean hasWhenUnsatisfiable() {
        return this.whenUnsatisfiable != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologySpreadConstraintFluentImpl that = (TopologySpreadConstraintFluentImpl)o;
        if (this.labelSelector != null ? !this.labelSelector.equals(that.labelSelector) : that.labelSelector != null) {
            return false;
        }
        if (this.maxSkew != null ? !this.maxSkew.equals(that.maxSkew) : that.maxSkew != null) {
            return false;
        }
        if (this.minDomains != null ? !this.minDomains.equals(that.minDomains) : that.minDomains != null) {
            return false;
        }
        if (this.topologyKey != null ? !this.topologyKey.equals(that.topologyKey) : that.topologyKey != null) {
            return false;
        }
        if (this.whenUnsatisfiable != null ? !this.whenUnsatisfiable.equals(that.whenUnsatisfiable) : that.whenUnsatisfiable != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.labelSelector, this.maxSkew, this.minDomains, this.topologyKey, this.whenUnsatisfiable, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector + ",");
        }
        if (this.maxSkew != null) {
            sb.append("maxSkew:");
            sb.append(this.maxSkew + ",");
        }
        if (this.minDomains != null) {
            sb.append("minDomains:");
            sb.append(this.minDomains + ",");
        }
        if (this.topologyKey != null) {
            sb.append("topologyKey:");
            sb.append(this.topologyKey + ",");
        }
        if (this.whenUnsatisfiable != null) {
            sb.append("whenUnsatisfiable:");
            sb.append(this.whenUnsatisfiable + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class LabelSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<TopologySpreadConstraintFluent.LabelSelectorNested<N>>
    implements TopologySpreadConstraintFluent.LabelSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)TopologySpreadConstraintFluentImpl.this.withLabelSelector(this.builder.build());
        }

        @Override
        public N endLabelSelector() {
            return this.and();
        }
    }
}

