/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file.instrumentation;

import org.apache.flume.channel.file.instrumentation.FileChannelCounterMBean;
import org.apache.flume.instrumentation.ChannelCounter;

public class FileChannelCounter
extends ChannelCounter
implements FileChannelCounterMBean {
    private boolean open;
    private int unhealthy;
    private static final String EVENT_PUT_ERROR_COUNT = "channel.file.event.put.error";
    private static final String EVENT_TAKE_ERROR_COUNT = "channel.file.event.take.error";
    private static final String CHECKPOINT_WRITE_ERROR_COUNT = "channel.file.checkpoint.write.error";
    private static final String CHECKPOINT_BACKUP_WRITE_ERROR_COUNT = "channel.file.checkpoint.backup.write.error";

    public FileChannelCounter(String name) {
        super(name, new String[]{EVENT_PUT_ERROR_COUNT, EVENT_TAKE_ERROR_COUNT, CHECKPOINT_WRITE_ERROR_COUNT, CHECKPOINT_BACKUP_WRITE_ERROR_COUNT});
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public int getClosed() {
        return this.open ? 0 : 1;
    }

    @Override
    public int getUnhealthy() {
        return this.unhealthy;
    }

    public void setUnhealthy(int unhealthy) {
        this.unhealthy = unhealthy;
    }

    @Override
    public long getEventPutErrorCount() {
        return this.get(EVENT_PUT_ERROR_COUNT);
    }

    public void incrementEventPutErrorCount() {
        this.increment(EVENT_PUT_ERROR_COUNT);
    }

    @Override
    public long getEventTakeErrorCount() {
        return this.get(EVENT_TAKE_ERROR_COUNT);
    }

    public void incrementEventTakeErrorCount() {
        this.increment(EVENT_TAKE_ERROR_COUNT);
    }

    @Override
    public long getCheckpointWriteErrorCount() {
        return this.get(CHECKPOINT_WRITE_ERROR_COUNT);
    }

    public void incrementCheckpointWriteErrorCount() {
        this.increment(CHECKPOINT_WRITE_ERROR_COUNT);
    }

    @Override
    public long getCheckpointBackupWriteErrorCount() {
        return this.get(CHECKPOINT_BACKUP_WRITE_ERROR_COUNT);
    }

    public void incrementCheckpointBackupWriteErrorCount() {
        this.increment(CHECKPOINT_BACKUP_WRITE_ERROR_COUNT);
    }
}

