/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.keys;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;

@Internal
public final class KeySelectorUtil {
    public static <X> KeySelector<X, Tuple> getSelectorForKeys(Keys<X> keys, TypeInformation<X> typeInfo, ExecutionConfig executionConfig) {
        if (!(typeInfo instanceof CompositeType)) {
            throw new InvalidTypesException("This key operation requires a composite type such as Tuples, POJOs, or Case Classes.");
        }
        CompositeType compositeType = (CompositeType)typeInfo;
        int[] logicalKeyPositions = keys.computeLogicalKeyPositions();
        int numKeyFields = logicalKeyPositions.length;
        TypeInformation[] typeInfos = keys.getKeyFieldTypes();
        boolean[] orders = new boolean[numKeyFields];
        for (int i = 0; i < numKeyFields; ++i) {
            orders[i] = true;
        }
        TypeComparator comparator = compositeType.createComparator(logicalKeyPositions, orders, 0, executionConfig);
        return new ComparableKeySelector(comparator, numKeyFields, (TupleTypeInfo<Tuple>)new TupleTypeInfo(typeInfos));
    }

    public static <X> ArrayKeySelector<X> getSelectorForArray(int[] positions, TypeInformation<X> typeInfo) {
        TypeInformation componentType;
        if (positions == null || positions.length == 0 || positions.length > 25) {
            throw new IllegalArgumentException("Array keys must have between 1 and 25 fields.");
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            BasicArrayTypeInfo arrayInfo = (BasicArrayTypeInfo)typeInfo;
            componentType = arrayInfo.getComponentInfo();
        } else if (typeInfo instanceof PrimitiveArrayTypeInfo) {
            PrimitiveArrayTypeInfo arrayType = (PrimitiveArrayTypeInfo)typeInfo;
            componentType = arrayType.getComponentType();
        } else {
            throw new IllegalArgumentException("This method only supports arrays of primitives and boxed primitives.");
        }
        Object[] primitiveInfos = new TypeInformation[positions.length];
        Arrays.fill(primitiveInfos, componentType);
        return new ArrayKeySelector(positions, (TupleTypeInfo<Tuple>)new TupleTypeInfo((TypeInformation[])primitiveInfos));
    }

    public static <X, K> KeySelector<X, K> getSelectorForOneKey(Keys<X> keys, Partitioner<K> partitioner, TypeInformation<X> typeInfo, ExecutionConfig executionConfig) {
        if (!(typeInfo instanceof CompositeType)) {
            throw new InvalidTypesException("This key operation requires a composite type such as Tuples, POJOs, case classes, etc");
        }
        if (partitioner != null) {
            keys.validateCustomPartitioner(partitioner, null);
        }
        CompositeType compositeType = (CompositeType)typeInfo;
        int[] logicalKeyPositions = keys.computeLogicalKeyPositions();
        if (logicalKeyPositions.length != 1) {
            throw new IllegalArgumentException("There must be exactly 1 key specified");
        }
        TypeComparator comparator = compositeType.createComparator(logicalKeyPositions, new boolean[]{true}, 0, executionConfig);
        return new OneKeySelector(comparator);
    }

    private KeySelectorUtil() {
        throw new RuntimeException();
    }

    public static final class ArrayKeySelector<IN>
    implements KeySelector<IN, Tuple>,
    ResultTypeQueryable<Tuple> {
        private static final long serialVersionUID = 1L;
        private final int[] fields;
        private transient TupleTypeInfo<Tuple> returnType;

        ArrayKeySelector(int[] fields, TupleTypeInfo<Tuple> returnType) {
            this.fields = Objects.requireNonNull(fields);
            this.returnType = Objects.requireNonNull(returnType);
        }

        public Tuple getKey(IN value) {
            Tuple key = Tuple.newInstance((int)this.fields.length);
            for (int i = 0; i < this.fields.length; ++i) {
                key.setField(Array.get(value, this.fields[i]), i);
            }
            return key;
        }

        public TypeInformation<Tuple> getProducedType() {
            if (this.returnType == null) {
                throw new IllegalStateException("The return type information is not available after serialization");
            }
            return this.returnType;
        }
    }

    public static final class ComparableKeySelector<IN>
    implements KeySelector<IN, Tuple>,
    ResultTypeQueryable<Tuple> {
        private static final long serialVersionUID = 1L;
        private final TypeComparator<IN> comparator;
        private final int keyLength;
        private transient TupleTypeInfo<Tuple> tupleTypeInfo;
        private final Object[] keyArray;

        ComparableKeySelector(TypeComparator<IN> comparator, int keyLength, TupleTypeInfo<Tuple> tupleTypeInfo) {
            this.comparator = comparator;
            this.keyLength = keyLength;
            this.tupleTypeInfo = tupleTypeInfo;
            this.keyArray = new Object[keyLength];
        }

        public Tuple getKey(IN value) {
            Tuple key = Tuple.newInstance((int)this.keyLength);
            this.comparator.extractKeys(value, this.keyArray, 0);
            for (int i = 0; i < this.keyLength; ++i) {
                key.setField(this.keyArray[i], i);
            }
            return key;
        }

        public TypeInformation<Tuple> getProducedType() {
            if (this.tupleTypeInfo == null) {
                throw new IllegalStateException("The return type information is not available after serialization");
            }
            return this.tupleTypeInfo;
        }
    }

    public static final class OneKeySelector<IN, K>
    implements KeySelector<IN, K> {
        private static final long serialVersionUID = 1L;
        private final TypeComparator<IN> comparator;
        private final Object[] keyArray;

        OneKeySelector(TypeComparator<IN> comparator) {
            this.comparator = comparator;
            this.keyArray = new Object[1];
        }

        public K getKey(IN value) throws Exception {
            this.comparator.extractKeys(value, this.keyArray, 0);
            return (K)this.keyArray[0];
        }
    }
}

