/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.AvroFormat;
import org.apache.inlong.sort.protocol.node.format.CanalJsonFormat;
import org.apache.inlong.sort.protocol.node.format.CsvFormat;
import org.apache.inlong.sort.protocol.node.format.DebeziumJsonFormat;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.format.JsonFormat;
import org.apache.inlong.sort.protocol.node.format.RawFormat;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="kafkaLoad")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KafkaLoadNode
extends LoadNode
implements InlongMetric,
Metadata,
Serializable {
    private static final long serialVersionUID = -558158965060708408L;
    @Nonnull
    @JsonProperty(value="topic")
    private String topic;
    @Nonnull
    @JsonProperty(value="bootstrapServers")
    private String bootstrapServers;
    @Nonnull
    @JsonProperty(value="format")
    private Format format;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @Nullable
    @JsonProperty(value="topicPattern")
    private String topicPattern;
    @Nullable
    @JsonProperty(value="sinkMultipleFormat")
    private Format sinkMultipleFormat;
    @Nullable
    @JsonProperty(value="sinkPartitioner")
    private String sinkPartitioner;
    @Nullable
    @JsonProperty(value="partitionPattern")
    private String partitionPattern;

    public KafkaLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nonnull @JsonProperty(value="topic") String topic, @Nonnull @JsonProperty(value="bootstrapServers") String bootstrapServers, @Nonnull @JsonProperty(value="format") Format format, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="primaryKey") String primaryKey) {
        this(id, name, fields, fieldRelations, filters, filterStrategy, topic, bootstrapServers, format, sinkParallelism, properties, primaryKey, null, null, null, null);
    }

    @JsonCreator
    public KafkaLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nonnull @JsonProperty(value="topic") String topic, @Nonnull @JsonProperty(value="bootstrapServers") String bootstrapServers, @Nonnull @JsonProperty(value="format") Format format, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="primaryKey") String primaryKey, @Nullable @JsonProperty(value="sinkMultipleFormat") Format sinkMultipleFormat, @Nullable @JsonProperty(value="topicPattern") String topicPattern, @Nullable @JsonProperty(value="sinkPartitioner") String sinkPartitioner, @Nullable @JsonProperty(value="partitionPattern") String partitionPattern) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"topic is null");
        this.bootstrapServers = (String)Preconditions.checkNotNull((Object)bootstrapServers, (Object)"bootstrapServers is null");
        this.format = (Format)Preconditions.checkNotNull((Object)format, (Object)"format is null");
        this.primaryKey = primaryKey;
        this.sinkMultipleFormat = sinkMultipleFormat;
        this.topicPattern = topicPattern;
        this.sinkPartitioner = sinkPartitioner;
        this.partitionPattern = "raw-hash".equals(sinkPartitioner) ? (String)Preconditions.checkNotNull((Object)partitionPattern, (Object)"partitionPattern is null when the sinkPartitioner is 'raw-hash'") : partitionPattern;
    }

    @Override
    public String genTableName() {
        return "node_" + super.getId() + "_" + this.topic;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("topic", this.topic);
        options.put("properties.bootstrap.servers", this.bootstrapServers);
        if (this.getSinkParallelism() != null) {
            options.put("sink.parallelism", this.getSinkParallelism().toString());
        }
        if (this.format instanceof JsonFormat || this.format instanceof AvroFormat || this.format instanceof CsvFormat || this.format instanceof RawFormat) {
            if (StringUtils.isEmpty((CharSequence)this.primaryKey)) {
                options.put("connector", "kafka-inlong");
                options.put("sink.ignore.changelog", "true");
                options.putAll(this.format.generateOptions(false));
            } else {
                options.put("connector", "upsert-kafka-inlong");
                options.putAll(this.format.generateOptions(true));
            }
            if (this.format instanceof RawFormat) {
                if (this.sinkMultipleFormat != null) {
                    options.put("sink.multiple.format", this.sinkMultipleFormat.identifier());
                }
                if (StringUtils.isNotBlank((CharSequence)this.topicPattern)) {
                    options.put("topic-pattern", this.topicPattern);
                }
                if (StringUtils.isNotBlank((CharSequence)this.sinkPartitioner)) {
                    options.put("sink.partitioner", this.sinkPartitioner);
                }
                if (StringUtils.isNotBlank((CharSequence)this.partitionPattern)) {
                    options.put("sink.multiple.partition-pattern", this.partitionPattern);
                }
            }
        } else if (this.format instanceof CanalJsonFormat || this.format instanceof DebeziumJsonFormat) {
            options.put("connector", "kafka-inlong");
            options.putAll(this.format.generateOptions(false));
        } else {
            throw new IllegalArgumentException("kafka load Node format is IllegalArgument");
        }
        return options;
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case TABLE_NAME: {
                metadataKey = "value.table";
                break;
            }
            case DATABASE_NAME: {
                metadataKey = "value.database";
                break;
            }
            case SQL_TYPE: {
                metadataKey = "value.sql-type";
                break;
            }
            case PK_NAMES: {
                metadataKey = "value.pk-names";
                break;
            }
            case TS: {
                metadataKey = "value.ingestion-timestamp";
                break;
            }
            case OP_TS: {
                metadataKey = "value.event-timestamp";
                break;
            }
            case OP_TYPE: {
                metadataKey = "value.type";
                break;
            }
            case DATA: 
            case DATA_CANAL: {
                metadataKey = "value.data_canal";
                break;
            }
            case IS_DDL: {
                metadataKey = "value.is-ddl";
                break;
            }
            case MYSQL_TYPE: {
                metadataKey = "value.mysql-type";
                break;
            }
            case BATCH_ID: {
                metadataKey = "value.batch-id";
                break;
            }
            case UPDATE_BEFORE: {
                metadataKey = "value.update-before";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", this.getClass().getSimpleName(), metaField));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return false;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.PROCESS_TIME, new MetaField[]{MetaField.TABLE_NAME, MetaField.OP_TYPE, MetaField.DATABASE_NAME, MetaField.SQL_TYPE, MetaField.PK_NAMES, MetaField.TS, MetaField.OP_TS, MetaField.IS_DDL, MetaField.MYSQL_TYPE, MetaField.BATCH_ID, MetaField.UPDATE_BEFORE, MetaField.DATA_CANAL, MetaField.DATA});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaLoadNode)) {
            return false;
        }
        KafkaLoadNode other = (KafkaLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$topicPattern = this.getTopicPattern();
        String other$topicPattern = other.getTopicPattern();
        if (this$topicPattern == null ? other$topicPattern != null : !this$topicPattern.equals(other$topicPattern)) {
            return false;
        }
        Format this$sinkMultipleFormat = this.getSinkMultipleFormat();
        Format other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$sinkPartitioner = this.getSinkPartitioner();
        String other$sinkPartitioner = other.getSinkPartitioner();
        if (this$sinkPartitioner == null ? other$sinkPartitioner != null : !this$sinkPartitioner.equals(other$sinkPartitioner)) {
            return false;
        }
        String this$partitionPattern = this.getPartitionPattern();
        String other$partitionPattern = other.getPartitionPattern();
        return !(this$partitionPattern == null ? other$partitionPattern != null : !this$partitionPattern.equals(other$partitionPattern));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $topicPattern = this.getTopicPattern();
        result = result * 59 + ($topicPattern == null ? 43 : $topicPattern.hashCode());
        Format $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $sinkPartitioner = this.getSinkPartitioner();
        result = result * 59 + ($sinkPartitioner == null ? 43 : $sinkPartitioner.hashCode());
        String $partitionPattern = this.getPartitionPattern();
        result = result * 59 + ($partitionPattern == null ? 43 : $partitionPattern.hashCode());
        return result;
    }

    @Nonnull
    public String getTopic() {
        return this.topic;
    }

    @Nonnull
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Nullable
    public String getTopicPattern() {
        return this.topicPattern;
    }

    @Nullable
    public Format getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    @Nullable
    public String getSinkPartitioner() {
        return this.sinkPartitioner;
    }

    @Nullable
    public String getPartitionPattern() {
        return this.partitionPattern;
    }

    public void setTopic(@Nonnull String topic) {
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        this.topic = topic;
    }

    public void setBootstrapServers(@Nonnull String bootstrapServers) {
        if (bootstrapServers == null) {
            throw new NullPointerException("bootstrapServers is marked non-null but is null");
        }
        this.bootstrapServers = bootstrapServers;
    }

    public void setFormat(@Nonnull Format format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setTopicPattern(@Nullable String topicPattern) {
        this.topicPattern = topicPattern;
    }

    public void setSinkMultipleFormat(@Nullable Format sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setSinkPartitioner(@Nullable String sinkPartitioner) {
        this.sinkPartitioner = sinkPartitioner;
    }

    public void setPartitionPattern(@Nullable String partitionPattern) {
        this.partitionPattern = partitionPattern;
    }

    @Override
    public String toString() {
        return "KafkaLoadNode(topic=" + this.getTopic() + ", bootstrapServers=" + this.getBootstrapServers() + ", format=" + this.getFormat() + ", primaryKey=" + this.getPrimaryKey() + ", topicPattern=" + this.getTopicPattern() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", sinkPartitioner=" + this.getSinkPartitioner() + ", partitionPattern=" + this.getPartitionPattern() + ")";
    }

    public KafkaLoadNode() {
    }
}

