/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.transform.TransformRequest;

public class InnerStreamContext {
    private InlongStreamInfo streamInfo;
    private Map<String, SourceRequest> sourceRequests = Maps.newHashMap();
    private Map<String, SinkRequest> sinkRequests = Maps.newHashMap();
    private Map<String, TransformRequest> transformRequests = Maps.newHashMap();

    public InnerStreamContext(InlongStreamInfo streamInfo) {
        this.streamInfo = streamInfo;
    }

    public void updateStreamFields(List<StreamField> fieldList) {
        this.streamInfo.setFieldList(fieldList);
    }

    public void setSourceRequest(SourceRequest sourceRequest) {
        this.sourceRequests.put(sourceRequest.getSourceName(), sourceRequest);
    }

    public void setSinkRequest(SinkRequest sinkRequest) {
        this.sinkRequests.put(sinkRequest.getSinkName(), sinkRequest);
    }

    public void setTransformRequest(TransformRequest transformRequest) {
        this.transformRequests.put(transformRequest.getTransformName(), transformRequest);
    }

    public InlongStreamInfo getStreamInfo() {
        return this.streamInfo;
    }

    public Map<String, SourceRequest> getSourceRequests() {
        return this.sourceRequests;
    }

    public Map<String, SinkRequest> getSinkRequests() {
        return this.sinkRequests;
    }

    public Map<String, TransformRequest> getTransformRequests() {
        return this.transformRequests;
    }

    public void setStreamInfo(InlongStreamInfo streamInfo) {
        this.streamInfo = streamInfo;
    }

    public void setSourceRequests(Map<String, SourceRequest> sourceRequests) {
        this.sourceRequests = sourceRequests;
    }

    public void setSinkRequests(Map<String, SinkRequest> sinkRequests) {
        this.sinkRequests = sinkRequests;
    }

    public void setTransformRequests(Map<String, TransformRequest> transformRequests) {
        this.transformRequests = transformRequests;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InnerStreamContext)) {
            return false;
        }
        InnerStreamContext other = (InnerStreamContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlongStreamInfo this$streamInfo = this.getStreamInfo();
        InlongStreamInfo other$streamInfo = other.getStreamInfo();
        if (this$streamInfo == null ? other$streamInfo != null : !this$streamInfo.equals(other$streamInfo)) {
            return false;
        }
        Map<String, SourceRequest> this$sourceRequests = this.getSourceRequests();
        Map<String, SourceRequest> other$sourceRequests = other.getSourceRequests();
        if (this$sourceRequests == null ? other$sourceRequests != null : !((Object)this$sourceRequests).equals(other$sourceRequests)) {
            return false;
        }
        Map<String, SinkRequest> this$sinkRequests = this.getSinkRequests();
        Map<String, SinkRequest> other$sinkRequests = other.getSinkRequests();
        if (this$sinkRequests == null ? other$sinkRequests != null : !((Object)this$sinkRequests).equals(other$sinkRequests)) {
            return false;
        }
        Map<String, TransformRequest> this$transformRequests = this.getTransformRequests();
        Map<String, TransformRequest> other$transformRequests = other.getTransformRequests();
        return !(this$transformRequests == null ? other$transformRequests != null : !((Object)this$transformRequests).equals(other$transformRequests));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InnerStreamContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlongStreamInfo $streamInfo = this.getStreamInfo();
        result = result * 59 + ($streamInfo == null ? 43 : $streamInfo.hashCode());
        Map<String, SourceRequest> $sourceRequests = this.getSourceRequests();
        result = result * 59 + ($sourceRequests == null ? 43 : ((Object)$sourceRequests).hashCode());
        Map<String, SinkRequest> $sinkRequests = this.getSinkRequests();
        result = result * 59 + ($sinkRequests == null ? 43 : ((Object)$sinkRequests).hashCode());
        Map<String, TransformRequest> $transformRequests = this.getTransformRequests();
        result = result * 59 + ($transformRequests == null ? 43 : ((Object)$transformRequests).hashCode());
        return result;
    }

    public String toString() {
        return "InnerStreamContext(streamInfo=" + this.getStreamInfo() + ", sourceRequests=" + this.getSourceRequests() + ", sinkRequests=" + this.getSinkRequests() + ", transformRequests=" + this.getTransformRequests() + ")";
    }

    public InnerStreamContext() {
    }
}

