/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.msgstore;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.broker.BrokerConfig;
import org.apache.inlong.tubemq.server.broker.metadata.TopicMetadata;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStoreManager;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.GetMessageResult;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.MsgFileStore;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.Segment;
import org.apache.inlong.tubemq.server.broker.msgstore.mem.GetCacheMsgResult;
import org.apache.inlong.tubemq.server.broker.msgstore.mem.MsgMemStore;
import org.apache.inlong.tubemq.server.broker.nodeinfo.ConsumerNodeInfo;
import org.apache.inlong.tubemq.server.broker.stats.MsgStoreStatsHolder;
import org.apache.inlong.tubemq.server.broker.stats.TrafficInfo;
import org.apache.inlong.tubemq.server.broker.utils.DataStoreUtils;
import org.apache.inlong.tubemq.server.common.utils.AppendResult;
import org.apache.inlong.tubemq.server.common.utils.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStore
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MessageStore.class);
    private static final long FLUSH_CONDITION_WAIT_DLT_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private final ReentrantLock flushMutex = new ReentrantLock();
    private final AtomicBoolean hasFlushBeenTriggered = new AtomicBoolean(false);
    private final TopicMetadata topicMetadata;
    private final IdWorker idWorker;
    private final int storeId;
    private final String storeKey;
    private final BrokerConfig tubeConfig;
    private final String primStorePath;
    private final AtomicLong lastMemFlushTime = new AtomicLong(0L);
    private final MessageStoreManager msgStoreMgr;
    private final MsgStoreStatsHolder msgStoreStatsHolder = new MsgStoreStatsHolder();
    private final MsgFileStore msgFileStore;
    private final ReentrantReadWriteLock writeCacheMutex = new ReentrantReadWriteLock();
    private final Condition flushWriteCacheCondition = this.writeCacheMutex.writeLock().newCondition();
    private final AtomicBoolean isFlushOngoing = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile int partitionNum;
    private final AtomicInteger unflushInterval = new AtomicInteger(0);
    private final AtomicInteger unflushThreshold = new AtomicInteger(0);
    private final AtomicInteger unflushDataHold = new AtomicInteger(0);
    private volatile int writeCacheMaxSize;
    private volatile int writeCacheMaxCnt;
    private volatile int writeCacheFlushIntvl;
    private final AtomicLong maxFileValidDurMs = new AtomicLong(0L);
    private int maxAllowRdSize = 262144;
    private final AtomicInteger memMaxIndexReadCnt = new AtomicInteger(6000);
    private final AtomicInteger fileMaxIndexReadCnt = new AtomicInteger(8000);
    private final AtomicInteger memMaxFilterIndexReadCnt = new AtomicInteger(this.memMaxIndexReadCnt.get() * 2);
    private final AtomicInteger fileMaxFilterIndexReadCnt = new AtomicInteger(this.fileMaxIndexReadCnt.get() * 3);
    private final AtomicInteger fileLowReqMaxFilterIndexReadCnt = new AtomicInteger(this.fileMaxIndexReadCnt.get() * 10);
    private final AtomicInteger fileMaxIndexReadSize = new AtomicInteger(this.fileMaxIndexReadCnt.get() * 28);
    private final AtomicInteger fileMaxFilterIndexReadSize = new AtomicInteger(this.fileMaxFilterIndexReadCnt.get() * 28);
    private final AtomicInteger fileLowReqMaxFilterIndexReadSize = new AtomicInteger(this.fileLowReqMaxFilterIndexReadCnt.get() * 28);
    private MsgMemStore msgMemStore;
    private MsgMemStore msgMemStoreBeingFlush;

    public MessageStore(MessageStoreManager messageStoreManager, TopicMetadata topicMetadata, int storeId, BrokerConfig tubeConfig, int maxMsgRDSize) throws IOException {
        this(messageStoreManager, topicMetadata, storeId, tubeConfig, 0L, maxMsgRDSize);
    }

    public MessageStore(MessageStoreManager messageStoreManager, TopicMetadata topicMetadata, int storeId, BrokerConfig tubeConfig, long offsetIfCreate, int maxMsgRDSize) throws IOException {
        this.topicMetadata = topicMetadata;
        this.storeId = storeId;
        this.tubeConfig = tubeConfig;
        this.msgStoreMgr = messageStoreManager;
        this.maxAllowRdSize = (int)((double)maxMsgRDSize * 0.5);
        this.storeKey = topicMetadata.getTopic() + "-" + this.storeId;
        this.idWorker = new IdWorker(0L);
        this.primStorePath = this.tubeConfig.getPrimaryPath();
        this.partitionNum = topicMetadata.getNumPartitions();
        this.unflushInterval.set(topicMetadata.getUnflushInterval());
        this.maxFileValidDurMs.set(this.parseDeletePolicy(topicMetadata.getDeletePolicy()));
        this.unflushThreshold.set(topicMetadata.getUnflushThreshold());
        this.unflushDataHold.set(topicMetadata.getUnflushDataHold());
        this.writeCacheMaxCnt = topicMetadata.getMemCacheMsgCnt();
        this.writeCacheMaxSize = this.validAndGetMemCacheSize(topicMetadata);
        this.writeCacheFlushIntvl = topicMetadata.getMemCacheFlushIntvl();
        int tmpIndexReadCnt = tubeConfig.getIndexTransCount() * this.partitionNum;
        this.memMaxIndexReadCnt.set(MixedUtils.mid((int)tmpIndexReadCnt, (int)6000, (int)10000));
        this.fileMaxIndexReadCnt.set(MixedUtils.mid((int)tmpIndexReadCnt, (int)8000, (int)13500));
        this.memMaxFilterIndexReadCnt.set(this.memMaxIndexReadCnt.get() * 2);
        this.fileMaxFilterIndexReadCnt.set(this.fileMaxIndexReadCnt.get() * 3);
        this.fileLowReqMaxFilterIndexReadCnt.set(this.fileMaxFilterIndexReadCnt.get() * 10);
        this.fileMaxIndexReadSize.set(this.fileMaxIndexReadCnt.get() * 28);
        this.fileMaxFilterIndexReadSize.set(this.fileMaxFilterIndexReadCnt.get() * 28);
        this.fileLowReqMaxFilterIndexReadSize.set(this.fileLowReqMaxFilterIndexReadCnt.get() * 28);
        this.msgFileStore = new MsgFileStore(this, this.tubeConfig, this.primStorePath, offsetIfCreate);
        if (this.tubeConfig.isEnableMemStore()) {
            this.msgMemStore = new MsgMemStore(this.writeCacheMaxSize, this.writeCacheMaxCnt, this.msgFileStore.getDataMaxOffset(), this.msgFileStore.getIndexMaxOffset());
            this.msgMemStoreBeingFlush = new MsgMemStore(this.writeCacheMaxSize, this.writeCacheMaxCnt, this.msgFileStore.getDataMaxOffset(), this.msgFileStore.getIndexMaxOffset());
            this.lastMemFlushTime.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetMessageResult getMessages(int reqSwitch, long requestOffset, int partitionId, ConsumerNodeInfo consumerNodeInfo, String statsKeyBase, int msgSizeLimit, long reqRcvTime) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(new StringBuilder(512).append("[Data Store] Closed MessageStore for storeKey ").append(this.storeKey).toString());
        }
        int result = 0;
        boolean inMemCache = false;
        int maxIndexReadLength = this.memMaxIndexReadCnt.get();
        GetCacheMsgResult memMsgRlt = new GetCacheMsgResult(false, 404, requestOffset, "Can't found Message by index in cache");
        int n = reqSwitch <= 0 ? 0 : (reqSwitch = consumerNodeInfo.isFilterConsume() ? reqSwitch % 100 : reqSwitch / 100);
        if (this.tubeConfig.isEnableMemStore() && reqSwitch > 1) {
            long maxIndexOffset = -2L;
            if (requestOffset >= this.msgFileStore.getIndexMaxOffset()) {
                this.writeCacheMutex.readLock().lock();
                try {
                    maxIndexOffset = this.msgMemStore.getIndexLastWritePos();
                    result = this.msgMemStoreBeingFlush.isOffsetInHold(requestOffset);
                    if (result >= 0) {
                        inMemCache = true;
                        if (result > 0) {
                            if (reqSwitch > 2) {
                                memMsgRlt = this.msgMemStore.getMessages(consumerNodeInfo.getLastDataRdOffset(), requestOffset, this.msgStoreMgr.getMaxMsgTransferSize(), maxIndexReadLength, partitionId, false, consumerNodeInfo.isFilterConsume(), consumerNodeInfo.getFilterCondCodeSet(), reqRcvTime);
                            }
                        } else {
                            memMsgRlt = this.msgMemStoreBeingFlush.getMessages(consumerNodeInfo.getLastDataRdOffset(), requestOffset, this.msgStoreMgr.getMaxMsgTransferSize(), maxIndexReadLength, partitionId, true, consumerNodeInfo.isFilterConsume(), consumerNodeInfo.getFilterCondCodeSet(), reqRcvTime);
                        }
                    }
                }
                finally {
                    this.writeCacheMutex.readLock().unlock();
                }
            }
            if (inMemCache) {
                if (memMsgRlt.isSuccess) {
                    HashMap<String, TrafficInfo> countMap = new HashMap<String, TrafficInfo>();
                    ArrayList<ClientBroker.TransferedMessage> transferedMessageList = new ArrayList<ClientBroker.TransferedMessage>();
                    if (!memMsgRlt.cacheMsgList.isEmpty()) {
                        StringBuilder strBuffer = new StringBuilder(512);
                        for (ByteBuffer dataBuffer : memMsgRlt.cacheMsgList) {
                            ClientBroker.TransferedMessage transferedMessage = DataStoreUtils.getTransferMsg(dataBuffer, dataBuffer.array().length, countMap, statsKeyBase, strBuffer);
                            if (transferedMessage == null) continue;
                            transferedMessageList.add(transferedMessage);
                        }
                    }
                    GetMessageResult getResult = new GetMessageResult(true, 0, memMsgRlt.errInfo, requestOffset, memMsgRlt.dltOffset, memMsgRlt.lastRdDataOff, memMsgRlt.totalMsgSize, countMap, transferedMessageList);
                    getResult.setMaxOffset(maxIndexOffset);
                    return getResult;
                }
                return new GetMessageResult(false, memMsgRlt.retCode, requestOffset, memMsgRlt.dltOffset, memMsgRlt.errInfo);
            }
        }
        long reqNewOffset = Math.max(requestOffset, this.msgFileStore.getIndexMinOffset());
        if (reqSwitch <= 1 && reqNewOffset >= this.getFileIndexMaxOffset()) {
            return new GetMessageResult(false, 404, reqNewOffset, 0, "current offset is exceed max file offset");
        }
        maxIndexReadLength = consumerNodeInfo.isFilterConsume() ? this.fileMaxFilterIndexReadSize.get() : this.fileMaxIndexReadSize.get();
        ByteBuffer indexBuffer = ByteBuffer.allocate(maxIndexReadLength);
        Segment indexRecordView = this.msgFileStore.indexSlice(reqNewOffset, maxIndexReadLength);
        if (indexRecordView == null) {
            if (reqNewOffset < this.msgFileStore.getIndexMinOffset()) {
                return new GetMessageResult(false, 301, reqNewOffset, 0, "current offset is exceed min offset!");
            }
            return new GetMessageResult(false, 404, reqNewOffset, 0, "current offset is exceed max offset!");
        }
        indexRecordView.read(indexBuffer, reqNewOffset);
        indexBuffer.flip();
        indexRecordView.relViewRef();
        if (this.msgFileStore.getDataHighMaxOffset() - consumerNodeInfo.getLastDataRdOffset() >= this.tubeConfig.getDoubleDefaultDeduceReadSize() && msgSizeLimit > this.maxAllowRdSize) {
            msgSizeLimit = this.maxAllowRdSize;
        }
        GetMessageResult retResult = this.msgFileStore.getMessages(partitionId, consumerNodeInfo.getLastDataRdOffset(), reqNewOffset, indexBuffer, consumerNodeInfo.isFilterConsume(), consumerNodeInfo.getFilterCondCodeSet(), statsKeyBase, msgSizeLimit, reqRcvTime);
        if (reqSwitch <= 1) {
            retResult.setMaxOffset(this.getFileIndexMaxOffset());
        } else {
            retResult.setMaxOffset(this.getIndexMaxOffset());
        }
        if (consumerNodeInfo.isFilterConsume() && retResult.isSuccess && retResult.getLastReadOffset() > 0 && this.getFileIndexMaxOffset() - reqNewOffset - (long)retResult.getLastReadOffset() < (long)this.fileLowReqMaxFilterIndexReadSize.get()) {
            retResult.setSlowFreq(true);
        }
        return retResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartOffsetByTimeStamp(long timestamp) {
        if (this.closed.get()) {
            throw new IllegalStateException(new StringBuilder(512).append("[Data Store] Closed MessageStore for storeKey ").append(this.storeKey).toString());
        }
        if (timestamp <= this.msgFileStore.getIndexMaxAppendTime() || !this.tubeConfig.isEnableMemStore()) {
            return this.msgFileStore.getStartOffsetByTimeStamp(timestamp);
        }
        this.writeCacheMutex.readLock().lock();
        try {
            if (timestamp <= this.msgMemStoreBeingFlush.getRightAppendTime()) {
                long l = this.msgMemStoreBeingFlush.getIndexStartWritePos();
                return l;
            }
            long l = this.msgMemStore.getIndexStartWritePos();
            return l;
        }
        finally {
            this.writeCacheMutex.readLock().unlock();
        }
    }

    public boolean appendMsg(AppendResult appendResult, int dataLength, int dataCheckSum, byte[] data, int msgTypeCode, int msgFlag, int partitionId, int sentAddr) throws IOException {
        return this.appendMsg2(appendResult, dataLength, dataCheckSum, data, msgTypeCode, msgFlag, partitionId, sentAddr, System.currentTimeMillis(), 3, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendMsg2(AppendResult appendResult, int dataLength, int dataCheckSum, byte[] data, int msgTypeCode, int msgFlag, int partitionId, int sentAddr, long receivedTime, int count, long waitRetryMs) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(new StringBuilder(512).append("[Data Store] Closed MessageStore for storeKey ").append(this.storeKey).toString());
        }
        long messageId = this.idWorker.nextId();
        int msgBufLen = 52 + dataLength;
        ByteBuffer dataBuffer = ByteBuffer.allocate(msgBufLen);
        dataBuffer.putInt(48 + dataLength);
        dataBuffer.putInt(46766264);
        dataBuffer.putInt(dataCheckSum);
        dataBuffer.putInt(partitionId);
        dataBuffer.putLong(-1L);
        dataBuffer.putLong(receivedTime);
        dataBuffer.putInt(sentAddr);
        dataBuffer.putInt(msgTypeCode);
        dataBuffer.putLong(messageId);
        dataBuffer.putInt(msgFlag);
        dataBuffer.put(data);
        dataBuffer.flip();
        ByteBuffer indexBuffer = ByteBuffer.allocate(28);
        indexBuffer.putInt(partitionId);
        indexBuffer.putLong(-1L);
        indexBuffer.putInt(msgBufLen);
        indexBuffer.putInt(msgTypeCode);
        indexBuffer.putLong(receivedTime);
        indexBuffer.flip();
        appendResult.putReceivedInfo(messageId, receivedTime);
        boolean appendSuss = true;
        long startTime = System.currentTimeMillis();
        if (this.tubeConfig.isEnableMemStore()) {
            do {
                this.writeCacheMutex.readLock().lock();
                try {
                    appendSuss = this.msgMemStore.appendMsg(this.msgStoreStatsHolder, partitionId, msgTypeCode, receivedTime, indexBuffer, msgBufLen, dataBuffer, appendResult);
                }
                finally {
                    this.writeCacheMutex.readLock().unlock();
                }
                if (appendSuss) {
                    this.msgStoreStatsHolder.addMsgWriteSuccess(msgBufLen, System.currentTimeMillis() - startTime);
                    return true;
                }
                if (this.triggerFlushAndAddMsg(true, false, partitionId, msgTypeCode, receivedTime, indexBuffer, msgBufLen, dataBuffer, appendResult)) {
                    this.msgStoreStatsHolder.addMsgWriteSuccess(msgBufLen, System.currentTimeMillis() - startTime);
                    return true;
                }
                ThreadUtils.sleep((long)waitRetryMs);
            } while (count-- >= 0);
            this.msgStoreStatsHolder.addMsgWriteFailure();
            return false;
        }
        StringBuilder strBuffer = new StringBuilder(512);
        Tuple3<Boolean, Long, Long> appendRet = this.msgFileStore.appendMsg(false, startTime, strBuffer, 1, 28, indexBuffer, msgBufLen, dataBuffer, receivedTime, receivedTime);
        appendResult.putAppendResult((Long)appendRet.getF1(), (Long)appendRet.getF2());
        if (((Boolean)appendRet.getF0()).booleanValue()) {
            this.msgStoreStatsHolder.addMsgWriteSuccess(msgBufLen, System.currentTimeMillis() - startTime);
        } else {
            this.msgStoreStatsHolder.addMsgWriteFailure();
        }
        return (Boolean)appendRet.getF0();
    }

    public void getMsgStoreStatsInfo(boolean needRefresh, StringBuilder strBuff) {
        this.msgStoreStatsHolder.getMsgStoreStatsInfo(needRefresh, strBuff);
    }

    public MsgStoreStatsHolder getMsgStoreStatsHolder() {
        return this.msgStoreStatsHolder;
    }

    public boolean runClearupPolicy(boolean onlyCheck) {
        if (this.closed.get()) {
            throw new IllegalStateException(new StringBuilder(512).append("[Data Store] Closed MessageStore for storeKey ").append(this.storeKey).toString());
        }
        return this.msgFileStore.runClearupPolicy(onlyCheck);
    }

    public void refreshUnflushThreshold(TopicMetadata topicMetadata) {
        if (this.closed.get()) {
            throw new IllegalStateException(new StringBuilder(512).append("[Data Store] Closed MessageStore for storeKey ").append(this.storeKey).toString());
        }
        this.partitionNum = topicMetadata.getNumPartitions();
        this.unflushInterval.set(topicMetadata.getUnflushInterval());
        this.unflushThreshold.set(topicMetadata.getUnflushThreshold());
        this.unflushDataHold.set(topicMetadata.getUnflushDataHold());
        this.maxFileValidDurMs.set(this.parseDeletePolicy(topicMetadata.getDeletePolicy()));
        int tmpIndexReadCnt = this.tubeConfig.getIndexTransCount() * this.partitionNum;
        this.memMaxIndexReadCnt.set(MixedUtils.mid((int)tmpIndexReadCnt, (int)6000, (int)10000));
        this.fileMaxIndexReadCnt.set(MixedUtils.mid((int)tmpIndexReadCnt, (int)8000, (int)13500));
        this.memMaxFilterIndexReadCnt.set(this.memMaxIndexReadCnt.get() * 2);
        this.fileMaxFilterIndexReadCnt.set(this.fileMaxIndexReadCnt.get() * 3);
        this.fileLowReqMaxFilterIndexReadCnt.set(this.fileMaxFilterIndexReadCnt.get() * 10);
        this.fileMaxIndexReadSize.set(this.fileMaxIndexReadCnt.get() * 28);
        this.fileMaxFilterIndexReadSize.set(this.fileMaxFilterIndexReadCnt.get() * 28);
        this.fileLowReqMaxFilterIndexReadSize.set(this.fileLowReqMaxFilterIndexReadCnt.get() * 28);
        this.writeCacheMutex.readLock().lock();
        try {
            this.writeCacheMaxCnt = topicMetadata.getMemCacheMsgCnt();
            this.writeCacheMaxSize = this.validAndGetMemCacheSize(topicMetadata);
            this.writeCacheFlushIntvl = topicMetadata.getMemCacheFlushIntvl();
        }
        finally {
            this.writeCacheMutex.readLock().unlock();
        }
    }

    public void flushFile() throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(new StringBuilder(512).append("[Data Store] Closed MessageStore for storeKey ").append(this.storeKey).toString());
        }
        this.msgFileStore.flushDiskFile();
    }

    public void flushMemCacheData() throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(new StringBuilder(512).append("[Data Store] Closed MessageStore for storeKey ").append(this.storeKey).toString());
        }
        if (this.tubeConfig.isEnableMemStore() && this.msgMemStore.getCurMsgCount() > 0 && System.currentTimeMillis() - this.lastMemFlushTime.get() >= (long)this.writeCacheFlushIntvl) {
            this.triggerFlushAndAddMsg(false, true, -1, 0, 0L, null, 0, null, null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            StringBuilder strBuffer = new StringBuilder(512);
            logger.info(strBuffer.append("[Data Store] Stop current Message store ").append(this.storeKey).toString());
            strBuffer.delete(0, strBuffer.length());
            if (this.tubeConfig.isEnableMemStore()) {
                ThreadUtils.sleep((long)100L);
                this.flush(strBuffer);
                this.msgMemStore.close();
                this.msgMemStoreBeingFlush.close();
                this.executor.shutdown();
            }
            this.msgFileStore.close();
            logger.info(strBuffer.append("[Data Store] Message store stopped").append(this.storeKey).toString());
        }
    }

    public String getTopic() {
        return this.topicMetadata.getTopic();
    }

    public int getStoreId() {
        return this.storeId;
    }

    public String getStoreKey() {
        return this.storeKey;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public String getPrimStorePath() {
        return this.primStorePath;
    }

    public int getUnflushInterval() {
        return this.unflushInterval.get();
    }

    public long getMaxFileValidDurMs() {
        return this.maxFileValidDurMs.get();
    }

    public int getUnflushThreshold() {
        return this.unflushThreshold.get();
    }

    public int getUnflushDataHold() {
        return this.unflushDataHold.get();
    }

    public long getFileIndexMaxOffset() {
        return this.msgFileStore.getIndexMaxHighOffset();
    }

    public long getIndexMaxOffset() {
        long lastOffset = 0L;
        if (this.tubeConfig.isEnableMemStore()) {
            this.writeCacheMutex.readLock().lock();
            try {
                lastOffset = this.msgMemStore.getIndexLastWritePos();
            }
            finally {
                this.writeCacheMutex.readLock().unlock();
            }
        } else {
            lastOffset = this.msgFileStore.getIndexMaxOffset();
        }
        return lastOffset;
    }

    public long getIndexMinOffset() {
        return this.msgFileStore.getIndexMinOffset();
    }

    public long getDataMinOffset() {
        return this.msgFileStore.getDataMinOffset();
    }

    public long getDataMaxOffset() {
        long lastOffset = 0L;
        if (this.tubeConfig.isEnableMemStore()) {
            this.writeCacheMutex.readLock().lock();
            try {
                lastOffset = this.msgMemStore.getDataLastWritePos();
            }
            finally {
                this.writeCacheMutex.readLock().unlock();
            }
        } else {
            lastOffset = this.msgFileStore.getDataMaxOffset();
        }
        return lastOffset;
    }

    public long getIndexStoreSize() {
        long totalSize = 0L;
        if (this.tubeConfig.isEnableMemStore()) {
            this.writeCacheMutex.readLock().lock();
            try {
                if (this.msgMemStore.getCurMsgCount() > 0) {
                    totalSize += (long)this.msgMemStore.getIndexCacheSize();
                }
                if (this.msgMemStoreBeingFlush.getCurMsgCount() > 0) {
                    totalSize += (long)this.msgMemStoreBeingFlush.getIndexCacheSize();
                }
            }
            finally {
                this.writeCacheMutex.readLock().unlock();
            }
        }
        return totalSize += this.msgFileStore.getIndexSizeInBytes();
    }

    public long getDataStoreSize() {
        long totalSize = 0L;
        if (this.tubeConfig.isEnableMemStore()) {
            this.writeCacheMutex.readLock().lock();
            try {
                if (this.msgMemStore.getCurMsgCount() > 0) {
                    totalSize += (long)this.msgMemStore.getCurDataCacheSize();
                }
                if (this.msgMemStoreBeingFlush.getCurMsgCount() > 0) {
                    totalSize += (long)this.msgMemStoreBeingFlush.getCurDataCacheSize();
                }
            }
            finally {
                this.writeCacheMutex.readLock().unlock();
            }
        }
        return totalSize += this.msgFileStore.getDataSizeInBytes();
    }

    private long parseDeletePolicy(String delPolicy) {
        String[] tmpStrs = delPolicy.split(",");
        if (tmpStrs.length != 2) {
            return 604800000L;
        }
        String validValStr = tmpStrs[1];
        try {
            if (validValStr.endsWith("m")) {
                return Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 60000L;
            }
            if (validValStr.endsWith("s")) {
                return Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 1000L;
            }
            if (validValStr.endsWith("h")) {
                return Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 3600000L;
            }
            return Long.parseLong(validValStr) * 3600000L;
        }
        catch (Throwable e) {
            return 604800000L;
        }
    }

    private int validAndGetMemCacheSize(TopicMetadata topicMetadata) {
        int memCacheSize = topicMetadata.getMemCacheMsgSize();
        if (memCacheSize < topicMetadata.getMinMemCacheSize()) {
            logger.info(new StringBuilder(512).append("[Data Store] ").append(this.getTopic()).append(" writeCacheMaxSize changed, from ").append(memCacheSize).append(" to ").append(topicMetadata.getMinMemCacheSize()).toString());
            memCacheSize = topicMetadata.getMinMemCacheSize();
        }
        return memCacheSize;
    }

    private boolean triggerFlushAndAddMsg(boolean needAdd, final boolean isTimeTrigger, int partitionId, int keyCode, long receivedTime, ByteBuffer indexEntry, int dataLength, ByteBuffer dataEntry, AppendResult appendResult) throws IOException {
        this.writeCacheMutex.writeLock().lock();
        try {
            if (!this.isFlushOngoing.get() && this.hasFlushBeenTriggered.compareAndSet(false, true)) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StringBuilder strBuffer = new StringBuilder(512);
                            MessageStore.this.flush(strBuffer);
                        }
                        catch (Throwable e) {
                            logger.error("[Data Store] Error during flush", e);
                        }
                        finally {
                            if (isTimeTrigger) {
                                MessageStore.this.msgStoreStatsHolder.addCacheTimeoutFlush();
                            }
                        }
                    }
                });
            } else {
                this.msgStoreStatsHolder.addCachePending();
            }
            long startTime = System.currentTimeMillis();
            while (this.hasFlushBeenTriggered.get()) {
                this.flushWriteCacheCondition.awaitNanos(FLUSH_CONDITION_WAIT_DLT_NS);
                if (System.currentTimeMillis() - startTime <= 2000L) continue;
                logger.warn(new StringBuilder(512).append("[Data Store] StoreKey=").append(this.storeKey).append(" Wait Cache flush write too long! wait time is ").append(System.currentTimeMillis() - startTime).toString());
                break;
            }
            if (needAdd) {
                boolean bl = this.msgMemStore.appendMsg(this.msgStoreStatsHolder, partitionId, keyCode, receivedTime, indexEntry, dataLength, dataEntry, appendResult);
                return bl;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(new StringBuilder(512).append("[Data Store] StoreKey=").append(this.storeKey).append(" Interrupted when triggerFlushAndAddMsg process for storekey ").append(this.storeKey).toString());
        }
        finally {
            this.writeCacheMutex.writeLock().unlock();
        }
        return false;
    }

    private void flush(StringBuilder strBuffer) throws IOException {
        long startTime = System.currentTimeMillis();
        this.flushMutex.lock();
        this.lastMemFlushTime.set(System.currentTimeMillis());
        try {
            this.swapWriteCache(strBuffer);
            if (logger.isDebugEnabled()) {
                logger.debug(strBuffer.append("[Data Store] StoreKey=").append(this.storeKey).append(" Flushing entries.count:").append(this.msgMemStoreBeingFlush.getCurMsgCount()).append(" -- getCachedSize ").append((double)this.msgMemStoreBeingFlush.getCurDataCacheSize() / 1024.0 / 1024.0).append(" Mb").toString());
                strBuffer.delete(0, strBuffer.length());
            }
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        finally {
            this.isFlushOngoing.set(false);
            this.flushMutex.unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(strBuffer.append("[Data Store] StoreKey=").append(this.storeKey).append(" Flushed time : ").append(System.currentTimeMillis() - startTime).append(" ms").toString());
                strBuffer.delete(0, strBuffer.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapWriteCache(StringBuilder strBuffer) throws Throwable {
        MsgMemStore tmpStore = null;
        boolean isRealloc = false;
        this.writeCacheMutex.writeLock().lock();
        try {
            long lastDataPos = this.msgMemStore.getDataLastWritePos();
            long lastIndexPos = this.msgMemStore.getIndexLastWritePos();
            tmpStore = this.msgMemStoreBeingFlush;
            this.msgMemStoreBeingFlush = this.msgMemStore;
            if (tmpStore.getMaxAllowedMsgCount() == this.writeCacheMaxCnt && tmpStore.getMaxDataCacheSize() == this.writeCacheMaxSize) {
                this.msgMemStore = tmpStore;
                this.msgMemStore.resetMemStoreStatus(lastDataPos, lastIndexPos);
            } else {
                isRealloc = true;
                this.msgMemStore = new MsgMemStore(this.writeCacheMaxSize, this.writeCacheMaxCnt, lastDataPos, lastIndexPos);
            }
            this.hasFlushBeenTriggered.set(false);
            this.flushWriteCacheCondition.signalAll();
        }
        finally {
            this.isFlushOngoing.set(true);
            this.writeCacheMutex.writeLock().unlock();
            if (isRealloc) {
                tmpStore.close();
                this.msgStoreStatsHolder.addCacheReAlloc();
                logger.info(strBuffer.append("[Data Store] Found ").append(this.getStoreKey()).append(" Cache capacity change, new MemSize=").append(this.writeCacheMaxSize).append(", new CacheCnt=").append(this.writeCacheMaxCnt).toString());
                strBuffer.delete(0, strBuffer.length());
            }
        }
        this.msgMemStoreBeingFlush.batchFlush(this.msgFileStore, strBuffer);
    }
}

