/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class Bytes {
    public static final int SIZEOF_LONG = 8;
    private static final Logger logger = LoggerFactory.getLogger(Bytes.class);

    public static int compareTo(byte[] left, byte[] right) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(left, 0, left.length, right, 0, right.length);
    }

    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(buffer1, offset1, length1, buffer2, offset2, length2);
    }

    static Comparer<byte[]> lexicographicalComparerJavaImpl() {
        return LexicographicalComparerHolder.PureJavaComparer.INSTANCE;
    }

    public static String toStringBinary(byte[] b) {
        if (b == null) {
            return "null";
        }
        return Bytes.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        String first = new String(b, off, len, StandardCharsets.ISO_8859_1);
        for (int i = 0; i < first.length(); ++i) {
            int ch = first.charAt(i) & 0xFF;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}\\|;:'\",.<>/?".indexOf(ch) >= 0) {
                result.append(first.charAt(i));
                continue;
            }
            result.append(String.format("\\x%02X", ch));
        }
        return result.toString();
    }

    static class LexicographicalComparerHolder {
        static final String UNSAFE_COMPARER_NAME = LexicographicalComparerHolder.class.getName() + "$UnsafeComparer";
        static final Comparer<byte[]> BEST_COMPARER = LexicographicalComparerHolder.getBestComparer();

        LexicographicalComparerHolder() {
        }

        static Comparer<byte[]> getBestComparer() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)theClass.getEnumConstants()[0];
                return comparer;
            }
            catch (Throwable t) {
                return Bytes.lexicographicalComparerJavaImpl();
            }
        }

        static enum UnsafeComparer implements Comparer<byte[]>
        {
            INSTANCE;

            private static final Unsafe theUnsafe;
            private static final int BYTE_ARRAY_BASE_OFFSET;
            private static final boolean littleEndian;

            static boolean lessThanUnsigned(long x1, long x2) {
                return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
            }

            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                int i;
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int minLength = Math.min(length1, length2);
                int minWords = minLength / 8;
                int offset1Adj = offset1 + BYTE_ARRAY_BASE_OFFSET;
                int offset2Adj = offset2 + BYTE_ARRAY_BASE_OFFSET;
                for (i = 0; i < minWords * 8; i += 8) {
                    int y;
                    long rw;
                    long lw = theUnsafe.getLong(buffer1, (long)offset1Adj + (long)i);
                    long diff = lw ^ (rw = theUnsafe.getLong(buffer2, (long)offset2Adj + (long)i));
                    if (diff == 0L) continue;
                    if (!littleEndian) {
                        return UnsafeComparer.lessThanUnsigned(lw, rw) ? -1 : 1;
                    }
                    int n = 0;
                    int x = (int)diff;
                    if (x == 0) {
                        x = (int)(diff >>> 32);
                        n = 32;
                    }
                    if ((y = x << 16) == 0) {
                        n += 16;
                    } else {
                        x = y;
                    }
                    y = x << 8;
                    if (y == 0) {
                        n += 8;
                    }
                    return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
                }
                for (i = minWords * 8; i < minLength; ++i) {
                    int a = buffer1[offset1 + i] & 0xFF;
                    int b = buffer2[offset2 + i] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }

            static {
                littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
                theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field f = Unsafe.class.getDeclaredField("theUnsafe");
                            f.setAccessible(true);
                            return f.get(null);
                        }
                        catch (NoSuchFieldException e) {
                            throw new Error();
                        }
                        catch (IllegalAccessException e) {
                            throw new Error();
                        }
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
            }
        }

        static enum PureJavaComparer implements Comparer<byte[]>
        {
            INSTANCE;


            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int end1 = offset1 + length1;
                int end2 = offset2 + length2;
                int i = offset1;
                for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                    int a = buffer1[i] & 0xFF;
                    int b = buffer2[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }
        }
    }

    static interface Comparer<T> {
        public int compareTo(T var1, int var2, int var3, T var4, int var5, int var6);
    }
}

